/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.clients;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.util.None;
import com.linkedin.d2.balancer.D2Client;
import com.linkedin.d2.balancer.Facilities;
import com.linkedin.d2.balancer.LoadBalancer;
import com.linkedin.d2.balancer.ServiceUnavailableException;
import com.linkedin.d2.balancer.properties.ServiceProperties;
import com.linkedin.d2.balancer.util.LoadBalancerUtil;
import com.linkedin.d2.discovery.event.PropertyEventThread;
import com.linkedin.d2.discovery.util.LogUtil;
import com.linkedin.r2.message.Request;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.transport.common.AbstractClient;
import com.linkedin.r2.transport.common.bridge.client.TransportClient;
import com.linkedin.r2.transport.common.bridge.client.TransportClientAdapter;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicClient
extends AbstractClient
implements D2Client {
    private static final Logger _log = LoggerFactory.getLogger(DynamicClient.class);
    private final LoadBalancer _balancer;
    private final Facilities _facilities;
    private final boolean _restOverStream;

    public DynamicClient(LoadBalancer balancer, Facilities facilities) {
        this(balancer, facilities, false);
    }

    public DynamicClient(LoadBalancer balancer, Facilities facilities, boolean restOverStream) {
        this._balancer = balancer;
        this._facilities = facilities;
        this._restOverStream = restOverStream;
        LogUtil.debug(_log, "created dynamic client: ", this);
    }

    public void restRequest(RestRequest request, RequestContext requestContext, Callback<RestResponse> callback) {
        if (!this._restOverStream) {
            Callback<RestResponse> transportCallback = DynamicClient.decorateCallback(callback, (Request)request, "rest");
            try {
                TransportClient client = this._balancer.getClient((Request)request, requestContext);
                if (client == null) {
                    throw new ServiceUnavailableException("unknown: " + request.getURI(), "got null client from load balancer");
                }
                new TransportClientAdapter(client, false).restRequest(request, requestContext, transportCallback);
            }
            catch (ServiceUnavailableException e) {
                callback.onError((Throwable)((Object)e));
                LogUtil.warn(_log, "unable to find service for: ", DynamicClient.extractLogInfo((Request)request));
            }
        } else {
            super.restRequest(request, requestContext, callback);
        }
    }

    public void streamRequest(StreamRequest request, RequestContext requestContext, Callback<StreamResponse> callback) {
        Callback<StreamResponse> transportCallback = DynamicClient.decorateCallback(callback, (Request)request, "stream");
        try {
            TransportClient client = this._balancer.getClient((Request)request, requestContext);
            if (client == null) {
                throw new ServiceUnavailableException("unknown: " + request.getURI(), "got null client from load balancer");
            }
            new TransportClientAdapter(client, true).streamRequest(request, requestContext, transportCallback);
        }
        catch (ServiceUnavailableException e) {
            callback.onError((Throwable)((Object)e));
            LogUtil.warn(_log, "unable to find service for: ", DynamicClient.extractLogInfo((Request)request));
        }
    }

    public void start(Callback<None> callback) {
        _log.info("starting D2 client");
        this._balancer.start(callback);
    }

    public void shutdown(final Callback<None> callback) {
        LogUtil.info(_log, "shutting down dynamic client");
        this._balancer.shutdown(new PropertyEventThread.PropertyEventShutdownCallback(){

            @Override
            public void done() {
                LogUtil.info(_log, "dynamic client shutdown complete");
                callback.onSuccess((Object)None.none());
            }
        });
    }

    @Override
    public Facilities getFacilities() {
        return this._facilities;
    }

    public Map<String, Object> getMetadata(URI uri) {
        if (this._balancer != null) {
            try {
                String serviceName = LoadBalancerUtil.getServiceNameFromUri(uri);
                ServiceProperties serviceProperties = this._balancer.getLoadBalancedServiceProperties(serviceName);
                if (serviceProperties != null) {
                    return Collections.unmodifiableMap(serviceProperties.getServiceMetadataProperties());
                }
            }
            catch (ServiceUnavailableException e) {
                LogUtil.error(_log, new Object[]{e});
            }
        }
        return Collections.emptyMap();
    }

    private static <T> Callback<T> decorateCallback(final Callback<T> callback, Request request, final String type) {
        if (_log.isTraceEnabled()) {
            LogUtil.trace(_log, type + " request: ", request);
            return new Callback<T>(){

                public void onError(Throwable e) {
                    callback.onError(e);
                    LogUtil.trace(_log, type + " response error: ", e);
                }

                public void onSuccess(T result) {
                    callback.onSuccess(result);
                    LogUtil.trace(_log, type + " response success: ", result);
                }
            };
        }
        return callback;
    }

    private static String extractLogInfo(Request request) {
        return request.getClass().getName() + ": [Service: " + LoadBalancerUtil.getServiceNameFromUri(request.getURI()) + ", Method: " + request.getMethod() + "]";
    }
}

