/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.zkfs;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.util.None;
import com.linkedin.d2.balancer.LoadBalancerState;
import com.linkedin.d2.balancer.properties.ClusterProperties;
import com.linkedin.d2.balancer.properties.ClusterPropertiesJsonSerializer;
import com.linkedin.d2.balancer.properties.ServiceProperties;
import com.linkedin.d2.balancer.properties.ServicePropertiesJsonSerializer;
import com.linkedin.d2.balancer.properties.UriProperties;
import com.linkedin.d2.balancer.properties.UriPropertiesJsonSerializer;
import com.linkedin.d2.balancer.properties.UriPropertiesMerger;
import com.linkedin.d2.balancer.simple.SimpleLoadBalancer;
import com.linkedin.d2.balancer.simple.SimpleLoadBalancerState;
import com.linkedin.d2.balancer.strategies.LoadBalancerStrategy;
import com.linkedin.d2.balancer.strategies.LoadBalancerStrategyFactory;
import com.linkedin.d2.balancer.util.TogglingLoadBalancer;
import com.linkedin.d2.balancer.zkfs.ZKFSLoadBalancer;
import com.linkedin.d2.balancer.zkfs.ZKFSUtil;
import com.linkedin.d2.discovery.PropertySerializer;
import com.linkedin.d2.discovery.event.PropertyEventBus;
import com.linkedin.d2.discovery.event.PropertyEventBusImpl;
import com.linkedin.d2.discovery.stores.file.FileStore;
import com.linkedin.d2.discovery.stores.toggling.TogglingPublisher;
import com.linkedin.d2.discovery.stores.zk.ZKConnection;
import com.linkedin.d2.discovery.stores.zk.ZooKeeperEphemeralStore;
import com.linkedin.d2.discovery.stores.zk.ZooKeeperPermanentStore;
import com.linkedin.d2.discovery.stores.zk.ZooKeeperPropertyMerger;
import com.linkedin.r2.transport.common.TransportClientFactory;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKFSTogglingLoadBalancerFactoryImpl
implements ZKFSLoadBalancer.TogglingLoadBalancerFactory {
    private final ComponentFactory _factory;
    private final long _lbTimeout;
    private final TimeUnit _lbTimeoutUnit;
    private final String _baseZKPath;
    private final String _fsDir;
    private final Map<String, TransportClientFactory> _clientFactories;
    private final Map<String, LoadBalancerStrategyFactory<? extends LoadBalancerStrategy>> _loadBalancerStrategyFactories;
    private final String _d2ServicePath;
    private final SSLContext _sslContext;
    private final SSLParameters _sslParameters;
    private final boolean _isSSLEnabled;
    private final Map<String, Map<String, Object>> _clientServicesConfig;
    private final boolean _useNewEphemeralStoreWatcher;
    private static final Logger _log = LoggerFactory.getLogger(ZKFSTogglingLoadBalancerFactoryImpl.class);

    public ZKFSTogglingLoadBalancerFactoryImpl(ComponentFactory factory, long timeout, TimeUnit timeoutUnit, String baseZKPath, String fsDir, Map<String, TransportClientFactory> clientFactories, Map<String, LoadBalancerStrategyFactory<? extends LoadBalancerStrategy>> loadBalancerStrategyFactories) {
        this(factory, timeout, timeoutUnit, baseZKPath, fsDir, clientFactories, loadBalancerStrategyFactories, "", null, null, false, Collections.emptyMap(), false);
    }

    public ZKFSTogglingLoadBalancerFactoryImpl(ComponentFactory factory, long timeout, TimeUnit timeoutUnit, String baseZKPath, String fsDir, Map<String, TransportClientFactory> clientFactories, Map<String, LoadBalancerStrategyFactory<? extends LoadBalancerStrategy>> loadBalancerStrategyFactories, String d2ServicePath) {
        this(factory, timeout, timeoutUnit, baseZKPath, fsDir, clientFactories, loadBalancerStrategyFactories, d2ServicePath, null, null, false, Collections.emptyMap(), false);
    }

    public ZKFSTogglingLoadBalancerFactoryImpl(ComponentFactory factory, long timeout, TimeUnit timeoutUnit, String baseZKPath, String fsDir, Map<String, TransportClientFactory> clientFactories, Map<String, LoadBalancerStrategyFactory<? extends LoadBalancerStrategy>> loadBalancerStrategyFactories, String d2ServicePath, SSLContext sslContext, SSLParameters sslParameters, boolean isSSLEnabled) {
        this(factory, timeout, timeoutUnit, baseZKPath, fsDir, clientFactories, loadBalancerStrategyFactories, d2ServicePath, sslContext, sslParameters, isSSLEnabled, Collections.emptyMap(), false);
    }

    public ZKFSTogglingLoadBalancerFactoryImpl(ComponentFactory factory, long timeout, TimeUnit timeoutUnit, String baseZKPath, String fsDir, Map<String, TransportClientFactory> clientFactories, Map<String, LoadBalancerStrategyFactory<? extends LoadBalancerStrategy>> loadBalancerStrategyFactories, String d2ServicePath, SSLContext sslContext, SSLParameters sslParameters, boolean isSSLEnabled, Map<String, Map<String, Object>> clientServicesConfig, boolean useNewEphemeralStoreWatcher) {
        this._factory = factory;
        this._lbTimeout = timeout;
        this._lbTimeoutUnit = timeoutUnit;
        this._baseZKPath = baseZKPath;
        this._fsDir = fsDir;
        this._clientFactories = clientFactories;
        this._loadBalancerStrategyFactories = loadBalancerStrategyFactories;
        this._d2ServicePath = d2ServicePath == null || d2ServicePath.isEmpty() ? "services" : d2ServicePath;
        this._sslContext = sslContext;
        this._sslParameters = sslParameters;
        this._isSSLEnabled = isSSLEnabled;
        this._clientServicesConfig = clientServicesConfig;
        this._useNewEphemeralStoreWatcher = useNewEphemeralStoreWatcher;
    }

    @Override
    public TogglingLoadBalancer createLoadBalancer(ZKConnection zkConnection, ScheduledExecutorService executorService) {
        _log.info("Using d2ServicePath: " + this._d2ServicePath);
        ZooKeeperPermanentStore<ClusterProperties> zkClusterRegistry = this.createPermanentStore(zkConnection, ZKFSUtil.clusterPath(this._baseZKPath), new ClusterPropertiesJsonSerializer());
        ZooKeeperPermanentStore<ServiceProperties> zkServiceRegistry = this.createPermanentStore(zkConnection, ZKFSUtil.servicePath(this._baseZKPath, this._d2ServicePath), new ServicePropertiesJsonSerializer());
        ZooKeeperEphemeralStore<UriProperties> zkUriRegistry = this.createEphemeralStore(zkConnection, ZKFSUtil.uriPath(this._baseZKPath), new UriPropertiesJsonSerializer(), new UriPropertiesMerger(), this._useNewEphemeralStoreWatcher);
        FileStore<ClusterProperties> fsClusterStore = this.createFileStore("clusters", new ClusterPropertiesJsonSerializer());
        FileStore<ServiceProperties> fsServiceStore = this.createFileStore(this._d2ServicePath, new ServicePropertiesJsonSerializer());
        FileStore<UriProperties> fsUriStore = this.createFileStore("uris", new UriPropertiesJsonSerializer());
        PropertyEventBusImpl<ClusterProperties> clusterBus = new PropertyEventBusImpl<ClusterProperties>(executorService);
        PropertyEventBusImpl<ServiceProperties> serviceBus = new PropertyEventBusImpl<ServiceProperties>(executorService);
        PropertyEventBusImpl<UriProperties> uriBus = new PropertyEventBusImpl<UriProperties>(executorService);
        clusterBus.register(fsClusterStore);
        serviceBus.register(fsServiceStore);
        uriBus.register(fsUriStore);
        TogglingPublisher<ClusterProperties> clusterToggle = this._factory.createClusterToggle(zkClusterRegistry, fsClusterStore, clusterBus);
        TogglingPublisher<ServiceProperties> serviceToggle = this._factory.createServiceToggle(zkServiceRegistry, fsServiceStore, serviceBus);
        TogglingPublisher<UriProperties> uriToggle = this._factory.createUriToggle(zkUriRegistry, fsUriStore, uriBus);
        SimpleLoadBalancerState state = new SimpleLoadBalancerState(executorService, uriBus, clusterBus, serviceBus, this._clientFactories, this._loadBalancerStrategyFactories, this._sslContext, this._sslParameters, this._isSSLEnabled, this._clientServicesConfig);
        SimpleLoadBalancer balancer = new SimpleLoadBalancer((LoadBalancerState)state, this._lbTimeout, this._lbTimeoutUnit);
        TogglingLoadBalancer togLB = this._factory.createBalancer(balancer, state, clusterToggle, serviceToggle, uriToggle);
        togLB.start(new Callback<None>(){

            public void onError(Throwable e) {
                _log.warn("Failed to run start on the TogglingLoadBalancer, may not have registered SimpleLoadBalancer and State with JMX.");
            }

            public void onSuccess(None result) {
                _log.info("Registered SimpleLoadBalancer and State with JMX.");
            }
        });
        return togLB;
    }

    protected <T> ZooKeeperPermanentStore<T> createPermanentStore(ZKConnection zkConnection, String nodePath, PropertySerializer<T> serializer) {
        ZooKeeperPermanentStore<T> store = new ZooKeeperPermanentStore<T>(zkConnection, serializer, nodePath);
        return store;
    }

    protected <T> ZooKeeperEphemeralStore<T> createEphemeralStore(ZKConnection zkConnection, String nodePath, PropertySerializer<T> serializer, ZooKeeperPropertyMerger<T> merger, boolean useNewWatcher) {
        ZooKeeperEphemeralStore<T> store = new ZooKeeperEphemeralStore<T>(zkConnection, serializer, merger, nodePath, false, useNewWatcher);
        return store;
    }

    protected <T> FileStore<T> createFileStore(String baseName, PropertySerializer<T> serializer) {
        FileStore<T> store = new FileStore<T>(this._fsDir + File.separator + baseName, ".ini", serializer);
        return store;
    }

    public static interface ComponentFactory {
        public TogglingLoadBalancer createBalancer(SimpleLoadBalancer var1, SimpleLoadBalancerState var2, TogglingPublisher<ClusterProperties> var3, TogglingPublisher<ServiceProperties> var4, TogglingPublisher<UriProperties> var5);

        public TogglingPublisher<ClusterProperties> createClusterToggle(ZooKeeperPermanentStore<ClusterProperties> var1, FileStore<ClusterProperties> var2, PropertyEventBus<ClusterProperties> var3);

        public TogglingPublisher<ServiceProperties> createServiceToggle(ZooKeeperPermanentStore<ServiceProperties> var1, FileStore<ServiceProperties> var2, PropertyEventBus<ServiceProperties> var3);

        public TogglingPublisher<UriProperties> createUriToggle(ZooKeeperEphemeralStore<UriProperties> var1, FileStore<UriProperties> var2, PropertyEventBus<UriProperties> var3);
    }
}

