/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.jmx;

import com.linkedin.d2.balancer.servers.ZooKeeperAnnouncer;
import com.linkedin.d2.balancer.servers.ZooKeeperServer;
import com.linkedin.d2.balancer.simple.SimpleLoadBalancer;
import com.linkedin.d2.balancer.simple.SimpleLoadBalancerState;
import com.linkedin.d2.balancer.strategies.LoadBalancerStrategy;
import com.linkedin.d2.balancer.strategies.degrader.DegraderLoadBalancerStrategyV2;
import com.linkedin.d2.balancer.strategies.degrader.DegraderLoadBalancerStrategyV2_1;
import com.linkedin.d2.balancer.strategies.degrader.DegraderLoadBalancerStrategyV3;
import com.linkedin.d2.discovery.stores.file.FileStore;
import com.linkedin.d2.discovery.stores.zk.ZooKeeperEphemeralStore;
import com.linkedin.d2.discovery.stores.zk.ZooKeeperPermanentStore;
import com.linkedin.d2.discovery.stores.zk.ZooKeeperTogglingStore;
import com.linkedin.d2.discovery.util.LogUtil;
import com.linkedin.d2.jmx.DegraderLoadBalancerStrategyV2Jmx;
import com.linkedin.d2.jmx.DegraderLoadBalancerStrategyV2JmxMBean;
import com.linkedin.d2.jmx.DegraderLoadBalancerStrategyV2_1Jmx;
import com.linkedin.d2.jmx.DegraderLoadBalancerStrategyV2_1JmxMBean;
import com.linkedin.d2.jmx.DegraderLoadBalancerStrategyV3Jmx;
import com.linkedin.d2.jmx.DegraderLoadBalancerStrategyV3JmxMBean;
import com.linkedin.d2.jmx.FileStoreJmx;
import com.linkedin.d2.jmx.ScheduledThreadPoolExecutorJmx;
import com.linkedin.d2.jmx.SimpleLoadBalancerJmx;
import com.linkedin.d2.jmx.SimpleLoadBalancerStateJmx;
import com.linkedin.d2.jmx.ZooKeeperAnnouncerJmx;
import com.linkedin.d2.jmx.ZooKeeperEphemeralStoreJmx;
import com.linkedin.d2.jmx.ZooKeeperPermanentStoreJmx;
import com.linkedin.d2.jmx.ZooKeeperServerJmx;
import com.linkedin.d2.jmx.ZooKeeperTogglingStoreJmx;
import java.lang.management.ManagementFactory;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxManager {
    private static final Logger _log = LoggerFactory.getLogger(JmxManager.class);
    private final MBeanServer _server;
    private final Set<ObjectName> _registeredNames = new HashSet<ObjectName>();

    public JmxManager() {
        this._server = ManagementFactory.getPlatformMBeanServer();
    }

    public synchronized void shutdown() {
        for (ObjectName name : new HashSet<ObjectName>(this._registeredNames)) {
            this.unregister(name);
        }
    }

    public synchronized <T> JmxManager registerFileStore(String name, FileStore<T> store) {
        this.checkReg(new FileStoreJmx<T>(store), name);
        return this;
    }

    public synchronized <T> JmxManager registerZooKeeperPermanentStore(String name, ZooKeeperPermanentStore<T> store) {
        this.checkReg(new ZooKeeperPermanentStoreJmx<T>(store), name);
        return this;
    }

    public synchronized <T> JmxManager registerZooKeeperEphemeralStore(String name, ZooKeeperEphemeralStore<T> store) {
        this.checkReg(new ZooKeeperEphemeralStoreJmx<T>(store), name);
        return this;
    }

    public synchronized <T> JmxManager registerZooKeeperTogglingStore(String name, ZooKeeperTogglingStore<T> store) {
        this.checkReg(new ZooKeeperTogglingStoreJmx<T>(store), name);
        return this;
    }

    public synchronized JmxManager registerScheduledThreadPoolExecutor(String name, ScheduledThreadPoolExecutor executor) {
        this.checkReg(new ScheduledThreadPoolExecutorJmx(executor), name);
        return this;
    }

    public synchronized JmxManager registerZooKeeperServer(String name, ZooKeeperServer zkServer) {
        this.checkReg(new ZooKeeperServerJmx(zkServer), name);
        return this;
    }

    public synchronized JmxManager registerLoadBalancerState(String name, SimpleLoadBalancerState state) {
        this.checkReg(new SimpleLoadBalancerStateJmx(state), name);
        return this;
    }

    public synchronized JmxManager registerLoadBalancer(String name, SimpleLoadBalancer balancer) {
        this.checkReg(new SimpleLoadBalancerJmx(balancer), name);
        return this;
    }

    public synchronized JmxManager registerLoadBalancerStrategy(String name, LoadBalancerStrategy strategy) {
        if (strategy instanceof DegraderLoadBalancerStrategyV2) {
            this.checkReg(new DegraderLoadBalancerStrategyV2Jmx((DegraderLoadBalancerStrategyV2)strategy), name);
        } else if (strategy instanceof DegraderLoadBalancerStrategyV2_1) {
            this.checkReg(new DegraderLoadBalancerStrategyV2_1Jmx((DegraderLoadBalancerStrategyV2_1)strategy), name);
        } else if (strategy instanceof DegraderLoadBalancerStrategyV3) {
            this.checkReg(new DegraderLoadBalancerStrategyV3Jmx((DegraderLoadBalancerStrategyV3)strategy), name);
        } else {
            LogUtil.warn(_log, "unable to register a jmx bean for unknown strategy: ", strategy);
        }
        return this;
    }

    public synchronized JmxManager registerLoadBalancerStrategyV2JmxBean(String name, DegraderLoadBalancerStrategyV2JmxMBean strategyJmx) {
        this.checkReg(strategyJmx, name);
        return this;
    }

    public synchronized JmxManager registerLoadBalancerStrategyV2_1JmxBean(String name, DegraderLoadBalancerStrategyV2_1JmxMBean strategyJmx) {
        this.checkReg(strategyJmx, name);
        return this;
    }

    public synchronized JmxManager registerLoadBalancerStrategyV3JmxBean(String name, DegraderLoadBalancerStrategyV3JmxMBean strategyJmx) {
        this.checkReg(strategyJmx, name);
        return this;
    }

    public synchronized JmxManager registerZooKeeperAnnouncer(String name, ZooKeeperAnnouncer announcer) {
        this.checkReg(new ZooKeeperAnnouncerJmx(announcer), name);
        return this;
    }

    public synchronized JmxManager unregister(String name) {
        ObjectName oName;
        try {
            oName = this.getName(name);
        }
        catch (Exception e) {
            _log.error("Failed to get MBean ObjectName for " + name, (Throwable)e);
            return this;
        }
        this.unregister(oName);
        return this;
    }

    public void unregister(ObjectName oName) {
        try {
            if (this._server.isRegistered(oName)) {
                this._server.unregisterMBean(oName);
            }
            this._registeredNames.remove(oName);
            _log.info("Unregistered MBean {}", (Object)oName);
        }
        catch (Exception e) {
            _log.warn("Failed to unregister MBean " + oName, (Throwable)e);
        }
    }

    public ObjectName getName(String name) throws MalformedObjectNameException {
        return new ObjectName("com.linkedin.d2:type=" + ObjectName.quote(name));
    }

    public void checkReg(Object o, String name) {
        ObjectName oName;
        try {
            oName = this.getName(name);
        }
        catch (Exception e) {
            _log.warn("Failed to get object name for {}", (Object)name);
            return;
        }
        this.unregister(oName);
        try {
            this._server.registerMBean(o, oName);
            this._registeredNames.add(oName);
            _log.info("Registered MBean {}", (Object)oName);
        }
        catch (Exception e) {
            _log.warn("Failed to register MBean with name " + oName, (Throwable)e);
        }
    }

    public boolean isRegistered(String name) {
        try {
            ObjectName oName = this.getName(name);
            return this._server.isRegistered(oName);
        }
        catch (Exception e) {
            _log.warn("Failed to get object name for {}", (Object)name);
            return false;
        }
    }
}

