/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableBitSet;

public class FilterAggregateTransposeRule
extends RelOptRule {
    public static final FilterAggregateTransposeRule INSTANCE = new FilterAggregateTransposeRule(Filter.class, RelFactories.DEFAULT_FILTER_FACTORY, Aggregate.class);
    private final RelFactories.FilterFactory filterFactory;

    public FilterAggregateTransposeRule(Class<? extends Filter> filterClass, RelFactories.FilterFactory filterFactory, Class<? extends Aggregate> aggregateClass) {
        super(FilterAggregateTransposeRule.operand(filterClass, FilterAggregateTransposeRule.operand(aggregateClass, FilterAggregateTransposeRule.any()), new RelOptRuleOperand[0]));
        this.filterFactory = filterFactory;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Filter filterRel = (Filter)call.rel(0);
        Aggregate aggRel = (Aggregate)call.rel(1);
        List<RexNode> conditions = RelOptUtil.conjunctions(filterRel.getCondition());
        ImmutableBitSet groupKeys = aggRel.getGroupSet();
        RexBuilder rexBuilder = filterRel.getCluster().getRexBuilder();
        List<RelDataTypeField> origFields = aggRel.getRowType().getFieldList();
        int[] adjustments = new int[origFields.size()];
        ArrayList pushedConditions = Lists.newArrayList();
        ArrayList remainingConditions = Lists.newArrayList();
        for (RexNode condition : conditions) {
            ImmutableBitSet rCols = RelOptUtil.InputFinder.bits(condition);
            boolean push = groupKeys.contains(rCols);
            if (push && aggRel.indicator) {
                for (ImmutableBitSet groupingSet : aggRel.getGroupSets()) {
                    if (groupingSet.contains(rCols)) continue;
                    push = false;
                    break;
                }
            }
            if (push) {
                pushedConditions.add(condition.accept(new RelOptUtil.RexInputConverter(rexBuilder, origFields, aggRel.getInput(0).getRowType().getFieldList(), adjustments)));
                continue;
            }
            remainingConditions.add(condition);
        }
        RelNode rel = RelOptUtil.createFilter(aggRel.getInput(), pushedConditions, this.filterFactory);
        if (rel == aggRel.getInput(0)) {
            return;
        }
        rel = aggRel.copy(aggRel.getTraitSet(), (List<RelNode>)ImmutableList.of((Object)rel));
        rel = RelOptUtil.createFilter(rel, remainingConditions, this.filterFactory);
        call.transformTo(rel);
    }
}

