/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.logical.LogicalCalc;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalWindow;
import org.apache.calcite.rel.rules.CalcRelSplitter;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.util.Util;

public abstract class ProjectToWindowRule
extends RelOptRule {
    private static final Predicate<Calc> PREDICATE = new Predicate<Calc>(){

        public boolean apply(Calc calc) {
            return RexOver.containsOver(calc.getProgram());
        }
    };
    private static final Predicate<Project> PREDICATE2 = new Predicate<Project>(){

        public boolean apply(Project project) {
            return RexOver.containsOver(project.getProjects(), null);
        }
    };
    public static final ProjectToWindowRule INSTANCE = new ProjectToWindowRule(ProjectToWindowRule.operand(Calc.class, null, PREDICATE, ProjectToWindowRule.any()), "ProjectToWindowRule"){

        @Override
        public void onMatch(RelOptRuleCall call) {
            Calc calc = (Calc)call.rel(0);
            assert (RexOver.containsOver(calc.getProgram()));
            WindowedAggRelSplitter transform = new WindowedAggRelSplitter(calc);
            RelNode newRel = transform.execute();
            call.transformTo(newRel);
        }
    };
    public static final ProjectToWindowRule PROJECT = new ProjectToWindowRule(ProjectToWindowRule.operand(Project.class, null, PREDICATE2, ProjectToWindowRule.any()), "ProjectToWindowRule:project"){

        @Override
        public void onMatch(RelOptRuleCall call) {
            Project project = (Project)call.rel(0);
            assert (RexOver.containsOver(project.getProjects(), null));
            RelNode input = project.getInput();
            RexProgram program = RexProgram.create(input.getRowType(), project.getProjects(), null, project.getRowType(), project.getCluster().getRexBuilder());
            LogicalCalc calc = LogicalCalc.create(input, program);
            WindowedAggRelSplitter transform = new WindowedAggRelSplitter(calc){

                @Override
                protected RelNode handle(RelNode rel) {
                    if (rel instanceof LogicalCalc) {
                        LogicalCalc calc = (LogicalCalc)rel;
                        final RexProgram program = calc.getProgram();
                        rel = calc.getInput();
                        if (program.getCondition() != null) {
                            rel = LogicalFilter.create(rel, program.expandLocalRef(program.getCondition()));
                        }
                        if (!program.projectsOnlyIdentity()) {
                            rel = RelOptUtil.createProject(rel, Lists.transform(program.getProjectList(), (Function)new Function<RexLocalRef, RexNode>(){

                                public RexNode apply(RexLocalRef a0) {
                                    return program.expandLocalRef(a0);
                                }
                            }), calc.getRowType().getFieldNames());
                        }
                    }
                    return rel;
                }
            };
            RelNode newRel = transform.execute();
            call.transformTo(newRel);
        }
    };

    private ProjectToWindowRule(RelOptRuleOperand operand, String description) {
        super(operand, description);
    }

    static class WindowedAggRelSplitter
    extends CalcRelSplitter {
        WindowedAggRelSplitter(Calc calc) {
            super(calc, new CalcRelSplitter.RelType[]{new CalcRelSplitter.RelType("CalcRelType"){

                @Override
                protected boolean canImplement(RexFieldAccess field) {
                    return true;
                }

                @Override
                protected boolean canImplement(RexDynamicParam param) {
                    return true;
                }

                @Override
                protected boolean canImplement(RexLiteral literal) {
                    return true;
                }

                @Override
                protected boolean canImplement(RexCall call) {
                    return !(call instanceof RexOver);
                }

                @Override
                protected RelNode makeRel(RelOptCluster cluster, RelTraitSet traits, RelNode child, RexProgram program) {
                    assert (!program.containsAggs());
                    program = RexProgramBuilder.normalize(cluster.getRexBuilder(), program);
                    return super.makeRel(cluster, traits, child, program);
                }
            }, new CalcRelSplitter.RelType("WinAggRelType"){

                @Override
                protected boolean canImplement(RexFieldAccess field) {
                    return false;
                }

                @Override
                protected boolean canImplement(RexDynamicParam param) {
                    return false;
                }

                @Override
                protected boolean canImplement(RexLiteral literal) {
                    return false;
                }

                @Override
                protected boolean canImplement(RexCall call) {
                    return call instanceof RexOver;
                }

                @Override
                protected boolean supportsCondition() {
                    return false;
                }

                @Override
                protected RelNode makeRel(RelOptCluster cluster, RelTraitSet traits, RelNode child, RexProgram program) {
                    Util.permAssert(program.getCondition() == null, "WindowedAggregateRel cannot accept a condition");
                    return LogicalWindow.create(cluster, traits, child, program);
                }
            }});
        }

        @Override
        protected List<Set<Integer>> getCohorts() {
            return Collections.emptyList();
        }
    }
}

