/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rex;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.avatica.util.Spaces;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCallBinding;
import org.apache.calcite.rex.RexCopier;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexFieldCollation;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexRangeRef;
import org.apache.calcite.rex.RexWindow;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.calcite.runtime.SqlFunctions;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.fun.SqlCountAggFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.ArraySqlType;
import org.apache.calcite.sql.type.IntervalSqlType;
import org.apache.calcite.sql.type.MapSqlType;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;

public class RexBuilder {
    public static final SqlSpecialOperator GET_OPERATOR = new SqlSpecialOperator("_get", SqlKind.OTHER_FUNCTION);
    public static final Function<RelDataTypeField, RexInputRef> TO_INPUT_REF = new Function<RelDataTypeField, RexInputRef>(){

        public RexInputRef apply(RelDataTypeField input) {
            return new RexInputRef(input.getIndex(), input.getType());
        }
    };
    protected final RelDataTypeFactory typeFactory;
    private final RexLiteral booleanTrue;
    private final RexLiteral booleanFalse;
    private final RexLiteral charEmpty;
    private final RexLiteral constantNull;
    private final SqlStdOperatorTable opTab = SqlStdOperatorTable.instance();

    public RexBuilder(RelDataTypeFactory typeFactory) {
        this.typeFactory = typeFactory;
        this.booleanTrue = this.makeLiteral(Boolean.TRUE, typeFactory.createSqlType(SqlTypeName.BOOLEAN), SqlTypeName.BOOLEAN);
        this.booleanFalse = this.makeLiteral(Boolean.FALSE, typeFactory.createSqlType(SqlTypeName.BOOLEAN), SqlTypeName.BOOLEAN);
        this.charEmpty = this.makeLiteral(new NlsString("", null, null), typeFactory.createSqlType(SqlTypeName.CHAR, 0), SqlTypeName.CHAR);
        this.constantNull = this.makeLiteral(null, typeFactory.createSqlType(SqlTypeName.NULL), SqlTypeName.NULL);
    }

    public List<RexInputRef> identityProjects(RelDataType rowType) {
        return Lists.transform(rowType.getFieldList(), TO_INPUT_REF);
    }

    public RelDataTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    public SqlStdOperatorTable getOpTab() {
        return this.opTab;
    }

    public RexNode makeFieldAccess(RexNode expr, String fieldName, boolean caseSensitive) {
        RelDataType type = expr.getType();
        RelDataTypeField field = type.getField(fieldName, caseSensitive, false);
        if (field == null) {
            throw Util.newInternal("Type '" + type + "' has no field '" + fieldName + "'");
        }
        return this.makeFieldAccessInternal(expr, field);
    }

    public RexNode makeFieldAccess(RexNode expr, int i) {
        RelDataType type = expr.getType();
        List<RelDataTypeField> fields = type.getFieldList();
        if (i < 0 || i >= fields.size()) {
            throw Util.newInternal("Field ordinal " + i + " is invalid for " + " type '" + type + "'");
        }
        return this.makeFieldAccessInternal(expr, fields.get(i));
    }

    private RexNode makeFieldAccessInternal(RexNode expr, RelDataTypeField field) {
        if (expr instanceof RexRangeRef) {
            RexRangeRef range = (RexRangeRef)expr;
            if (field.getIndex() < 0) {
                return this.makeCall(field.getType(), GET_OPERATOR, (List<RexNode>)ImmutableList.of((Object)expr, (Object)this.makeLiteral(field.getName())));
            }
            return new RexInputRef(range.getOffset() + field.getIndex(), field.getType());
        }
        return new RexFieldAccess(expr, field);
    }

    public RexNode makeCall(RelDataType returnType, SqlOperator op, List<RexNode> exprs) {
        return new RexCall(returnType, op, exprs);
    }

    public RexNode makeCall(SqlOperator op, List<? extends RexNode> exprs) {
        RelDataType type = this.deriveReturnType(op, exprs);
        return new RexCall(type, op, exprs);
    }

    public final RexNode makeCall(SqlOperator op, RexNode ... exprs) {
        return this.makeCall(op, (List<? extends RexNode>)ImmutableList.copyOf((Object[])exprs));
    }

    public RelDataType deriveReturnType(SqlOperator op, List<? extends RexNode> exprs) {
        return op.inferReturnType(new RexCallBinding(this.typeFactory, op, exprs));
    }

    public RexNode addAggCall(AggregateCall aggCall, int groupCount, boolean indicator, List<AggregateCall> aggCalls, Map<AggregateCall, RexNode> aggCallMapping, List<RelDataType> aggArgTypes) {
        RexNode rex;
        List<Integer> args;
        List<Integer> nullableArgs;
        if (aggCall.getAggregation() instanceof SqlCountAggFunction && !aggCall.isDistinct() && !(nullableArgs = RexBuilder.nullableArgs(args = aggCall.getArgList(), aggArgTypes)).equals(args)) {
            aggCall = aggCall.copy(nullableArgs, aggCall.filterArg);
        }
        if ((rex = aggCallMapping.get(aggCall)) == null) {
            int index = aggCalls.size() + groupCount * (indicator ? 2 : 1);
            aggCalls.add(aggCall);
            rex = this.makeInputRef(aggCall.getType(), index);
            aggCallMapping.put(aggCall, rex);
        }
        return rex;
    }

    private static List<Integer> nullableArgs(List<Integer> list0, List<RelDataType> types) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Pair<Integer, RelDataType> pair : Pair.zip(list0, types)) {
            if (!((RelDataType)pair.right).isNullable()) continue;
            list.add((Integer)pair.left);
        }
        return list;
    }

    public RexNode makeOver(RelDataType type, SqlAggFunction operator, List<RexNode> exprs, List<RexNode> partitionKeys, ImmutableList<RexFieldCollation> orderKeys, RexWindowBound lowerBound, RexWindowBound upperBound, boolean physical, boolean allowPartial, boolean nullWhenCountZero) {
        RelDataType bigintType;
        RexOver over;
        assert (operator != null);
        assert (exprs != null);
        assert (partitionKeys != null);
        assert (orderKeys != null);
        RexWindow window = this.makeWindow(partitionKeys, orderKeys, lowerBound, upperBound, physical);
        RexNode result = over = new RexOver(type, operator, exprs, window);
        if (nullWhenCountZero) {
            bigintType = this.getTypeFactory().createSqlType(SqlTypeName.BIGINT);
            result = this.makeCall((SqlOperator)SqlStdOperatorTable.CASE, this.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexOver(bigintType, SqlStdOperatorTable.COUNT, exprs, window), this.makeLiteral(BigDecimal.ZERO, bigintType, SqlTypeName.DECIMAL)), this.ensureType(type, new RexOver(this.typeFactory.createTypeWithNullability(type, false), operator, exprs, window), false), this.makeCast(type, this.constantNull()));
        }
        if (!allowPartial) {
            Util.permAssert(physical, "DISALLOW PARTIAL over RANGE");
            bigintType = this.getTypeFactory().createSqlType(SqlTypeName.BIGINT);
            result = this.makeCall((SqlOperator)SqlStdOperatorTable.CASE, this.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, new RexOver(bigintType, SqlStdOperatorTable.COUNT, (List<RexNode>)ImmutableList.of(), window), this.makeLiteral(BigDecimal.valueOf(2L), bigintType, SqlTypeName.DECIMAL)), result, this.constantNull);
        }
        return result;
    }

    public RexWindow makeWindow(List<RexNode> partitionKeys, ImmutableList<RexFieldCollation> orderKeys, RexWindowBound lowerBound, RexWindowBound upperBound, boolean isRows) {
        return new RexWindow(partitionKeys, (List<RexFieldCollation>)orderKeys, lowerBound, upperBound, isRows);
    }

    public RexLiteral constantNull() {
        return this.constantNull;
    }

    public RexNode makeCorrel(RelDataType type, String name) {
        return new RexCorrelVariable(name, type);
    }

    public RexNode makeNewInvocation(RelDataType type, List<RexNode> exprs) {
        return new RexCall(type, SqlStdOperatorTable.NEW, exprs);
    }

    public RexNode makeCast(RelDataType type, RexNode exp) {
        SqlTypeName sqlType = type.getSqlTypeName();
        if (exp instanceof RexLiteral) {
            RexLiteral literal = (RexLiteral)exp;
            Comparable value = literal.getValue();
            if (!(!RexLiteral.valueMatchesType(value, sqlType, false) || type.getSqlTypeName() != literal.getTypeName() && SqlTypeFamily.DATETIME.getTypeNames().contains((Object)literal.getTypeName()) || value instanceof NlsString && type.getPrecision() < ((NlsString)value).getValue().length() || value instanceof ByteString && type.getPrecision() < ((ByteString)value).length())) {
                switch (literal.getTypeName()) {
                    case CHAR: {
                        if (!(value instanceof NlsString)) break;
                        value = ((NlsString)value).rtrim();
                        break;
                    }
                    case TIMESTAMP: 
                    case TIME: {
                        Calendar calendar = (Calendar)value;
                        int scale = type.getScale();
                        if (scale == Integer.MIN_VALUE) {
                            scale = 0;
                        }
                        calendar.setTimeInMillis(SqlFunctions.round(calendar.getTimeInMillis(), DateTimeUtils.powerX((long)10L, (long)(3 - scale))));
                        break;
                    }
                    case INTERVAL_DAY_TIME: {
                        BigDecimal value2 = (BigDecimal)value;
                        long multiplier = literal.getType().getIntervalQualifier().getStartUnit().multiplier;
                        SqlTypeName typeName = type.getSqlTypeName();
                        switch (typeName) {
                            case INTEGER: {
                                typeName = SqlTypeName.BIGINT;
                            }
                        }
                        return this.makeLiteral(value2.divide(BigDecimal.valueOf(multiplier), 0, 5), type, typeName);
                    }
                }
                return this.makeLiteral(value, type, literal.getTypeName());
            }
        } else {
            if (SqlTypeUtil.isInterval(type) && SqlTypeUtil.isExactNumeric(exp.getType())) {
                return this.makeCastExactToInterval(type, exp);
            }
            if (SqlTypeUtil.isExactNumeric(type) && SqlTypeUtil.isInterval(exp.getType())) {
                return this.makeCastIntervalToExact(type, exp);
            }
            if (sqlType == SqlTypeName.BOOLEAN && SqlTypeUtil.isExactNumeric(exp.getType())) {
                return this.makeCastExactToBoolean(type, exp);
            }
            if (exp.getType().getSqlTypeName() == SqlTypeName.BOOLEAN && SqlTypeUtil.isExactNumeric(type)) {
                return this.makeCastBooleanToExact(type, exp);
            }
        }
        return this.makeAbstractCast(type, exp);
    }

    private RexNode makeCastExactToBoolean(RelDataType toType, RexNode exp) {
        return this.makeCall(toType, SqlStdOperatorTable.NOT_EQUALS, (List<RexNode>)ImmutableList.of((Object)exp, (Object)this.makeZeroLiteral(exp.getType())));
    }

    private RexNode makeCastBooleanToExact(RelDataType toType, RexNode exp) {
        RexNode casted = this.makeCall((SqlOperator)SqlStdOperatorTable.CASE, exp, this.makeExactLiteral(BigDecimal.ONE, toType), this.makeZeroLiteral(toType));
        if (!exp.getType().isNullable()) {
            return casted;
        }
        return this.makeCall(toType, SqlStdOperatorTable.CASE, (List<RexNode>)ImmutableList.of((Object)this.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, exp), (Object)casted, (Object)this.makeNullLiteral(toType.getSqlTypeName())));
    }

    private RexNode makeCastIntervalToExact(RelDataType toType, RexNode exp) {
        IntervalSqlType intervalType = (IntervalSqlType)exp.getType();
        TimeUnit endUnit = intervalType.getIntervalQualifier().getEndUnit();
        if (endUnit == null) {
            endUnit = intervalType.getIntervalQualifier().getStartUnit();
        }
        int scale = 0;
        if (endUnit == TimeUnit.SECOND) {
            scale = Math.min(intervalType.getIntervalQualifier().getFractionalSecondPrecision(this.typeFactory.getTypeSystem()), 3);
        }
        BigDecimal multiplier = BigDecimal.valueOf(endUnit.multiplier).divide(BigDecimal.TEN.pow(scale));
        RexNode value = this.decodeIntervalOrDecimal(exp);
        if (multiplier.longValue() != 1L) {
            value = this.makeCall((SqlOperator)SqlStdOperatorTable.DIVIDE_INTEGER, value, this.makeBigintLiteral(multiplier));
        }
        if (scale > 0) {
            RelDataType decimalType = this.getTypeFactory().createSqlType(SqlTypeName.DECIMAL, scale + intervalType.getPrecision(), scale);
            value = this.encodeIntervalOrDecimal(value, decimalType, false);
        }
        return this.ensureType(toType, value, false);
    }

    private RexNode makeCastExactToInterval(RelDataType toType, RexNode exp) {
        IntervalSqlType intervalType = (IntervalSqlType)toType;
        TimeUnit endUnit = intervalType.getIntervalQualifier().getEndUnit();
        if (endUnit == null) {
            endUnit = intervalType.getIntervalQualifier().getStartUnit();
        }
        int scale = 0;
        if (endUnit == TimeUnit.SECOND) {
            scale = Math.min(intervalType.getIntervalQualifier().getFractionalSecondPrecision(this.typeFactory.getTypeSystem()), 3);
        }
        BigDecimal multiplier = BigDecimal.valueOf(endUnit.multiplier).divide(BigDecimal.TEN.pow(scale));
        RelDataType decimalType = this.getTypeFactory().createSqlType(SqlTypeName.DECIMAL, scale + intervalType.getPrecision(), scale);
        RexNode value = this.decodeIntervalOrDecimal(this.ensureType(decimalType, exp, true));
        if (multiplier.longValue() != 1L) {
            value = this.makeCall((SqlOperator)SqlStdOperatorTable.MULTIPLY, value, this.makeExactLiteral(multiplier));
        }
        return this.encodeIntervalOrDecimal(value, toType, false);
    }

    public RexNode encodeIntervalOrDecimal(RexNode value, RelDataType type, boolean checkOverflow) {
        RelDataType bigintType = this.typeFactory.createSqlType(SqlTypeName.BIGINT);
        RexNode cast = this.ensureType(bigintType, value, true);
        return this.makeReinterpretCast(type, cast, this.makeLiteral(checkOverflow));
    }

    public RexNode decodeIntervalOrDecimal(RexNode node) {
        assert (SqlTypeUtil.isDecimal(node.getType()) || SqlTypeUtil.isInterval(node.getType()));
        RelDataType bigintType = this.typeFactory.createSqlType(SqlTypeName.BIGINT);
        return this.makeReinterpretCast(this.matchNullability(bigintType, node), node, this.makeLiteral(false));
    }

    public RexNode makeAbstractCast(RelDataType type, RexNode exp) {
        return new RexCall(type, SqlStdOperatorTable.CAST, (List<? extends RexNode>)ImmutableList.of((Object)exp));
    }

    public RexNode makeReinterpretCast(RelDataType type, RexNode exp, RexNode checkOverflow) {
        ImmutableList args = checkOverflow != null && checkOverflow.isAlwaysTrue() ? ImmutableList.of((Object)exp, (Object)checkOverflow) : ImmutableList.of((Object)exp);
        return new RexCall(type, SqlStdOperatorTable.REINTERPRET, (List<? extends RexNode>)args);
    }

    public RexNode makeNotNullCast(RexNode expr) {
        RelDataType type = expr.getType();
        if (!type.isNullable()) {
            return expr;
        }
        RelDataType typeNotNull = this.getTypeFactory().createTypeWithNullability(type, false);
        return new RexCall(typeNotNull, SqlStdOperatorTable.CAST, (List<? extends RexNode>)ImmutableList.of((Object)expr));
    }

    public RexNode makeRangeReference(RelNode input) {
        return new RexRangeRef(input.getRowType(), 0);
    }

    public RexRangeRef makeRangeReference(RelDataType type, int offset, boolean nullable) {
        if (nullable && !type.isNullable()) {
            type = this.typeFactory.createTypeWithNullability(type, nullable);
        }
        return new RexRangeRef(type, offset);
    }

    public RexInputRef makeInputRef(RelDataType type, int i) {
        type = SqlTypeUtil.addCharsetAndCollation(type, this.typeFactory);
        return new RexInputRef(i, type);
    }

    public RexInputRef makeInputRef(RelNode input, int i) {
        return this.makeInputRef(input.getRowType().getFieldList().get(i).getType(), i);
    }

    public RexLiteral makeFlag(Enum flag) {
        assert (flag != null);
        return this.makeLiteral((Comparable)((Object)flag), this.typeFactory.createSqlType(SqlTypeName.SYMBOL), SqlTypeName.SYMBOL);
    }

    protected RexLiteral makeLiteral(Comparable o, RelDataType type, SqlTypeName typeName) {
        type = this.typeFactory.createTypeWithNullability(type, o == null);
        if (typeName == SqlTypeName.CHAR) {
            assert (o instanceof NlsString);
            NlsString nlsString = (NlsString)o;
            if (nlsString.getCollation() == null || nlsString.getCharset() == null) {
                assert (type.getSqlTypeName() == SqlTypeName.CHAR);
                assert (type.getCharset().name() != null);
                assert (type.getCollation() != null);
                o = new NlsString(nlsString.getValue(), type.getCharset().name(), type.getCollation());
            }
        }
        return new RexLiteral(o, type, typeName);
    }

    public RexLiteral makeLiteral(boolean b) {
        return b ? this.booleanTrue : this.booleanFalse;
    }

    public RexLiteral makeExactLiteral(BigDecimal bd) {
        RelDataType relType;
        int scale = bd.scale();
        long l = bd.unscaledValue().longValue();
        assert (scale >= 0);
        assert (scale <= this.typeFactory.getTypeSystem().getMaxNumericScale()) : scale;
        assert (BigDecimal.valueOf(l, scale).equals(bd));
        if (scale == 0) {
            relType = l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE ? this.typeFactory.createSqlType(SqlTypeName.INTEGER) : this.typeFactory.createSqlType(SqlTypeName.BIGINT);
        } else {
            int precision = bd.unscaledValue().toString().length();
            relType = this.typeFactory.createSqlType(SqlTypeName.DECIMAL, scale, precision);
        }
        return this.makeExactLiteral(bd, relType);
    }

    public RexLiteral makeBigintLiteral(BigDecimal bd) {
        RelDataType bigintType = this.typeFactory.createSqlType(SqlTypeName.BIGINT);
        return this.makeLiteral(bd, bigintType, SqlTypeName.DECIMAL);
    }

    public RexLiteral makeExactLiteral(BigDecimal bd, RelDataType type) {
        return this.makeLiteral(bd, type, SqlTypeName.DECIMAL);
    }

    public RexLiteral makeBinaryLiteral(ByteString byteString) {
        return this.makeLiteral((Comparable)byteString, this.typeFactory.createSqlType(SqlTypeName.BINARY, byteString.length()), SqlTypeName.BINARY);
    }

    public RexLiteral makeApproxLiteral(BigDecimal bd) {
        if (bd.doubleValue() == 0.0) {
            bd = BigDecimal.ZERO;
        }
        return this.makeApproxLiteral(bd, this.typeFactory.createSqlType(SqlTypeName.DOUBLE));
    }

    public RexLiteral makeApproxLiteral(BigDecimal bd, RelDataType type) {
        assert (SqlTypeFamily.APPROXIMATE_NUMERIC.getTypeNames().contains((Object)type.getSqlTypeName()));
        return this.makeLiteral(bd, type, SqlTypeName.DOUBLE);
    }

    public RexLiteral makeLiteral(String s) {
        assert (s != null);
        return this.makePreciseStringLiteral(s);
    }

    protected RexLiteral makePreciseStringLiteral(String s) {
        assert (s != null);
        if (s.equals("")) {
            return this.charEmpty;
        }
        return this.makeLiteral(new NlsString(s, null, null), this.typeFactory.createSqlType(SqlTypeName.CHAR, s.length()), SqlTypeName.CHAR);
    }

    public RexNode ensureType(RelDataType type, RexNode node, boolean matchNullability) {
        RelDataType targetType = type;
        if (matchNullability) {
            targetType = this.matchNullability(type, node);
        }
        if (!node.getType().equals(targetType)) {
            return this.makeCast(targetType, node);
        }
        return node;
    }

    public RelDataType matchNullability(RelDataType type, RexNode value) {
        boolean valueNullability;
        boolean typeNullability = type.isNullable();
        if (typeNullability != (valueNullability = value.getType().isNullable())) {
            return this.getTypeFactory().createTypeWithNullability(type, valueNullability);
        }
        return type;
    }

    public RexLiteral makeCharLiteral(NlsString str) {
        assert (str != null);
        RelDataType type = SqlUtil.createNlsStringType(this.typeFactory, str);
        return this.makeLiteral(str, type, SqlTypeName.CHAR);
    }

    public RexLiteral makeDateLiteral(Calendar date) {
        assert (date != null);
        return this.makeLiteral(date, this.typeFactory.createSqlType(SqlTypeName.DATE), SqlTypeName.DATE);
    }

    public RexLiteral makeTimeLiteral(Calendar time, int precision) {
        assert (time != null);
        return this.makeLiteral(time, this.typeFactory.createSqlType(SqlTypeName.TIME, precision), SqlTypeName.TIME);
    }

    public RexLiteral makeTimestampLiteral(Calendar timestamp, int precision) {
        assert (timestamp != null);
        return this.makeLiteral(timestamp, this.typeFactory.createSqlType(SqlTypeName.TIMESTAMP, precision), SqlTypeName.TIMESTAMP);
    }

    public RexLiteral makeIntervalLiteral(SqlIntervalQualifier intervalQualifier) {
        assert (intervalQualifier != null);
        return this.makeFlag((Enum)intervalQualifier.timeUnitRange);
    }

    public RexLiteral makeIntervalLiteral(BigDecimal v, SqlIntervalQualifier intervalQualifier) {
        return this.makeLiteral(v, this.typeFactory.createSqlIntervalType(intervalQualifier), intervalQualifier.isYearMonth() ? SqlTypeName.INTERVAL_YEAR_MONTH : SqlTypeName.INTERVAL_DAY_TIME);
    }

    public RexDynamicParam makeDynamicParam(RelDataType type, int index) {
        return new RexDynamicParam(type, index);
    }

    public RexNode makeNullLiteral(SqlTypeName typeName, int precision) {
        RelDataType type = this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(typeName, precision), true);
        return this.makeCast(type, this.constantNull());
    }

    public RexNode makeNullLiteral(SqlTypeName typeName) {
        RelDataType type = this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(typeName), true);
        return this.makeCast(type, this.constantNull());
    }

    public RexNode copy(RexNode expr) {
        return expr.accept(new RexCopier(this));
    }

    public RexNode makeZeroLiteral(RelDataType type) {
        return this.makeLiteral((Object)RexBuilder.zeroValue(type), type, false);
    }

    private static Comparable zeroValue(RelDataType type) {
        switch (type.getSqlTypeName()) {
            case CHAR: {
                return new NlsString(Spaces.of((int)type.getPrecision()), null, null);
            }
            case VARCHAR: {
                return new NlsString("", null, null);
            }
            case BINARY: {
                return new ByteString(new byte[type.getPrecision()]);
            }
            case VARBINARY: {
                return ByteString.EMPTY;
            }
            case INTEGER: 
            case TINYINT: 
            case SMALLINT: 
            case BIGINT: 
            case DECIMAL: 
            case FLOAT: 
            case REAL: 
            case DOUBLE: {
                return BigDecimal.ZERO;
            }
            case BOOLEAN: {
                return Boolean.valueOf(false);
            }
            case TIMESTAMP: 
            case TIME: 
            case DATE: {
                return DateTimeUtils.ZERO_CALENDAR;
            }
        }
        throw Util.unexpected(type.getSqlTypeName());
    }

    public RexNode makeLiteral(Object value, RelDataType type, boolean allowCast) {
        if (value == null) {
            return this.makeCast(type, this.constantNull);
        }
        if (type.isNullable()) {
            RelDataType typeNotNull = this.typeFactory.createTypeWithNullability(type, false);
            RexNode literalNotNull = this.makeLiteral(value, typeNotNull, allowCast);
            return this.makeAbstractCast(type, literalNotNull);
        }
        value = RexBuilder.clean(value, type);
        switch (type.getSqlTypeName()) {
            case CHAR: {
                return this.makeCharLiteral(RexBuilder.padRight((NlsString)value, type.getPrecision()));
            }
            case VARCHAR: {
                RexLiteral literal = this.makeCharLiteral((NlsString)value);
                if (allowCast) {
                    return this.makeCast(type, literal);
                }
                return literal;
            }
            case BINARY: {
                return this.makeBinaryLiteral(RexBuilder.padRight((ByteString)value, type.getPrecision()));
            }
            case VARBINARY: {
                RexLiteral literal = this.makeBinaryLiteral((ByteString)value);
                if (allowCast) {
                    return this.makeCast(type, literal);
                }
                return literal;
            }
            case INTEGER: 
            case TINYINT: 
            case SMALLINT: 
            case BIGINT: 
            case DECIMAL: {
                return this.makeExactLiteral((BigDecimal)value, type);
            }
            case FLOAT: 
            case REAL: 
            case DOUBLE: {
                return this.makeApproxLiteral((BigDecimal)value, type);
            }
            case BOOLEAN: {
                return (Boolean)value != false ? this.booleanTrue : this.booleanFalse;
            }
            case TIME: {
                return this.makeTimeLiteral((Calendar)value, type.getPrecision());
            }
            case DATE: {
                return this.makeDateLiteral((Calendar)value);
            }
            case TIMESTAMP: {
                return this.makeTimestampLiteral((Calendar)value, type.getPrecision());
            }
            case INTERVAL_DAY_TIME: 
            case INTERVAL_YEAR_MONTH: {
                return this.makeIntervalLiteral((BigDecimal)value, type.getIntervalQualifier());
            }
            case MAP: {
                MapSqlType mapType = (MapSqlType)type;
                Map map = (Map)value;
                ArrayList<RexNode> operands = new ArrayList<RexNode>();
                for (Map.Entry entry : map.entrySet()) {
                    operands.add(this.makeLiteral(entry.getKey(), mapType.getKeyType(), allowCast));
                    operands.add(this.makeLiteral(entry.getValue(), mapType.getValueType(), allowCast));
                }
                return this.makeCall((SqlOperator)SqlStdOperatorTable.MAP_VALUE_CONSTRUCTOR, operands);
            }
            case ARRAY: {
                ArraySqlType arrayType = (ArraySqlType)type;
                List listValue = (List)value;
                ArrayList<RexNode> operands = new ArrayList<RexNode>();
                for (Object entry : listValue) {
                    operands.add(this.makeLiteral(entry, arrayType.getComponentType(), allowCast));
                }
                return this.makeCall((SqlOperator)SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR, operands);
            }
            case ANY: {
                return this.makeLiteral(value, this.guessType(value), allowCast);
            }
        }
        throw Util.unexpected(type.getSqlTypeName());
    }

    private static Object clean(Object o, RelDataType type) {
        if (o == null) {
            return null;
        }
        switch (type.getSqlTypeName()) {
            case INTEGER: 
            case INTERVAL_DAY_TIME: 
            case TINYINT: 
            case SMALLINT: 
            case BIGINT: 
            case DECIMAL: 
            case INTERVAL_YEAR_MONTH: {
                if (o instanceof BigDecimal) {
                    return o;
                }
                return new BigDecimal(((Number)o).longValue());
            }
            case FLOAT: 
            case REAL: 
            case DOUBLE: {
                if (o instanceof BigDecimal) {
                    return o;
                }
                return new BigDecimal(((Number)o).doubleValue());
            }
            case CHAR: 
            case VARCHAR: {
                if (o instanceof NlsString) {
                    return o;
                }
                return new NlsString((String)o, type.getCharset().name(), type.getCollation());
            }
            case TIME: {
                if (o instanceof Calendar) {
                    return o;
                }
                Calendar calendar = Calendar.getInstance(DateTimeUtils.GMT_ZONE);
                calendar.setTimeInMillis(((Integer)o).intValue());
                return calendar;
            }
            case DATE: {
                if (o instanceof Calendar) {
                    return o;
                }
                Calendar calendar = Calendar.getInstance(DateTimeUtils.GMT_ZONE);
                calendar.setTimeInMillis(0L);
                calendar.add(6, (Integer)o);
                return calendar;
            }
            case TIMESTAMP: {
                if (o instanceof Calendar) {
                    return o;
                }
                Calendar calendar = Calendar.getInstance(DateTimeUtils.GMT_ZONE);
                calendar.setTimeInMillis((Long)o);
                return calendar;
            }
        }
        return o;
    }

    private RelDataType guessType(Object value) {
        if (value == null) {
            return this.typeFactory.createSqlType(SqlTypeName.NULL);
        }
        if (value instanceof Float || value instanceof Double) {
            return this.typeFactory.createSqlType(SqlTypeName.DOUBLE);
        }
        if (value instanceof Number) {
            return this.typeFactory.createSqlType(SqlTypeName.BIGINT);
        }
        if (value instanceof Boolean) {
            return this.typeFactory.createSqlType(SqlTypeName.BOOLEAN);
        }
        if (value instanceof String) {
            return this.typeFactory.createSqlType(SqlTypeName.CHAR, ((String)value).length());
        }
        if (value instanceof ByteString) {
            return this.typeFactory.createSqlType(SqlTypeName.BINARY, ((ByteString)value).length());
        }
        throw new AssertionError((Object)("unknown type " + value.getClass()));
    }

    private static NlsString padRight(NlsString s, int length) {
        if (s.getValue().length() >= length) {
            return s;
        }
        return s.copy(RexBuilder.padRight(s.getValue(), length));
    }

    private static String padRight(String s, int length) {
        if (s.length() >= length) {
            return s;
        }
        return new StringBuilder().append(s).append(Spaces.MAX, s.length(), length).toString();
    }

    private static ByteString padRight(ByteString s, int length) {
        if (s.length() >= length) {
            return s;
        }
        return new ByteString(Arrays.copyOf(s.getBytes(), length));
    }
}

