/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rex;

import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexSlot;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.util.Util;

public class RexLocalRef
extends RexSlot {
    private static final List<String> NAMES = new RexSlot.SelfPopulatingList("$t", 30);

    public RexLocalRef(int index, RelDataType type) {
        super(RexLocalRef.createName(index), index, type);
        assert (type != null);
        assert (index >= 0);
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.LOCAL_REF;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof RexLocalRef && this.type == ((RexLocalRef)obj).type && this.index == ((RexLocalRef)obj).index;
    }

    public int hashCode() {
        return Util.hash(this.type.hashCode(), this.index);
    }

    @Override
    public <R> R accept(RexVisitor<R> visitor) {
        return visitor.visitLocalRef(this);
    }

    private static String createName(int index) {
        return NAMES.get(index);
    }
}

