/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.advise;

import com.google.common.collect.Iterables;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.enumerable.CallImplementor;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.schema.FunctionParameter;
import org.apache.calcite.schema.ImplementableFunction;
import org.apache.calcite.schema.TableFunction;
import org.apache.calcite.schema.impl.ReflectiveFunctionBase;
import org.apache.calcite.sql.advise.SqlAdvisor;
import org.apache.calcite.sql.advise.SqlAdvisorHint;
import org.apache.calcite.sql.validate.SqlMoniker;
import org.apache.calcite.util.BuiltInMethod;

public class SqlAdvisorGetHintsFunction
implements TableFunction,
ImplementableFunction {
    private static final Expression ADVISOR = Expressions.convert_((Expression)Expressions.call((Expression)DataContext.ROOT, (Method)BuiltInMethod.DATA_CONTEXT_GET.method, (Expression[])new Expression[]{Expressions.constant((Object)DataContext.Variable.SQL_ADVISOR.camelName)}), SqlAdvisor.class);
    private static final Method GET_COMPLETION_HINTS = Types.lookupMethod(SqlAdvisorGetHintsFunction.class, (String)"getCompletionHints", (Class[])new Class[]{SqlAdvisor.class, String.class, Integer.TYPE});
    private static final CallImplementor IMPLEMENTOR = RexImpTable.createImplementor(new NotNullImplementor(){

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> operands) {
            return Expressions.call((Method)GET_COMPLETION_HINTS, (Iterable)Iterables.concat(Collections.singleton(ADVISOR), operands));
        }
    }, NullPolicy.ANY, false);
    private static final List<FunctionParameter> PARAMETERS = ReflectiveFunctionBase.toFunctionParameters(String.class, Integer.TYPE);

    @Override
    public CallImplementor getImplementor() {
        return IMPLEMENTOR;
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory, List<Object> arguments) {
        return typeFactory.createJavaType(SqlAdvisorHint.class);
    }

    @Override
    public Type getElementType(List<Object> arguments) {
        return SqlAdvisorHint.class;
    }

    @Override
    public List<FunctionParameter> getParameters() {
        return PARAMETERS;
    }

    public static Enumerable<SqlAdvisorHint> getCompletionHints(SqlAdvisor advisor, String sql, int pos) {
        String[] replaced = new String[]{null};
        List<SqlMoniker> hints = advisor.getCompletionHints(sql, pos, replaced);
        ArrayList<SqlAdvisorHint> res = new ArrayList<SqlAdvisorHint>(hints.size() + 1);
        res.add(new SqlAdvisorHint(replaced[0], null, "MATCH"));
        for (SqlMoniker hint : hints) {
            res.add(new SqlAdvisorHint(hint));
        }
        return Linq4j.asEnumerable(res).asQueryable();
    }
}

