/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql2rel;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.SemiJoin;
import org.apache.calcite.rel.core.SetOp;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableFunctionScan;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalTableFunctionScan;
import org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rules.ProjectRemoveRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexPermuteInputsShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.ReflectUtil;
import org.apache.calcite.util.ReflectiveVisitor;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.IntPair;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.MappingType;
import org.apache.calcite.util.mapping.Mappings;

public class RelFieldTrimmer
implements ReflectiveVisitor {
    private final ReflectUtil.MethodDispatcher<TrimResult> trimFieldsDispatcher;
    private final RelFactories.ProjectFactory projectFactory;
    private final RelFactories.FilterFactory filterFactory;
    private final RelFactories.JoinFactory joinFactory;
    private final RelFactories.SemiJoinFactory semiJoinFactory;
    private final RelFactories.SortFactory sortFactory;
    private final RelFactories.AggregateFactory aggregateFactory;
    private final RelFactories.SetOpFactory setOpFactory;

    public RelFieldTrimmer(SqlValidator validator) {
        this(validator, RelFactories.DEFAULT_PROJECT_FACTORY, RelFactories.DEFAULT_FILTER_FACTORY, RelFactories.DEFAULT_JOIN_FACTORY, RelFactories.DEFAULT_SEMI_JOIN_FACTORY, RelFactories.DEFAULT_SORT_FACTORY, RelFactories.DEFAULT_AGGREGATE_FACTORY, RelFactories.DEFAULT_SET_OP_FACTORY);
    }

    public RelFieldTrimmer(SqlValidator validator, RelFactories.ProjectFactory projectFactory, RelFactories.FilterFactory filterFactory, RelFactories.JoinFactory joinFactory, RelFactories.SemiJoinFactory semiJoinFactory, RelFactories.SortFactory sortFactory, RelFactories.AggregateFactory aggregateFactory, RelFactories.SetOpFactory setOpFactory) {
        Util.discard(validator);
        this.trimFieldsDispatcher = ReflectUtil.createMethodDispatcher(TrimResult.class, this, "trimFields", RelNode.class, ImmutableBitSet.class, Set.class);
        this.projectFactory = (RelFactories.ProjectFactory)Preconditions.checkNotNull((Object)projectFactory);
        this.filterFactory = (RelFactories.FilterFactory)Preconditions.checkNotNull((Object)filterFactory);
        this.joinFactory = (RelFactories.JoinFactory)Preconditions.checkNotNull((Object)joinFactory);
        this.semiJoinFactory = (RelFactories.SemiJoinFactory)Preconditions.checkNotNull((Object)semiJoinFactory);
        this.sortFactory = (RelFactories.SortFactory)Preconditions.checkNotNull((Object)sortFactory);
        this.aggregateFactory = (RelFactories.AggregateFactory)Preconditions.checkNotNull((Object)aggregateFactory);
        this.setOpFactory = (RelFactories.SetOpFactory)Preconditions.checkNotNull((Object)setOpFactory);
    }

    public RelNode trim(RelNode root) {
        int fieldCount = root.getRowType().getFieldCount();
        ImmutableBitSet fieldsUsed = ImmutableBitSet.range(fieldCount);
        Set<RelDataTypeField> extraFields = Collections.emptySet();
        TrimResult trimResult = this.dispatchTrimFields(root, fieldsUsed, extraFields);
        if (!((Mapping)trimResult.right).isIdentity()) {
            throw new IllegalArgumentException();
        }
        return (RelNode)trimResult.left;
    }

    protected TrimResult trimChild(RelNode rel, RelNode input, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        Util.discard(rel);
        if (input.getClass().getName().endsWith("MedMdrClassExtentRel")) {
            fieldsUsed = ImmutableBitSet.range(input.getRowType().getFieldCount());
        }
        ImmutableList<RelCollation> collations = RelMetadataQuery.collations(rel);
        for (RelCollation collation : collations) {
            for (RelFieldCollation fieldCollation : collation.getFieldCollations()) {
                fieldsUsed = fieldsUsed.set(fieldCollation.getFieldIndex());
            }
        }
        return this.dispatchTrimFields(input, fieldsUsed, extraFields);
    }

    protected TrimResult trimChildRestore(RelNode rel, RelNode input, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        TrimResult trimResult = this.trimChild(rel, input, fieldsUsed, extraFields);
        if (((Mapping)trimResult.right).isIdentity()) {
            return trimResult;
        }
        RelDataType rowType = input.getRowType();
        List<RelDataTypeField> fieldList = rowType.getFieldList();
        ArrayList<RexNode> exprList = new ArrayList<RexNode>();
        List<String> nameList = rowType.getFieldNames();
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        assert (((Mapping)trimResult.right).getSourceCount() == fieldList.size());
        for (int i = 0; i < fieldList.size(); ++i) {
            int source = ((Mapping)trimResult.right).getTargetOpt(i);
            RelDataTypeField field = fieldList.get(i);
            exprList.add(source < 0 ? rexBuilder.makeZeroLiteral(field.getType()) : rexBuilder.makeInputRef(field.getType(), source));
        }
        RelNode project = this.projectFactory.createProject((RelNode)trimResult.left, exprList, nameList);
        return new TrimResult(project, Mappings.createIdentity(fieldList.size()));
    }

    protected final TrimResult dispatchTrimFields(RelNode rel, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        TrimResult trimResult = this.trimFieldsDispatcher.invoke(rel, fieldsUsed, extraFields);
        RelNode newRel = (RelNode)trimResult.left;
        Mapping mapping = (Mapping)trimResult.right;
        int fieldCount = rel.getRowType().getFieldCount();
        assert (mapping.getSourceCount() == fieldCount) : "source: " + mapping.getSourceCount() + " != " + fieldCount;
        int newFieldCount = newRel.getRowType().getFieldCount();
        assert (mapping.getTargetCount() + extraFields.size() == newFieldCount) : "target: " + mapping.getTargetCount() + " + " + extraFields.size() + " != " + newFieldCount;
        if (newRel.equals(rel)) {
            return new TrimResult(rel, mapping);
        }
        return trimResult;
    }

    public TrimResult trimFields(RelNode rel, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        Util.discard(fieldsUsed);
        return new TrimResult(rel, Mappings.createIdentity(rel.getRowType().getFieldCount()));
    }

    public TrimResult trimFields(Project project, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        RelNode newProject;
        RelDataType rowType = project.getRowType();
        int fieldCount = rowType.getFieldCount();
        RelNode input = project.getInput();
        RelDataType inputRowType = input.getRowType();
        LinkedHashSet<RelDataTypeField> inputExtraFields = new LinkedHashSet<RelDataTypeField>(extraFields);
        RelOptUtil.InputFinder inputFinder = new RelOptUtil.InputFinder(inputExtraFields);
        for (Ord ord : Ord.zip(project.getProjects())) {
            if (!fieldsUsed.get(ord.i)) continue;
            ((RexNode)ord.e).accept(inputFinder);
        }
        ImmutableBitSet inputFieldsUsed = inputFinder.inputBitSet.build();
        TrimResult trimResult = this.trimChild(project, input, inputFieldsUsed, inputExtraFields);
        RelNode newInput = (RelNode)trimResult.left;
        Mapping inputMapping = (Mapping)trimResult.right;
        if (newInput == input && fieldsUsed.cardinality() == fieldCount) {
            return new TrimResult(project, Mappings.createIdentity(fieldCount));
        }
        if (fieldsUsed.cardinality() == 0) {
            return this.dummyProject(fieldCount, newInput);
        }
        ArrayList<RexNode> newProjects = new ArrayList<RexNode>();
        RexPermuteInputsShuttle shuttle = new RexPermuteInputsShuttle((Mappings.TargetMapping)inputMapping, newInput);
        Mapping mapping = Mappings.create(MappingType.INVERSE_SURJECTION, fieldCount, fieldsUsed.cardinality());
        for (Ord ord : Ord.zip(project.getProjects())) {
            if (!fieldsUsed.get(ord.i)) continue;
            mapping.set(ord.i, newProjects.size());
            RexNode newProjectExpr = ((RexNode)ord.e).accept(shuttle);
            newProjects.add(newProjectExpr);
        }
        RelDataType newRowType = RelOptUtil.permute(project.getCluster().getTypeFactory(), rowType, mapping);
        if (ProjectRemoveRule.isIdentity(newProjects, newInput.getRowType())) {
            newProject = newInput;
        } else {
            newProject = this.projectFactory.createProject(newInput, newProjects, newRowType.getFieldNames());
            assert (newProject.getClass() == project.getClass());
        }
        return new TrimResult(newProject, mapping);
    }

    private TrimResult dummyProject(int fieldCount, RelNode input) {
        RelOptCluster cluster = input.getCluster();
        Mapping mapping = Mappings.create(MappingType.INVERSE_SURJECTION, fieldCount, 1);
        if (input.getRowType().getFieldCount() == 1) {
            return new TrimResult(input, mapping);
        }
        RexLiteral expr = cluster.getRexBuilder().makeExactLiteral(BigDecimal.ZERO);
        RelNode newProject = this.projectFactory.createProject(input, (List<? extends RexNode>)ImmutableList.of((Object)expr), (List<String>)ImmutableList.of((Object)"DUMMY"));
        return new TrimResult(newProject, mapping);
    }

    public TrimResult trimFields(Filter filter, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        RelDataType rowType = filter.getRowType();
        int fieldCount = rowType.getFieldCount();
        RexNode conditionExpr = filter.getCondition();
        RelNode input = filter.getInput();
        LinkedHashSet<RelDataTypeField> inputExtraFields = new LinkedHashSet<RelDataTypeField>(extraFields);
        RelOptUtil.InputFinder inputFinder = new RelOptUtil.InputFinder(inputExtraFields);
        inputFinder.inputBitSet.addAll(fieldsUsed);
        conditionExpr.accept(inputFinder);
        ImmutableBitSet inputFieldsUsed = inputFinder.inputBitSet.build();
        TrimResult trimResult = this.trimChild(filter, input, inputFieldsUsed, inputExtraFields);
        RelNode newInput = (RelNode)trimResult.left;
        Mapping inputMapping = (Mapping)trimResult.right;
        if (newInput == input && fieldsUsed.cardinality() == fieldCount) {
            return new TrimResult(filter, Mappings.createIdentity(fieldCount));
        }
        RexPermuteInputsShuttle shuttle = new RexPermuteInputsShuttle((Mappings.TargetMapping)inputMapping, newInput);
        RexNode newConditionExpr = conditionExpr.accept(shuttle);
        RelNode newFilter = this.filterFactory.createFilter(newInput, newConditionExpr);
        return new TrimResult(newFilter, inputMapping);
    }

    public TrimResult trimFields(Sort sort, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        RelDataType rowType = sort.getRowType();
        int fieldCount = rowType.getFieldCount();
        RelCollation collation = sort.getCollation();
        RelNode input = sort.getInput();
        ImmutableBitSet.Builder inputFieldsUsed = ImmutableBitSet.builder(fieldsUsed);
        for (RelFieldCollation field : collation.getFieldCollations()) {
            inputFieldsUsed.set(field.getFieldIndex());
        }
        Set<RelDataTypeField> inputExtraFields = Collections.emptySet();
        TrimResult trimResult = this.trimChild(sort, input, inputFieldsUsed.build(), inputExtraFields);
        RelNode newInput = (RelNode)trimResult.left;
        Mapping inputMapping = (Mapping)trimResult.right;
        if (newInput == input && inputMapping.isIdentity() && fieldsUsed.cardinality() == fieldCount) {
            return new TrimResult(sort, Mappings.createIdentity(fieldCount));
        }
        RelCollation newCollation = sort.getTraitSet().canonize(RexUtil.apply((Mappings.TargetMapping)inputMapping, collation));
        RelTraitSet newTraitSet = sort.getTraitSet().replace(newCollation);
        RelNode newSort = this.sortFactory.createSort(newTraitSet, newInput, newCollation, sort.offset, sort.fetch);
        return new TrimResult(newSort, inputMapping);
    }

    public TrimResult trimFields(Join join, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        RelNode newJoin;
        int fieldCount = join.getSystemFieldList().size() + join.getLeft().getRowType().getFieldCount() + join.getRight().getRowType().getFieldCount();
        RexNode conditionExpr = join.getCondition();
        int systemFieldCount = join.getSystemFieldList().size();
        LinkedHashSet<RelDataTypeField> combinedInputExtraFields = new LinkedHashSet<RelDataTypeField>(extraFields);
        RelOptUtil.InputFinder inputFinder = new RelOptUtil.InputFinder(combinedInputExtraFields);
        inputFinder.inputBitSet.addAll(fieldsUsed);
        conditionExpr.accept(inputFinder);
        ImmutableBitSet fieldsUsedPlus = inputFinder.inputBitSet.build();
        int systemFieldUsedCount = 0;
        for (int i = 0; i < systemFieldCount; ++i) {
            if (!fieldsUsed.get(i)) continue;
            ++systemFieldUsedCount;
        }
        int newSystemFieldCount = systemFieldUsedCount == 0 ? 0 : systemFieldCount;
        int offset = systemFieldCount;
        int changeCount = 0;
        int newFieldCount = newSystemFieldCount;
        ArrayList<Object> newInputs = new ArrayList<Object>(2);
        ArrayList<Mapping> inputMappings = new ArrayList<Mapping>();
        ArrayList<Integer> inputExtraFieldCounts = new ArrayList<Integer>();
        for (RelNode input : join.getInputs()) {
            RelDataType inputRowType = input.getRowType();
            int inputFieldCount = inputRowType.getFieldCount();
            ImmutableBitSet.Builder inputFieldsUsed = ImmutableBitSet.builder();
            for (int bit : fieldsUsedPlus) {
                if (bit < offset || bit >= offset + inputFieldCount) continue;
                inputFieldsUsed.set(bit - offset);
            }
            inputFieldsUsed.set(0, newSystemFieldCount);
            Set<RelDataTypeField> inputExtraFields = RelDataTypeImpl.extra(inputRowType) == null ? Collections.emptySet() : combinedInputExtraFields;
            inputExtraFieldCounts.add(inputExtraFields.size());
            TrimResult trimResult = this.trimChild(join, input, inputFieldsUsed.build(), inputExtraFields);
            newInputs.add(trimResult.left);
            if (trimResult.left != input) {
                ++changeCount;
            }
            Mapping inputMapping = (Mapping)trimResult.right;
            inputMappings.add(inputMapping);
            offset += inputFieldCount;
            newFieldCount += inputMapping.getTargetCount() + inputExtraFields.size();
        }
        Mapping mapping = Mappings.create(MappingType.INVERSE_SURJECTION, fieldCount, newFieldCount);
        for (int i = 0; i < newSystemFieldCount; ++i) {
            mapping.set(i, i);
        }
        offset = systemFieldCount;
        int newOffset = newSystemFieldCount;
        for (int i = 0; i < inputMappings.size(); ++i) {
            Mapping inputMapping = (Mapping)inputMappings.get(i);
            for (IntPair pair : inputMapping) {
                mapping.set(pair.source + offset, pair.target + newOffset);
            }
            offset += inputMapping.getSourceCount();
            newOffset += inputMapping.getTargetCount() + (Integer)inputExtraFieldCounts.get(i);
        }
        if (changeCount == 0 && mapping.isIdentity()) {
            return new TrimResult(join, Mappings.createIdentity(fieldCount));
        }
        RexPermuteInputsShuttle shuttle = new RexPermuteInputsShuttle((Mappings.TargetMapping)mapping, (RelNode)newInputs.get(0), (RelNode)newInputs.get(1));
        RexNode newConditionExpr = conditionExpr.accept(shuttle);
        if (join instanceof SemiJoin) {
            newJoin = this.semiJoinFactory.createSemiJoin((RelNode)newInputs.get(0), (RelNode)newInputs.get(1), newConditionExpr);
            Mapping inputMapping = (Mapping)inputMappings.get(0);
            mapping = Mappings.create(MappingType.INVERSE_SURJECTION, join.getRowType().getFieldCount(), newSystemFieldCount + inputMapping.getTargetCount());
            for (int i = 0; i < newSystemFieldCount; ++i) {
                mapping.set(i, i);
            }
            offset = systemFieldCount;
            newOffset = newSystemFieldCount;
            for (IntPair pair : inputMapping) {
                mapping.set(pair.source + offset, pair.target + newOffset);
            }
        } else {
            newJoin = this.joinFactory.createJoin((RelNode)newInputs.get(0), (RelNode)newInputs.get(1), newConditionExpr, join.getJoinType(), join.getVariablesStopped(), join.isSemiJoinDone());
        }
        return new TrimResult(newJoin, mapping);
    }

    public TrimResult trimFields(SetOp setOp, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        RelDataType rowType = setOp.getRowType();
        int fieldCount = rowType.getFieldCount();
        int changeCount = 0;
        if (fieldsUsed.isEmpty()) {
            fieldsUsed = ImmutableBitSet.of(rowType.getFieldCount() - 1);
        }
        Mapping mapping = this.createMapping(fieldsUsed, fieldCount);
        ArrayList<RelNode> newInputs = new ArrayList<RelNode>();
        for (RelNode input : setOp.getInputs()) {
            TrimResult trimResult = this.trimChild(setOp, input, fieldsUsed, extraFields);
            RelNode newInput = (RelNode)trimResult.left;
            Mapping inputMapping = (Mapping)trimResult.right;
            Mapping remaining = Mappings.divide(mapping, inputMapping);
            if (input != (newInput = RelOptUtil.projectMapping(newInput, remaining, null, this.projectFactory))) {
                ++changeCount;
            }
            newInputs.add(newInput);
        }
        if (changeCount == 0 && mapping.isIdentity()) {
            return new TrimResult(setOp, mapping);
        }
        RelNode newSetOp = this.setOpFactory.createSetOp(setOp.kind, newInputs, setOp.all);
        return new TrimResult(newSetOp, mapping);
    }

    public TrimResult trimFields(Aggregate aggregate, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        RelDataType rowType = aggregate.getRowType();
        ImmutableBitSet.Builder inputFieldsUsed = ImmutableBitSet.builder(aggregate.getGroupSet());
        for (AggregateCall aggCall : aggregate.getAggCallList()) {
            for (int i : aggCall.getArgList()) {
                inputFieldsUsed.set(i);
            }
            if (aggCall.filterArg < 0) continue;
            inputFieldsUsed.set(aggCall.filterArg);
        }
        RelNode input = aggregate.getInput();
        Set<RelDataTypeField> inputExtraFields = Collections.emptySet();
        TrimResult trimResult = this.trimChild(aggregate, input, inputFieldsUsed.build(), inputExtraFields);
        RelNode newInput = (RelNode)trimResult.left;
        final Mapping inputMapping = (Mapping)trimResult.right;
        int groupCount = aggregate.getGroupSet().cardinality();
        int indicatorCount = aggregate.getIndicatorCount();
        fieldsUsed = fieldsUsed.union(ImmutableBitSet.range(groupCount + indicatorCount));
        if (input == newInput && fieldsUsed.equals(ImmutableBitSet.range(rowType.getFieldCount()))) {
            return new TrimResult(aggregate, Mappings.createIdentity(rowType.getFieldCount()));
        }
        int j = groupCount + indicatorCount;
        int usedAggCallCount = 0;
        for (int i = 0; i < aggregate.getAggCallList().size(); ++i) {
            if (!fieldsUsed.get(j++)) continue;
            ++usedAggCallCount;
        }
        Mapping mapping = Mappings.create(MappingType.INVERSE_SURJECTION, rowType.getFieldCount(), groupCount + indicatorCount + usedAggCallCount);
        ImmutableBitSet newGroupSet = Mappings.apply(inputMapping, aggregate.getGroupSet());
        ImmutableList newGroupSets = ImmutableList.copyOf((Iterable)Iterables.transform(aggregate.getGroupSets(), (Function)new Function<ImmutableBitSet, ImmutableBitSet>(){

            public ImmutableBitSet apply(ImmutableBitSet input) {
                return Mappings.apply(inputMapping, input);
            }
        }));
        for (IntPair pair : inputMapping) {
            if (pair.source >= groupCount) continue;
            mapping.set(pair.source, pair.target);
            if (!aggregate.indicator) continue;
            mapping.set(pair.source + groupCount, pair.target + groupCount);
        }
        ArrayList<AggregateCall> newAggCallList = new ArrayList<AggregateCall>();
        j = groupCount + indicatorCount;
        for (AggregateCall aggCall : aggregate.getAggCallList()) {
            if (fieldsUsed.get(j)) {
                AggregateCall newAggCall = aggCall.copy(Mappings.apply2(inputMapping, aggCall.getArgList()), Mappings.apply((Mappings.TargetMapping)inputMapping, aggCall.filterArg));
                if (newAggCall.equals(aggCall)) {
                    newAggCall = aggCall;
                }
                mapping.set(j, groupCount + indicatorCount + newAggCallList.size());
                newAggCallList.add(newAggCall);
            }
            ++j;
        }
        RelNode newAggregate = this.aggregateFactory.createAggregate(newInput, aggregate.indicator, newGroupSet, (ImmutableList<ImmutableBitSet>)newGroupSets, newAggCallList);
        assert (newAggregate.getClass() == aggregate.getClass());
        return new TrimResult(newAggregate, mapping);
    }

    public TrimResult trimFields(LogicalTableModify modifier, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        Util.discard(fieldsUsed);
        RelDataType rowType = modifier.getRowType();
        int fieldCount = rowType.getFieldCount();
        RelNode input = modifier.getInput();
        int inputFieldCount = input.getRowType().getFieldCount();
        ImmutableBitSet inputFieldsUsed = ImmutableBitSet.range(inputFieldCount);
        Set<RelDataTypeField> inputExtraFields = Collections.emptySet();
        TrimResult trimResult = this.trimChild(modifier, input, inputFieldsUsed, inputExtraFields);
        RelNode newInput = (RelNode)trimResult.left;
        Mapping inputMapping = (Mapping)trimResult.right;
        if (!inputMapping.isIdentity()) {
            throw Util.newInternal("Expected identity mapping, got " + inputMapping);
        }
        RelNode newModifier = modifier;
        if (newInput != input) {
            newModifier = modifier.copy(modifier.getTraitSet(), (List)Collections.singletonList(newInput));
        }
        assert (newModifier.getClass() == modifier.getClass());
        Mappings.IdentityMapping mapping = Mappings.createIdentity(fieldCount);
        return new TrimResult(newModifier, mapping);
    }

    public TrimResult trimFields(LogicalTableFunctionScan tabFun, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        RelDataType rowType = tabFun.getRowType();
        int fieldCount = rowType.getFieldCount();
        ArrayList<Object> newInputs = new ArrayList<Object>();
        for (RelNode input : tabFun.getInputs()) {
            int inputFieldCount = input.getRowType().getFieldCount();
            ImmutableBitSet inputFieldsUsed = ImmutableBitSet.range(inputFieldCount);
            Set<RelDataTypeField> inputExtraFields = Collections.emptySet();
            TrimResult trimResult = this.trimChildRestore(tabFun, input, inputFieldsUsed, inputExtraFields);
            assert (((Mapping)trimResult.right).isIdentity());
            newInputs.add(trimResult.left);
        }
        TableFunctionScan newTabFun = tabFun;
        if (!tabFun.getInputs().equals(newInputs)) {
            newTabFun = tabFun.copy(tabFun.getTraitSet(), newInputs, tabFun.getCall(), tabFun.getElementType(), tabFun.getRowType(), (Set)tabFun.getColumnMappings());
        }
        assert (newTabFun.getClass() == tabFun.getClass());
        Mappings.IdentityMapping mapping = Mappings.createIdentity(fieldCount);
        return new TrimResult(newTabFun, mapping);
    }

    public TrimResult trimFields(LogicalValues values, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        RelDataType rowType = values.getRowType();
        int fieldCount = rowType.getFieldCount();
        if (fieldsUsed.isEmpty()) {
            fieldsUsed = ImmutableBitSet.range(fieldCount - 1, fieldCount);
        }
        if (fieldsUsed.equals(ImmutableBitSet.range(fieldCount))) {
            Mappings.IdentityMapping mapping = Mappings.createIdentity(fieldCount);
            return new TrimResult(values, mapping);
        }
        ImmutableList.Builder newTuples = ImmutableList.builder();
        for (ImmutableList tuple : values.getTuples()) {
            ImmutableList.Builder newTuple = ImmutableList.builder();
            for (int field : fieldsUsed) {
                newTuple.add(tuple.get(field));
            }
            newTuples.add((Object)newTuple.build());
        }
        Mapping mapping = this.createMapping(fieldsUsed, fieldCount);
        RelDataType newRowType = RelOptUtil.permute(values.getCluster().getTypeFactory(), rowType, mapping);
        LogicalValues newValues = LogicalValues.create(values.getCluster(), newRowType, (ImmutableList<ImmutableList<RexLiteral>>)newTuples.build());
        return new TrimResult(newValues, mapping);
    }

    private Mapping createMapping(ImmutableBitSet fieldsUsed, int fieldCount) {
        Mapping mapping = Mappings.create(MappingType.INVERSE_SURJECTION, fieldCount, fieldsUsed.cardinality());
        int i = 0;
        for (int field : fieldsUsed) {
            mapping.set(field, i++);
        }
        return mapping;
    }

    public TrimResult trimFields(TableScan tableAccessRel, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        int fieldCount = tableAccessRel.getRowType().getFieldCount();
        if (fieldsUsed.equals(ImmutableBitSet.range(fieldCount)) && extraFields.isEmpty()) {
            return this.trimFields((RelNode)tableAccessRel, fieldsUsed, extraFields);
        }
        RelNode newTableAccessRel = tableAccessRel.project(fieldsUsed, extraFields, this.projectFactory);
        if (fieldsUsed.cardinality() == 0) {
            Project project;
            RelNode input = newTableAccessRel;
            if (input instanceof Project && (project = (Project)input).getRowType().getFieldCount() == 0) {
                input = project.getInput();
            }
            return this.dummyProject(fieldCount, input);
        }
        Mapping mapping = this.createMapping(fieldsUsed, fieldCount);
        return new TrimResult(newTableAccessRel, mapping);
    }

    protected static class TrimResult
    extends Pair<RelNode, Mapping> {
        public TrimResult(RelNode left, Mapping right) {
            super(left, right);
        }
    }
}

