/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.rest;

import com.google.common.collect.Maps;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.restli.common.ComplexResourceKey;
import com.linkedin.restli.common.EmptyRecord;
import com.linkedin.restli.server.ResourceContext;
import com.linkedin.restli.server.annotations.RestLiCollection;
import com.linkedin.restli.server.resources.ComplexKeyResourceTemplate;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.gobblin.metastore.JobHistoryStore;
import org.apache.gobblin.rest.JobExecutionInfo;
import org.apache.gobblin.rest.JobExecutionInfoArray;
import org.apache.gobblin.rest.JobExecutionQuery;
import org.apache.gobblin.rest.JobExecutionQueryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RestLiCollection(name="jobExecutions", namespace="org.apache.gobblin.rest")
public class JobExecutionInfoResource
extends ComplexKeyResourceTemplate<JobExecutionQuery, EmptyRecord, JobExecutionQueryResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobExecutionInfoResource.class);
    @Inject
    @Named(value="jobHistoryStore")
    private JobHistoryStore jobHistoryStore;

    public JobExecutionQueryResult get(ComplexResourceKey<JobExecutionQuery, EmptyRecord> key) {
        JobExecutionQuery query = (JobExecutionQuery)key.getKey();
        JobExecutionInfoArray jobExecutionInfos = new JobExecutionInfoArray();
        try {
            for (JobExecutionInfo jobExecutionInfo : this.jobHistoryStore.get(query)) {
                jobExecutionInfos.add((DataTemplate)jobExecutionInfo);
            }
        }
        catch (Throwable t) {
            LOGGER.error(String.format("Failed to execute query [id = %s, type = %s]", query.getId(), query.getIdType().name()), t);
            return null;
        }
        JobExecutionQueryResult result = new JobExecutionQueryResult();
        result.setJobExecutions(jobExecutionInfos);
        ResourceContext rc = this.getContext();
        rc.setResponseHeader("Access-Control-Allow-Origin", "*");
        this.setContext(rc);
        return result;
    }

    public Map<ComplexResourceKey<JobExecutionQuery, EmptyRecord>, JobExecutionQueryResult> batchGet(Set<ComplexResourceKey<JobExecutionQuery, EmptyRecord>> keys) {
        HashMap results = Maps.newHashMap();
        for (ComplexResourceKey<JobExecutionQuery, EmptyRecord> key : keys) {
            JobExecutionQueryResult result = this.get(key);
            if (result == null) continue;
            results.put(key, this.get(key));
        }
        ResourceContext rc = this.getContext();
        rc.setResponseHeader("Access-Control-Allow-Origin", "*");
        this.setContext(rc);
        return results;
    }
}

