/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.restli;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.gobblin.restli.SharedRestClientFactory;
import org.apache.gobblin.restli.SharedRestClientKey;

public class UriRestClientKey
extends SharedRestClientKey {
    private final String uri;

    public UriRestClientKey(String serviceName, URI uri) {
        super(serviceName);
        try {
            Preconditions.checkNotNull((Object)uri, (Object)"URI cannot be null.");
            this.uri = SharedRestClientFactory.resolveUriPrefix(uri);
        }
        catch (URISyntaxException use) {
            throw new RuntimeException(use);
        }
    }

    public UriRestClientKey(String serviceName, String uriPrefix) {
        super(serviceName);
        this.uri = uriPrefix;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UriRestClientKey that = (UriRestClientKey)o;
        return this.uri.equals(that.uri);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.uri.hashCode();
        return result;
    }

    public String getUri() {
        return this.uri;
    }
}

