/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.eventhub.writer;

import com.typesafe.config.Config;
import java.io.IOException;
import java.util.Properties;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.eventhub.writer.BatchedEventhubDataWriter;
import org.apache.gobblin.eventhub.writer.EventhubBatchAccumulator;
import org.apache.gobblin.eventhub.writer.EventhubDataWriter;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.writer.AsyncDataWriter;
import org.apache.gobblin.writer.AsyncWriterManager;
import org.apache.gobblin.writer.DataWriter;
import org.apache.gobblin.writer.DataWriterBuilder;

public class EventhubDataWriterBuilder
extends DataWriterBuilder {
    public AsyncDataWriter getAsyncDataWriter(Properties properties) {
        EventhubDataWriter eventhubDataWriter = new EventhubDataWriter(properties);
        EventhubBatchAccumulator accumulator = new EventhubBatchAccumulator(properties);
        BatchedEventhubDataWriter batchedEventhubDataWriter = new BatchedEventhubDataWriter(accumulator, eventhubDataWriter);
        return batchedEventhubDataWriter;
    }

    public DataWriter build() throws IOException {
        State state = this.destination.getProperties();
        Properties taskProps = state.getProperties();
        Config config = ConfigUtils.propertiesToConfig((Properties)taskProps);
        long commitTimeoutMillis = ConfigUtils.getLong((Config)config, (String)"writer.eventhub.commitTimeoutMillis", (Long)60000L);
        long commitStepWaitTimeMillis = ConfigUtils.getLong((Config)config, (String)"writer.eventhub.commitStepWaitTimeMillis", (Long)500L);
        double failureAllowance = ConfigUtils.getDouble((Config)config, (String)"writer.eventhub.failureAllowancePercentage", (double)20.0) / 100.0;
        return AsyncWriterManager.builder().config(config).commitTimeoutMillis(commitTimeoutMillis).commitStepWaitTimeInMillis(commitStepWaitTimeMillis).failureAllowanceRatio(failureAllowance).retriesEnabled(false).asyncDataWriter(this.getAsyncDataWriter(taskProps)).maxOutstandingWrites(10000).build();
    }
}

