/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics;

import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.metrics.GobblinMetrics;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.Tag;

public class GobblinMetricsRegistry {
    private static final GobblinMetricsRegistry GLOBAL_INSTANCE = new GobblinMetricsRegistry();
    private final Cache<String, GobblinMetrics> metricsCache = CacheBuilder.newBuilder().build();

    private GobblinMetricsRegistry() {
    }

    public GobblinMetrics putIfAbsent(String id, GobblinMetrics gobblinMetrics) {
        return this.metricsCache.asMap().putIfAbsent(id, gobblinMetrics);
    }

    public Optional<GobblinMetrics> get(String id) {
        return Optional.fromNullable((Object)this.metricsCache.getIfPresent((Object)id));
    }

    public GobblinMetrics getOrDefault(String id, Callable<? extends GobblinMetrics> valueLoader) {
        try {
            return (GobblinMetrics)this.metricsCache.get((Object)id, valueLoader);
        }
        catch (ExecutionException ee) {
            throw Throwables.propagate((Throwable)ee);
        }
    }

    public GobblinMetrics remove(String id) {
        return (GobblinMetrics)this.metricsCache.asMap().remove(id);
    }

    public static GobblinMetricsRegistry getInstance() {
        return GLOBAL_INSTANCE;
    }

    public MetricContext getMetricContext(State state, Class<?> klazz, List<Tag<?>> tags) {
        int randomId = new Random().nextInt(Integer.MAX_VALUE);
        ArrayList generatedTags = Lists.newArrayList();
        if (!klazz.isAnonymousClass()) {
            generatedTags.add(new Tag("class", (Object)klazz.getCanonicalName()));
        }
        Optional<GobblinMetrics> gobblinMetrics = state.contains("metrics.context.name") ? GobblinMetricsRegistry.getInstance().get(state.getProp("metrics.context.name")) : Optional.absent();
        MetricContext.Builder builder = gobblinMetrics.isPresent() ? ((GobblinMetrics)gobblinMetrics.get()).getMetricContext().childBuilder(klazz.getCanonicalName() + "." + randomId) : MetricContext.builder((String)(klazz.getCanonicalName() + "." + randomId));
        return builder.addTags((Collection)generatedTags).addTags(tags).build();
    }
}

