/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.server.guice;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.linkedin.parseq.Engine;
import com.linkedin.r2.filter.FilterChain;
import com.linkedin.r2.filter.FilterChains;
import com.linkedin.r2.filter.transport.FilterChainDispatcher;
import com.linkedin.r2.transport.common.RestRequestHandler;
import com.linkedin.r2.transport.common.StreamRequestHandler;
import com.linkedin.r2.transport.common.bridge.server.TransportDispatcher;
import com.linkedin.r2.transport.http.server.RAPServlet;
import com.linkedin.restli.server.DelegatingTransportDispatcher;
import com.linkedin.restli.server.RestLiConfig;
import com.linkedin.restli.server.RestLiServer;
import com.linkedin.restli.server.guice.GuiceInjectResourceFactory;
import com.linkedin.restli.server.resources.ResourceFactory;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;

@Singleton
public class GuiceRestliServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private final HttpServlet _r2Servlet;

    @Inject
    public GuiceRestliServlet(RestLiConfig config, GuiceInjectResourceFactory resourceFactory, OptionalFilterChain filterChain, OptionalEngine engine) {
        RestLiServer restliServer = new RestLiServer(config, (ResourceFactory)resourceFactory, engine.value);
        this._r2Servlet = new RAPServlet((TransportDispatcher)new FilterChainDispatcher((TransportDispatcher)new DelegatingTransportDispatcher((RestRequestHandler)restliServer, (StreamRequestHandler)restliServer), filterChain.value));
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this._r2Servlet.init(servletConfig);
    }

    public void destroy() {
        this._r2Servlet.destroy();
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        this._r2Servlet.service(req, res);
    }

    public static class OptionalEngine {
        @Inject(optional=true)
        public Engine value = null;
    }

    public static class OptionalFilterChain {
        @Inject(optional=true)
        public FilterChain value = FilterChains.empty();
    }
}

