/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.hadoop;

import com.codahale.metrics.MetricFilter;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.hadoop.AbstractHadoopCounterReporter;
import org.apache.gobblin.metrics.reporter.ContextAwareScheduledReporter;
import org.apache.hadoop.mapred.Reporter;

public class HadoopCounterReporter
extends AbstractHadoopCounterReporter {
    private final Reporter reporter;

    protected HadoopCounterReporter(MetricContext context, String name, MetricFilter filter, TimeUnit rateUnit, TimeUnit durationUnit, Reporter reporter) {
        super(context, name, filter, rateUnit, durationUnit);
        this.reporter = reporter;
    }

    @Override
    protected void reportIncremental(MetricContext context, String name, long incremental) {
        this.reporter.getCounter(context.getName(), name).increment(incremental);
    }

    @Override
    protected void reportValue(MetricContext context, String name, long value) {
        this.reporter.getCounter(context.getName(), name).setValue(value);
    }

    public static Builder builder(Reporter reporter) {
        return HadoopCounterReporter.builder(HadoopCounterReporter.class.getName(), reporter);
    }

    public static Builder builder(String name, Reporter reporter) {
        return new Builder(name, reporter);
    }

    public static class Builder
    extends ContextAwareScheduledReporter.Builder<HadoopCounterReporter, Builder> {
        private final Reporter reporter;

        public Builder(String name, Reporter reporter) {
            super(name);
            this.reporter = reporter;
        }

        public HadoopCounterReporter build(MetricContext context) {
            return new HadoopCounterReporter(context, this.name, this.filter, this.rateUnit, this.durationUnit, this.reporter);
        }
    }
}

