/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.file;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.file.FileInfo;

@JsonIgnoreProperties(value={"dir"})
public class FileInfoDTO
implements FileInfo {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="isDir")
    private boolean isDir;
    @JsonProperty(value="size")
    private long size;
    @JsonProperty(value="lastModified")
    private long lastModified;
    @JsonProperty(value="path")
    private String path;

    private FileInfoDTO() {
    }

    private FileInfoDTO(String name, boolean isDir, long size, long lastModified, String path) {
        this.name = name;
        this.isDir = isDir;
        this.size = size;
        this.lastModified = lastModified;
        this.path = path;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean isDir() {
        return this.isDir;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public long lastModified() {
        return this.lastModified;
    }

    @Override
    public String path() {
        return this.path;
    }

    public static FileInfoDTOBuilder builder() {
        return new FileInfoDTOBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileInfoDTO)) {
            return false;
        }
        FileInfoDTO other = (FileInfoDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDir() != other.isDir()) {
            return false;
        }
        if (this.size != other.size) {
            return false;
        }
        if (this.lastModified != other.lastModified) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$path = this.path;
        String other$path = other.path;
        return !(this$path == null ? other$path != null : !this$path.equals(other$path));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileInfoDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDir() ? 79 : 97);
        long $size = this.size;
        result = result * 59 + (int)($size >>> 32 ^ $size);
        long $lastModified = this.lastModified;
        result = result * 59 + (int)($lastModified >>> 32 ^ $lastModified);
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $path = this.path;
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        return result;
    }

    public static class FileInfoDTOBuilder {
        private String name;
        private boolean isDir;
        private long size;
        private long lastModified;
        private String path;

        private FileInfoDTOBuilder() {
        }

        public FileInfoDTOBuilder name(String name) {
            this.name = name;
            return this;
        }

        public FileInfoDTOBuilder isDir(boolean isDir) {
            this.isDir = isDir;
            return this;
        }

        public FileInfoDTOBuilder size(long size) {
            this.size = size;
            return this;
        }

        public FileInfoDTOBuilder lastModified(long lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public FileInfoDTOBuilder path(String path) {
            this.path = path;
            return this;
        }

        public FileInfoDTO build() {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.name), (Object)"name cannot be null or empty");
            Preconditions.checkArgument((this.size >= 0L ? 1 : 0) != 0, (Object)"size cannot be negative");
            Preconditions.checkArgument((this.lastModified > 0L ? 1 : 0) != 0, (Object)"lastModified must be a valid timestamp");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.path), (Object)"path cannot be null or empty");
            return new FileInfoDTO(this.name, this.isDir, this.size, this.lastModified, this.path);
        }
    }
}

