/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.dataset.scanner;

import java.io.IOException;
import java.util.Iterator;
import org.apache.arrow.dataset.scanner.ScanTask;
import org.apache.arrow.dataset.scanner.Scanner;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.VectorLoader;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.ipc.ArrowReader;
import org.apache.arrow.vector.ipc.message.ArrowDictionaryBatch;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.types.pojo.Schema;

public class ArrowScannerReader
extends ArrowReader {
    private final Scanner scanner;
    private Iterator<? extends ScanTask> taskIterator;
    private ScanTask currentTask = null;
    private ArrowReader currentReader = null;

    public ArrowScannerReader(Scanner scanner, BufferAllocator allocator) {
        super(allocator);
        this.scanner = scanner;
        this.taskIterator = scanner.scan().iterator();
        if (this.taskIterator.hasNext()) {
            this.currentTask = this.taskIterator.next();
            this.currentReader = this.currentTask.execute();
        }
    }

    protected void loadRecordBatch(ArrowRecordBatch batch) {
        throw new UnsupportedOperationException();
    }

    protected void loadDictionary(ArrowDictionaryBatch dictionaryBatch) {
        throw new UnsupportedOperationException();
    }

    public boolean loadNextBatch() throws IOException {
        if (this.currentReader == null) {
            return false;
        }
        boolean result = this.currentReader.loadNextBatch();
        if (!result) {
            try {
                this.currentTask.close();
                this.currentReader.close();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            while (!result) {
                if (!this.taskIterator.hasNext()) {
                    return false;
                }
                this.currentTask = this.taskIterator.next();
                this.currentReader = this.currentTask.execute();
                result = this.currentReader.loadNextBatch();
            }
        }
        VectorLoader loader = new VectorLoader(this.getVectorSchemaRoot());
        VectorUnloader unloader = new VectorUnloader(this.currentReader.getVectorSchemaRoot());
        try (ArrowRecordBatch recordBatch = unloader.getRecordBatch();){
            loader.load(recordBatch);
        }
        return true;
    }

    public long bytesRead() {
        return 0L;
    }

    protected void closeReadSource() throws IOException {
        try {
            this.currentTask.close();
            this.currentReader.close();
            this.scanner.close();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected Schema readSchema() throws IOException {
        return this.scanner.schema();
    }
}

