/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.CommandHandler;
import org.apache.gravitino.cli.FullName;
import org.apache.gravitino.cli.GravitinoCommandLine;
import org.apache.gravitino.cli.Main;
import org.apache.gravitino.cli.commands.Command;

public class TableCommandHandler
extends CommandHandler {
    private final GravitinoCommandLine gravitinoCommandLine;
    private final CommandLine line;
    private final String command;
    private final CommandContext context;
    private final FullName name;
    private final String metalake;
    private final String catalog;
    private final String schema;
    private String table;

    public TableCommandHandler(GravitinoCommandLine gravitinoCommandLine, CommandLine line, String command, CommandContext context) {
        this.gravitinoCommandLine = gravitinoCommandLine;
        this.line = line;
        this.command = command;
        this.context = context;
        this.name = new FullName(line);
        this.metalake = this.name.getMetalakeName();
        this.catalog = this.name.getCatalogName();
        this.schema = this.name.getSchemaName();
    }

    @Override
    protected void handle() {
        String userName = this.line.getOptionValue("login");
        Command.setAuthenticationMode(this.context.auth(), userName);
        ArrayList<String> missingEntities = Lists.newArrayList();
        if (this.catalog == null) {
            missingEntities.add("catalog");
        }
        if (this.schema == null) {
            missingEntities.add("schema");
        }
        if ("list".equals(this.command)) {
            this.checkEntities(missingEntities);
            this.handleListCommand();
            return;
        }
        this.table = this.name.getTableName();
        if (this.table == null) {
            missingEntities.add("table");
        }
        this.checkEntities(missingEntities);
        if (!this.executeCommand()) {
            System.err.println("Unsupported or unknown command.");
            Main.exit(-1);
        }
    }

    private boolean executeCommand() {
        switch (this.command) {
            case "details": {
                this.handleDetailsCommand();
                return true;
            }
            case "create": {
                this.handleCreateCommand();
                return true;
            }
            case "delete": {
                this.handleDeleteCommand();
                return true;
            }
            case "set": {
                this.handleSetCommand();
                return true;
            }
            case "remove": {
                this.handleRemoveCommand();
                return true;
            }
            case "properties": {
                this.handlePropertiesCommand();
                return true;
            }
            case "update": {
                this.handleUpdateCommand();
                return true;
            }
        }
        return false;
    }

    private void handleDetailsCommand() {
        if (this.line.hasOption("audit")) {
            this.gravitinoCommandLine.newTableAudit(this.context, this.metalake, this.catalog, this.schema, this.table).validate().handle();
        } else if (this.line.hasOption("index")) {
            this.gravitinoCommandLine.newListIndexes(this.context, this.metalake, this.catalog, this.schema, this.table).validate().handle();
        } else if (this.line.hasOption("distribution")) {
            this.gravitinoCommandLine.newTableDistribution(this.context, this.metalake, this.catalog, this.schema, this.table).validate().handle();
        } else if (this.line.hasOption("partition")) {
            this.gravitinoCommandLine.newTablePartition(this.context, this.metalake, this.catalog, this.schema, this.table).validate().handle();
        } else if (this.line.hasOption("sortorder")) {
            this.gravitinoCommandLine.newTableSortOrder(this.context, this.metalake, this.catalog, this.schema, this.table).validate().handle();
        } else {
            this.gravitinoCommandLine.newTableDetails(this.context, this.metalake, this.catalog, this.schema, this.table).validate().handle();
        }
    }

    private void handleCreateCommand() {
        String columnFile = this.line.getOptionValue("columnfile");
        String comment = this.line.getOptionValue("comment");
        this.gravitinoCommandLine.newCreateTable(this.context, this.metalake, this.catalog, this.schema, this.table, columnFile, comment).validate().handle();
    }

    private void handleDeleteCommand() {
        this.gravitinoCommandLine.newDeleteTable(this.context, this.metalake, this.catalog, this.schema, this.table).validate().handle();
    }

    private void handleSetCommand() {
        String property = this.line.getOptionValue("property");
        String value = this.line.getOptionValue("value");
        this.gravitinoCommandLine.newSetTableProperty(this.context, this.metalake, this.catalog, this.schema, this.table, property, value).validate().handle();
    }

    private void handleRemoveCommand() {
        String property = this.line.getOptionValue("property");
        this.gravitinoCommandLine.newRemoveTableProperty(this.context, this.metalake, this.catalog, this.schema, this.table, property).validate().handle();
    }

    private void handlePropertiesCommand() {
        this.gravitinoCommandLine.newListTableProperties(this.context, this.metalake, this.catalog, this.schema, this.table).validate().handle();
    }

    private void handleListCommand() {
        this.gravitinoCommandLine.newListTables(this.context, this.metalake, this.catalog, this.schema).validate().handle();
    }

    private void handleUpdateCommand() {
        if (this.line.hasOption("comment")) {
            String comment = this.line.getOptionValue("comment");
            this.gravitinoCommandLine.newUpdateTableComment(this.context, this.metalake, this.catalog, this.schema, this.table, comment).validate().handle();
        }
        if (this.line.hasOption("rename")) {
            String newName = this.line.getOptionValue("rename");
            this.gravitinoCommandLine.newUpdateTableName(this.context, this.metalake, this.catalog, this.schema, this.table, newName).validate().handle();
        }
    }
}

