/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.Catalog;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;

public class CatalogDetails
extends Command {
    protected final String metalake;
    protected final String catalog;

    public CatalogDetails(CommandContext context, String metalake, String catalog) {
        super(context);
        this.metalake = metalake;
        this.catalog = catalog;
    }

    @Override
    public void handle() {
        Catalog result = null;
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            result = client.loadCatalog(this.catalog);
            this.printResults(result);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchCatalogException err) {
            this.exitWithError("Unknown catalog name.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
    }
}

