/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.Catalog;
import org.apache.gravitino.Schema;
import org.apache.gravitino.cli.AreYouSure;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.FullName;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.cli.utils.FullNameUtil;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.file.Fileset;
import org.apache.gravitino.file.FilesetCatalog;
import org.apache.gravitino.messaging.Topic;
import org.apache.gravitino.messaging.TopicCatalog;
import org.apache.gravitino.model.Model;
import org.apache.gravitino.model.ModelCatalog;
import org.apache.gravitino.rel.Table;
import org.apache.gravitino.rel.TableCatalog;

public class RemoveAllTags
extends Command {
    protected String metalake;
    protected FullName name;
    protected final boolean force;

    public RemoveAllTags(CommandContext context, String metalake, FullName name) {
        super(context);
        this.metalake = metalake;
        this.name = name;
        this.force = context.force();
    }

    @Override
    public void handle() {
        if (!AreYouSure.really(this.force)) {
            return;
        }
        String entity = "unknown";
        CharSequence[] tags = new String[]{};
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            if (this.name.getLevel() == 3) {
                String catalog = this.name.getCatalogName();
                Catalog catalogObject = client.loadCatalog(catalog);
                switch (catalogObject.type()) {
                    case RELATIONAL: {
                        entity = "table";
                        TableCatalog tableCatalog = catalogObject.asTableCatalog();
                        Table gTable = tableCatalog.loadTable(FullNameUtil.toTable(this.name));
                        tags = gTable.supportsTags().listTags();
                        if (tags.length <= 0) break;
                        gTable.supportsTags().associateTags(null, (String[])tags);
                        break;
                    }
                    case MODEL: {
                        entity = "model";
                        ModelCatalog modelCatalog = catalogObject.asModelCatalog();
                        Model gModel = modelCatalog.getModel(FullNameUtil.toModel(this.name));
                        tags = gModel.supportsTags().listTags();
                        if (tags.length <= 0) break;
                        gModel.supportsTags().associateTags(null, (String[])tags);
                        break;
                    }
                    case FILESET: {
                        entity = "fileset";
                        FilesetCatalog filesetCatalog = catalogObject.asFilesetCatalog();
                        Fileset gFileset = filesetCatalog.loadFileset(FullNameUtil.toFileset(this.name));
                        tags = gFileset.supportsTags().listTags();
                        if (tags.length <= 0) break;
                        gFileset.supportsTags().associateTags(null, (String[])tags);
                        break;
                    }
                    case MESSAGING: {
                        entity = "topic";
                        TopicCatalog topicCatalog = catalogObject.asTopicCatalog();
                        Topic gTopic = topicCatalog.loadTopic(FullNameUtil.toTopic(this.name));
                        tags = gTopic.supportsTags().listTags();
                        if (tags.length <= 0) break;
                        gTopic.supportsTags().associateTags(null, (String[])tags);
                        break;
                    }
                }
            } else if (this.name.hasSchemaName()) {
                String catalog = this.name.getCatalogName();
                String schema = this.name.getSchemaName();
                Schema gSchema = client.loadCatalog(catalog).asSchemas().loadSchema(schema);
                tags = gSchema.supportsTags().listTags();
                if (tags.length > 0) {
                    gSchema.supportsTags().associateTags(null, (String[])tags);
                }
                entity = schema;
            } else if (this.name.hasCatalogName()) {
                String catalog = this.name.getCatalogName();
                Catalog gCatalog = client.loadCatalog(catalog);
                tags = gCatalog.supportsTags().listTags();
                if (tags.length > 0) {
                    gCatalog.supportsTags().associateTags(null, (String[])tags);
                }
                entity = catalog;
            }
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchCatalogException err) {
            this.exitWithError("Unknown catalog name.");
        }
        catch (NoSuchSchemaException err) {
            this.exitWithError("Unknown schema name.");
        }
        catch (NoSuchTableException err) {
            this.exitWithError("Unknown table name.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        if (tags.length > 0) {
            this.printInformation(entity + " removed tags " + String.join((CharSequence)",", tags) + " now tagged with nothing");
        } else {
            this.printInformation(entity + " has no tags");
        }
    }

    @Override
    public Command validate() {
        if (this.name == null || !this.name.hasName().booleanValue()) {
            this.exitWithError("Missing --name option.");
        }
        return super.validate();
    }
}

