/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import java.util.List;
import org.apache.gravitino.authorization.SecurableObject;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchRoleException;

public class RoleDetails
extends Command {
    protected String metalake;
    protected String role;

    public RoleDetails(CommandContext context, String metalake, String role) {
        super(context);
        this.metalake = metalake;
        this.role = role;
    }

    @Override
    public void handle() {
        List<SecurableObject> objects = null;
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            objects = client.getRole(this.role).securableObjects();
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchRoleException err) {
            this.exitWithError("Unknown role.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        if (objects == null || objects.isEmpty()) {
            this.printInformation("No securable objects found for role: " + this.role);
        } else {
            this.printResults(objects);
        }
    }
}

