/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.stats;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.stats.PartitionStatisticsDrop;

public class PartitionStatisticsDropDTO
implements PartitionStatisticsDrop {
    @JsonProperty(value="partitionName")
    private final String partitionName;
    @JsonProperty(value="statisticNames")
    private final List<String> statisticNames;

    protected PartitionStatisticsDropDTO() {
        this(null, null);
    }

    private PartitionStatisticsDropDTO(String partitionName, List<String> statisticNames) {
        this.partitionName = partitionName;
        this.statisticNames = statisticNames;
    }

    @Override
    public String partitionName() {
        return this.partitionName;
    }

    @Override
    public List<String> statisticNames() {
        return this.statisticNames;
    }

    public void validate() {
        Preconditions.checkArgument(StringUtils.isNotBlank(this.partitionName), "\"partitionName\" must not be null or empty");
        Preconditions.checkArgument(this.statisticNames != null && !this.statisticNames.isEmpty(), "\"statisticNames\" must not be null or empty");
        for (String statisticName : this.statisticNames) {
            Preconditions.checkArgument(StringUtils.isNotBlank(statisticName), "Each statistic \"name\" in \"statisticNames\" must not be null or empty");
        }
    }

    public static PartitionStatisticsDropDTO of(String partitionName, List<String> statisticNames) {
        PartitionStatisticsDropDTO dto = new PartitionStatisticsDropDTO(partitionName, statisticNames);
        dto.validate();
        return dto;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PartitionStatisticsDropDTO)) {
            return false;
        }
        PartitionStatisticsDropDTO other = (PartitionStatisticsDropDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$partitionName = this.partitionName;
        String other$partitionName = other.partitionName;
        if (this$partitionName == null ? other$partitionName != null : !this$partitionName.equals(other$partitionName)) {
            return false;
        }
        List<String> this$statisticNames = this.statisticNames;
        List<String> other$statisticNames = other.statisticNames;
        return !(this$statisticNames == null ? other$statisticNames != null : !((Object)this$statisticNames).equals(other$statisticNames));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PartitionStatisticsDropDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $partitionName = this.partitionName;
        result = result * 59 + ($partitionName == null ? 43 : $partitionName.hashCode());
        List<String> $statisticNames = this.statisticNames;
        result = result * 59 + ($statisticNames == null ? 43 : ((Object)$statisticNames).hashCode());
        return result;
    }

    public String toString() {
        return "PartitionStatisticsDropDTO(partitionName=" + this.partitionName + ", statisticNames=" + String.valueOf(this.statisticNames) + ")";
    }
}

