/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data.columnar;

import java.io.Serializable;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.columnar.ColumnVector;
import org.apache.paimon.data.columnar.ColumnarArray;

public final class ColumnarMap
implements InternalMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ColumnVector keyColumnVector;
    private final ColumnVector valueColumnVector;
    private final int offset;
    private final int numElements;

    public ColumnarMap(ColumnVector keyColumnVector, ColumnVector valueColumnVector, int offset, int numElements) {
        this.keyColumnVector = keyColumnVector;
        this.valueColumnVector = valueColumnVector;
        this.offset = offset;
        this.numElements = numElements;
    }

    @Override
    public int size() {
        return this.numElements;
    }

    @Override
    public InternalArray keyArray() {
        return new ColumnarArray(this.keyColumnVector, this.offset, this.numElements);
    }

    @Override
    public InternalArray valueArray() {
        return new ColumnarArray(this.valueColumnVector, this.offset, this.numElements);
    }

    public boolean equals(Object o) {
        throw new UnsupportedOperationException("ColumnarMapData do not support equals, please compare fields one by one!");
    }

    public int hashCode() {
        throw new UnsupportedOperationException("ColumnarMapData do not support hashCode, please hash fields one by one!");
    }

    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(super.hashCode());
    }
}

