/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.security;

import java.io.File;
import org.apache.paimon.options.ConfigOption;
import org.apache.paimon.options.ConfigOptions;
import org.apache.paimon.options.Options;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.StringUtils;

public class SecurityConfiguration {
    public static final ConfigOption<String> KERBEROS_LOGIN_KEYTAB = ConfigOptions.key((String)"security.kerberos.login.keytab").stringType().noDefaultValue().withFallbackKeys(new String[]{"security.keytab"}).withDescription("Absolute path to a Kerberos keytab file that contains the user credentials.");
    public static final ConfigOption<String> KERBEROS_LOGIN_PRINCIPAL = ConfigOptions.key((String)"security.kerberos.login.principal").stringType().noDefaultValue().withFallbackKeys(new String[]{"security.principal"}).withDescription("Kerberos principal name associated with the keytab.");
    public static final ConfigOption<Boolean> KERBEROS_LOGIN_USETICKETCACHE = ConfigOptions.key((String)"security.kerberos.login.use-ticket-cache").booleanType().defaultValue((Object)true).withDescription("Indicates whether to read from your Kerberos ticket cache.");
    private final Options options;
    private final boolean useTicketCache;
    private final String keytab;
    private final String principal;

    public SecurityConfiguration(Options options) {
        this.options = (Options)Preconditions.checkNotNull((Object)options);
        this.keytab = (String)options.get(KERBEROS_LOGIN_KEYTAB);
        this.principal = (String)options.get(KERBEROS_LOGIN_PRINCIPAL);
        this.useTicketCache = (Boolean)options.get(KERBEROS_LOGIN_USETICKETCACHE);
    }

    public String getKeytab() {
        return this.keytab;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public boolean useTicketCache() {
        return this.useTicketCache;
    }

    public Options getOptions() {
        return this.options;
    }

    public boolean isLegal() {
        if (StringUtils.isNullOrWhitespaceOnly((String)this.keytab) != StringUtils.isNullOrWhitespaceOnly((String)this.principal)) {
            return false;
        }
        if (!StringUtils.isNullOrWhitespaceOnly((String)this.keytab)) {
            File keytabFile = new File(this.keytab);
            return keytabFile.exists() && keytabFile.isFile() && keytabFile.canRead();
        }
        return true;
    }
}

