/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;

public class BlockingExecutor {
    private final Semaphore semaphore;
    private final ExecutorService executor;

    public BlockingExecutor(ExecutorService executor, int permits) {
        this.semaphore = new Semaphore(permits, true);
        this.executor = executor;
    }

    public void submit(Runnable task) {
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        this.executor.submit(() -> {
            try {
                task.run();
            }
            finally {
                this.semaphore.release();
            }
        });
    }
}

