/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.jar.jni;

import io.questdb.jar.jni.Platform;

public class PlatformConventions {
    public static final String LIB_PREFIX;
    public static final String LIB_SUFFIX;
    public static final String EXE_SUFFIX;

    private static boolean isWindows() {
        switch (Platform.getOSType()) {
            case 2: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    static {
        EXE_SUFFIX = PlatformConventions.isWindows() ? ".exe" : "";
        switch (Platform.getOSType()) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                LIB_PREFIX = "lib";
                LIB_SUFFIX = ".so";
                break;
            }
            case 0: {
                LIB_PREFIX = "lib";
                LIB_SUFFIX = ".dylib";
                break;
            }
            case 2: 
            case 6: {
                LIB_PREFIX = "";
                LIB_SUFFIX = ".dll";
                break;
            }
            case 7: {
                LIB_PREFIX = "lib";
                LIB_SUFFIX = ".a";
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported platform: " + Platform.getOSType());
            }
        }
    }
}

