/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.gravitino.EntityStore;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.StringIdentifier;
import org.apache.gravitino.catalog.CatalogManager;
import org.apache.gravitino.catalog.EntityCombinedModel;
import org.apache.gravitino.catalog.EntityCombinedModelVersion;
import org.apache.gravitino.catalog.ModelDispatcher;
import org.apache.gravitino.catalog.OperationDispatcher;
import org.apache.gravitino.catalog.PropertiesMetadataHelpers;
import org.apache.gravitino.connector.HasPropertyMetadata;
import org.apache.gravitino.connector.PropertiesMetadata;
import org.apache.gravitino.exceptions.ModelAlreadyExistsException;
import org.apache.gravitino.exceptions.ModelVersionAliasesAlreadyExistException;
import org.apache.gravitino.exceptions.NoSuchModelException;
import org.apache.gravitino.exceptions.NoSuchModelVersionException;
import org.apache.gravitino.exceptions.NoSuchModelVersionURINameException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.lock.LockType;
import org.apache.gravitino.lock.TreeLockUtils;
import org.apache.gravitino.model.Model;
import org.apache.gravitino.model.ModelCatalog;
import org.apache.gravitino.model.ModelChange;
import org.apache.gravitino.model.ModelVersion;
import org.apache.gravitino.model.ModelVersionChange;
import org.apache.gravitino.storage.IdGenerator;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.ThrowableFunction;

public class ModelOperationDispatcher
extends OperationDispatcher
implements ModelDispatcher {
    public ModelOperationDispatcher(CatalogManager catalogManager, EntityStore store, IdGenerator idGenerator) {
        super(catalogManager, store, idGenerator);
    }

    public NameIdentifier[] listModels(Namespace namespace) throws NoSuchSchemaException {
        return TreeLockUtils.doWithTreeLock(NameIdentifier.of((String[])namespace.levels()), LockType.READ, () -> this.doWithCatalog(NameIdentifierUtil.getCatalogIdentifier(NameIdentifier.of((String[])namespace.levels())), c -> c.doWithModelOps(m -> m.listModels(namespace)), NoSuchSchemaException.class));
    }

    public Model getModel(NameIdentifier ident) throws NoSuchModelException {
        NameIdentifier catalogIdent = NameIdentifierUtil.getCatalogIdentifier(ident);
        Model model = TreeLockUtils.doWithTreeLock(ident, LockType.READ, () -> this.doWithCatalog(catalogIdent, c -> c.doWithModelOps(m -> m.getModel(ident)), NoSuchModelException.class));
        return EntityCombinedModel.of(model).withHiddenProperties(this.getHiddenPropertyNames(catalogIdent, HasPropertyMetadata::modelPropertiesMetadata, model.properties()));
    }

    public Model registerModel(NameIdentifier ident, String comment, Map<String, String> properties) throws NoSuchModelException, ModelAlreadyExistsException {
        NameIdentifier catalogIdent = NameIdentifierUtil.getCatalogIdentifier(ident);
        Map<String, String> updatedProperties = this.checkAndUpdateProperties(catalogIdent, properties, HasPropertyMetadata::modelPropertiesMetadata);
        Model registeredModel = TreeLockUtils.doWithTreeLock(NameIdentifier.of((String[])ident.namespace().levels()), LockType.WRITE, () -> this.doWithCatalog(catalogIdent, c -> c.doWithModelOps(m -> m.registerModel(ident, comment, updatedProperties)), NoSuchSchemaException.class, ModelAlreadyExistsException.class));
        return EntityCombinedModel.of(registeredModel).withHiddenProperties(this.getHiddenPropertyNames(catalogIdent, HasPropertyMetadata::modelPropertiesMetadata, registeredModel.properties()));
    }

    public boolean deleteModel(NameIdentifier ident) {
        return TreeLockUtils.doWithTreeLock(NameIdentifier.of((String[])ident.namespace().levels()), LockType.WRITE, () -> this.doWithCatalog(NameIdentifierUtil.getCatalogIdentifier(ident), c -> c.doWithModelOps(m -> m.deleteModel(ident)), RuntimeException.class));
    }

    public int[] listModelVersions(NameIdentifier ident) throws NoSuchModelException {
        return TreeLockUtils.doWithTreeLock(ident, LockType.READ, () -> this.doWithCatalog(NameIdentifierUtil.getCatalogIdentifier(ident), c -> c.doWithModelOps(m -> m.listModelVersions(ident)), NoSuchModelException.class));
    }

    public ModelVersion[] listModelVersionInfos(NameIdentifier ident) throws NoSuchModelException {
        return this.internalListModelVersion(ident, () -> TreeLockUtils.doWithTreeLock(ident, LockType.READ, () -> this.doWithCatalog(NameIdentifierUtil.getCatalogIdentifier(ident), c -> c.doWithModelOps(m -> m.listModelVersionInfos(ident)), NoSuchModelException.class)));
    }

    public ModelVersion getModelVersion(NameIdentifier ident, int version) throws NoSuchModelVersionException {
        return this.internalGetModelVersion(ident, () -> TreeLockUtils.doWithTreeLock(ident, LockType.READ, () -> this.doWithCatalog(NameIdentifierUtil.getCatalogIdentifier(ident), c -> c.doWithModelOps(m -> m.getModelVersion(ident, version)), NoSuchModelVersionException.class)));
    }

    public ModelVersion getModelVersion(NameIdentifier ident, String alias) throws NoSuchModelVersionException {
        return this.internalGetModelVersion(ident, () -> TreeLockUtils.doWithTreeLock(ident, LockType.READ, () -> this.doWithCatalog(NameIdentifierUtil.getCatalogIdentifier(ident), c -> c.doWithModelOps(m -> m.getModelVersion(ident, alias)), NoSuchModelVersionException.class)));
    }

    public void linkModelVersion(NameIdentifier ident, Map<String, String> uris, String[] aliases, String comment, Map<String, String> properties) throws NoSuchModelException, ModelVersionAliasesAlreadyExistException {
        NameIdentifier catalogIdent = NameIdentifierUtil.getCatalogIdentifier(ident);
        Map<String, String> updatedProperties = this.checkAndUpdateProperties(catalogIdent, properties, HasPropertyMetadata::modelVersionPropertiesMetadata);
        TreeLockUtils.doWithTreeLock(ident, LockType.WRITE, () -> this.doWithCatalog(catalogIdent, c -> c.doWithModelOps(m -> {
            m.linkModelVersion(ident, uris, aliases, comment, updatedProperties);
            return null;
        }), NoSuchModelException.class, ModelVersionAliasesAlreadyExistException.class));
    }

    public String getModelVersionUri(NameIdentifier ident, int version, String uriName) throws NoSuchModelVersionException, NoSuchModelVersionURINameException {
        return TreeLockUtils.doWithTreeLock(ident, LockType.READ, () -> this.doWithCatalog(NameIdentifierUtil.getCatalogIdentifier(ident), c -> c.doWithModelOps(m -> m.getModelVersionUri(ident, version, uriName)), NoSuchModelVersionException.class, NoSuchModelVersionURINameException.class));
    }

    public String getModelVersionUri(NameIdentifier ident, String alias, String uriName) throws NoSuchModelVersionException, NoSuchModelVersionURINameException {
        return TreeLockUtils.doWithTreeLock(ident, LockType.READ, () -> this.doWithCatalog(NameIdentifierUtil.getCatalogIdentifier(ident), c -> c.doWithModelOps(m -> m.getModelVersionUri(ident, alias, uriName)), NoSuchModelVersionException.class, NoSuchModelVersionURINameException.class));
    }

    public boolean deleteModelVersion(NameIdentifier ident, int version) {
        return TreeLockUtils.doWithTreeLock(ident, LockType.WRITE, () -> this.doWithCatalog(NameIdentifierUtil.getCatalogIdentifier(ident), c -> c.doWithModelOps(m -> m.deleteModelVersion(ident, version)), RuntimeException.class));
    }

    public boolean deleteModelVersion(NameIdentifier ident, String alias) {
        return TreeLockUtils.doWithTreeLock(ident, LockType.WRITE, () -> this.doWithCatalog(NameIdentifierUtil.getCatalogIdentifier(ident), c -> c.doWithModelOps(m -> m.deleteModelVersion(ident, alias)), RuntimeException.class));
    }

    public Model alterModel(NameIdentifier ident, ModelChange ... changes) throws NoSuchModelException, IllegalArgumentException {
        this.validateAlterProperties(ident, HasPropertyMetadata::modelPropertiesMetadata, changes);
        NameIdentifier catalogIdent = NameIdentifierUtil.getCatalogIdentifier(ident);
        Model alteredModel = TreeLockUtils.doWithTreeLock(ident, LockType.WRITE, () -> this.doWithCatalog(catalogIdent, c -> c.doWithModelOps(f -> f.alterModel(ident, changes)), NoSuchModelException.class, IllegalArgumentException.class));
        return EntityCombinedModel.of(alteredModel).withHiddenProperties(this.getHiddenPropertyNames(catalogIdent, HasPropertyMetadata::modelPropertiesMetadata, alteredModel.properties()));
    }

    public ModelVersion alterModelVersion(NameIdentifier ident, int version, ModelVersionChange ... changes) throws NoSuchModelVersionException, IllegalArgumentException {
        this.validateAlterProperties(ident, HasPropertyMetadata::modelVersionPropertiesMetadata, changes);
        return this.executeAlterModelVersion(ident, f -> f.alterModelVersion(ident, version, changes));
    }

    public ModelVersion alterModelVersion(NameIdentifier ident, String alias, ModelVersionChange ... changes) throws NoSuchModelException, IllegalArgumentException {
        this.validateAlterProperties(ident, HasPropertyMetadata::modelVersionPropertiesMetadata, changes);
        return this.executeAlterModelVersion(ident, f -> f.alterModelVersion(ident, alias, changes));
    }

    private ModelVersion executeAlterModelVersion(NameIdentifier ident, ThrowableFunction<ModelCatalog, ModelVersion> fn) {
        NameIdentifier catalogIdent = NameIdentifierUtil.getCatalogIdentifier(ident);
        ModelVersion alteredModelVersion = TreeLockUtils.doWithTreeLock(ident, LockType.WRITE, () -> this.doWithCatalog(catalogIdent, c -> (ModelVersion)c.doWithModelOps(fn), NoSuchModelVersionException.class, IllegalArgumentException.class));
        return EntityCombinedModelVersion.of(alteredModelVersion).withHiddenProperties(this.getHiddenPropertyNames(catalogIdent, HasPropertyMetadata::modelVersionPropertiesMetadata, alteredModelVersion.properties()));
    }

    private ModelVersion internalGetModelVersion(NameIdentifier ident, Supplier<ModelVersion> supplier) {
        NameIdentifier catalogIdent = NameIdentifierUtil.getCatalogIdentifier(ident);
        ModelVersion modelVersion = supplier.get();
        return EntityCombinedModelVersion.of(modelVersion).withHiddenProperties(this.getHiddenPropertyNames(catalogIdent, HasPropertyMetadata::modelVersionPropertiesMetadata, modelVersion.properties()));
    }

    private ModelVersion[] internalListModelVersion(NameIdentifier ident, Supplier<ModelVersion[]> supplier) {
        NameIdentifier catalogIdent = NameIdentifierUtil.getCatalogIdentifier(ident);
        return (ModelVersion[])Arrays.stream(supplier.get()).map(v -> EntityCombinedModelVersion.of(v).withHiddenProperties(this.getHiddenPropertyNames(catalogIdent, HasPropertyMetadata::modelVersionPropertiesMetadata, v.properties()))).toArray(ModelVersion[]::new);
    }

    private Map<String, String> checkAndUpdateProperties(NameIdentifier catalogIdent, Map<String, String> properties, Function<HasPropertyMetadata, PropertiesMetadata> propertiesMetadataProvider) {
        TreeLockUtils.doWithTreeLock(catalogIdent, LockType.READ, () -> this.doWithCatalog(catalogIdent, c -> c.doWithPropertiesMeta(p -> {
            PropertiesMetadataHelpers.validatePropertyForCreate((PropertiesMetadata)propertiesMetadataProvider.apply((HasPropertyMetadata)p), properties);
            return null;
        }), IllegalArgumentException.class));
        long uid = this.idGenerator.nextId();
        StringIdentifier stringId = StringIdentifier.fromId(uid);
        return StringIdentifier.newPropertiesWithId(stringId, properties);
    }
}

