/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.web.rest;

import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.gravitino.Entity;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.MetadataObjects;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.authorization.AccessControlDispatcher;
import org.apache.gravitino.authorization.Group;
import org.apache.gravitino.authorization.Owner;
import org.apache.gravitino.authorization.OwnerDispatcher;
import org.apache.gravitino.dto.requests.GroupAddRequest;
import org.apache.gravitino.dto.responses.GroupListResponse;
import org.apache.gravitino.dto.responses.GroupResponse;
import org.apache.gravitino.dto.responses.NameListResponse;
import org.apache.gravitino.dto.responses.RemoveResponse;
import org.apache.gravitino.dto.util.DTOConverters;
import org.apache.gravitino.server.authorization.NameBindings;
import org.apache.gravitino.server.authorization.annotations.AuthorizationExpression;
import org.apache.gravitino.server.authorization.annotations.AuthorizationMetadata;
import org.apache.gravitino.server.web.Utils;
import org.apache.gravitino.server.web.rest.ExceptionHandlers;
import org.apache.gravitino.server.web.rest.OperationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NameBindings.AccessControlInterfaces
@Path(value="/metalakes/{metalake}/groups")
public class GroupOperations {
    private static final Logger LOG = LoggerFactory.getLogger(GroupOperations.class);
    private final AccessControlDispatcher accessControlManager = GravitinoEnv.getInstance().accessControlDispatcher();
    private final OwnerDispatcher ownerDispatcher = GravitinoEnv.getInstance().ownerDispatcher();
    @Context
    private HttpServletRequest httpRequest;

    @GET
    @Path(value="{group}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="get-group.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="get-group", absolute=true)
    public Response getGroup(@PathParam(value="metalake") String metalake, @PathParam(value="group") String group) {
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> Utils.ok((Object)new GroupResponse(DTOConverters.toDTO((Group)this.accessControlManager.getGroup(metalake, group)))));
        }
        catch (Exception e) {
            return ExceptionHandlers.handleGroupException(OperationType.GET, group, metalake, e);
        }
    }

    @POST
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="add-group.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="add-group", absolute=true)
    @AuthorizationExpression(expression="METALAKE::OWNER || METALAKE::MANAGE_GROUPS")
    public Response addGroup(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, GroupAddRequest request) {
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                request.validate();
                return Utils.ok((Object)new GroupResponse(DTOConverters.toDTO((Group)this.accessControlManager.addGroup(metalake, request.getName()))));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleGroupException(OperationType.ADD, request.getName(), metalake, e);
        }
    }

    @DELETE
    @Path(value="{group}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="remove-group.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="remove-group", absolute=true)
    @AuthorizationExpression(expression="METALAKE::OWNER || METALAKE::MANAGE_GROUPS")
    public Response removeGroup(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="group") String group) {
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                this.ownerDispatcher.getOwner(metalake, MetadataObjects.of(null, (String)metalake, (MetadataObject.Type)MetadataObject.Type.METALAKE)).ifPresent(owner -> {
                    if (owner.type() == Owner.Type.GROUP && owner.name().equals(group)) {
                        throw new IllegalArgumentException(String.format("Cannot remove group %s from metalake %s because the group is the owner of the metalake.", group, metalake));
                    }
                });
                boolean removed = this.accessControlManager.removeGroup(metalake, group);
                if (!removed) {
                    LOG.warn("Failed to remove group {} under metalake {}", (Object)group, (Object)metalake);
                }
                return Utils.ok((Object)new RemoveResponse(removed));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleGroupException(OperationType.REMOVE, group, metalake, e);
        }
    }

    @GET
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="list-group.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="list-group", absolute=true)
    public Response listGroups(@PathParam(value="metalake") String metalake, @QueryParam(value="details") @DefaultValue(value="false") boolean verbose) {
        LOG.info("Received list groups request.");
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                if (verbose) {
                    return Utils.ok((Object)new GroupListResponse(DTOConverters.toDTOs((Group[])this.accessControlManager.listGroups(metalake))));
                }
                return Utils.ok((Object)new NameListResponse(this.accessControlManager.listGroupNames(metalake)));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleGroupException(OperationType.LIST, Namespace.empty().toString(), metalake, e);
        }
    }
}

