/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.index;

import java.util.Collection;
import java.util.LinkedHashMap;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericArray;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.index.DeletionVectorMeta;
import org.apache.paimon.index.IndexFileMeta;
import org.apache.paimon.utils.ObjectSerializer;

public class IndexFileMetaSerializer
extends ObjectSerializer<IndexFileMeta> {
    public IndexFileMetaSerializer() {
        super(IndexFileMeta.SCHEMA);
    }

    @Override
    public InternalRow toRow(IndexFileMeta record) {
        return GenericRow.of((Object[])new Object[]{BinaryString.fromString((String)record.indexType()), BinaryString.fromString((String)record.fileName()), record.fileSize(), record.rowCount(), record.deletionVectorMetas() == null ? null : IndexFileMetaSerializer.dvMetasToRowArrayData(record.deletionVectorMetas().values())});
    }

    @Override
    public IndexFileMeta fromRow(InternalRow row) {
        return new IndexFileMeta(row.getString(0).toString(), row.getString(1).toString(), row.getLong(2), row.getLong(3), row.isNullAt(4) ? null : IndexFileMetaSerializer.rowArrayDataToDvMetas(row.getArray(4)));
    }

    public static InternalArray dvMetasToRowArrayData(Collection<DeletionVectorMeta> dvMetas) {
        return new GenericArray((Object[])dvMetas.stream().map(dvMeta -> GenericRow.of((Object[])new Object[]{BinaryString.fromString((String)dvMeta.dataFileName()), dvMeta.offset(), dvMeta.length(), dvMeta.cardinality()})).toArray(GenericRow[]::new));
    }

    public static LinkedHashMap<String, DeletionVectorMeta> rowArrayDataToDvMetas(InternalArray arrayData) {
        LinkedHashMap<String, DeletionVectorMeta> dvMetas = new LinkedHashMap<String, DeletionVectorMeta>(arrayData.size());
        for (int i = 0; i < arrayData.size(); ++i) {
            InternalRow row = arrayData.getRow(i, DeletionVectorMeta.SCHEMA.getFieldCount());
            dvMetas.put(row.getString(0).toString(), new DeletionVectorMeta(row.getString(0).toString(), row.getInt(1), row.getInt(2), row.isNullAt(3) ? null : Long.valueOf(row.getLong(3))));
        }
        return dvMetas;
    }
}

