/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation.metrics;

import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.metrics.Histogram;
import org.apache.paimon.metrics.MetricGroup;
import org.apache.paimon.metrics.MetricRegistry;
import org.apache.paimon.operation.metrics.CommitStats;

public class CommitMetrics {
    private static final int HISTOGRAM_WINDOW_SIZE = 100;
    private static final String GROUP_NAME = "commit";
    private final MetricGroup metricGroup;
    private Histogram durationHistogram;
    private CommitStats latestCommit;
    @VisibleForTesting
    static final String LAST_COMMIT_DURATION = "lastCommitDuration";
    @VisibleForTesting
    static final String COMMIT_DURATION = "commitDuration";
    @VisibleForTesting
    static final String LAST_COMMIT_ATTEMPTS = "lastCommitAttempts";
    @VisibleForTesting
    static final String LAST_TABLE_FILES_ADDED = "lastTableFilesAdded";
    @VisibleForTesting
    static final String LAST_TABLE_FILES_DELETED = "lastTableFilesDeleted";
    @VisibleForTesting
    static final String LAST_TABLE_FILES_APPENDED = "lastTableFilesAppended";
    @VisibleForTesting
    static final String LAST_TABLE_FILES_COMMIT_COMPACTED = "lastTableFilesCommitCompacted";
    @VisibleForTesting
    static final String LAST_CHANGELOG_FILES_APPENDED = "lastChangelogFilesAppended";
    @VisibleForTesting
    static final String LAST_CHANGELOG_FILES_COMMIT_COMPACTED = "lastChangelogFileCommitCompacted";
    @VisibleForTesting
    static final String LAST_GENERATED_SNAPSHOTS = "lastGeneratedSnapshots";
    @VisibleForTesting
    static final String LAST_DELTA_RECORDS_APPENDED = "lastDeltaRecordsAppended";
    @VisibleForTesting
    static final String LAST_CHANGELOG_RECORDS_APPENDED = "lastChangelogRecordsAppended";
    @VisibleForTesting
    static final String LAST_DELTA_RECORDS_COMMIT_COMPACTED = "lastDeltaRecordsCommitCompacted";
    @VisibleForTesting
    static final String LAST_CHANGELOG_RECORDS_COMMIT_COMPACTED = "lastChangelogRecordsCommitCompacted";
    @VisibleForTesting
    static final String LAST_PARTITIONS_WRITTEN = "lastPartitionsWritten";
    @VisibleForTesting
    static final String LAST_BUCKETS_WRITTEN = "lastBucketsWritten";
    static final String LAST_COMPACTION_INPUT_FILE_SIZE = "lastCompactionInputFileSize";
    static final String LAST_COMPACTION_OUTPUT_FILE_SIZE = "lastCompactionOutputFileSize";

    public CommitMetrics(MetricRegistry registry, String tableName) {
        this.metricGroup = registry.createTableMetricGroup(GROUP_NAME, tableName);
        this.registerGenericCommitMetrics();
    }

    @VisibleForTesting
    public MetricGroup getMetricGroup() {
        return this.metricGroup;
    }

    private void registerGenericCommitMetrics() {
        this.metricGroup.gauge(LAST_COMMIT_DURATION, () -> this.latestCommit == null ? 0L : this.latestCommit.getDuration());
        this.metricGroup.gauge(LAST_COMMIT_ATTEMPTS, () -> this.latestCommit == null ? 0L : (long)this.latestCommit.getAttempts());
        this.metricGroup.gauge(LAST_GENERATED_SNAPSHOTS, () -> this.latestCommit == null ? 0L : this.latestCommit.getGeneratedSnapshots());
        this.metricGroup.gauge(LAST_PARTITIONS_WRITTEN, () -> this.latestCommit == null ? 0L : this.latestCommit.getNumPartitionsWritten());
        this.metricGroup.gauge(LAST_BUCKETS_WRITTEN, () -> this.latestCommit == null ? 0L : this.latestCommit.getNumBucketsWritten());
        this.durationHistogram = this.metricGroup.histogram(COMMIT_DURATION, 100);
        this.metricGroup.gauge(LAST_TABLE_FILES_ADDED, () -> this.latestCommit == null ? 0L : this.latestCommit.getTableFilesAdded());
        this.metricGroup.gauge(LAST_TABLE_FILES_DELETED, () -> this.latestCommit == null ? 0L : this.latestCommit.getTableFilesDeleted());
        this.metricGroup.gauge(LAST_TABLE_FILES_APPENDED, () -> this.latestCommit == null ? 0L : this.latestCommit.getTableFilesAppended());
        this.metricGroup.gauge(LAST_TABLE_FILES_COMMIT_COMPACTED, () -> this.latestCommit == null ? 0L : this.latestCommit.getTableFilesCompacted());
        this.metricGroup.gauge(LAST_CHANGELOG_FILES_APPENDED, () -> this.latestCommit == null ? 0L : this.latestCommit.getChangelogFilesAppended());
        this.metricGroup.gauge(LAST_CHANGELOG_FILES_COMMIT_COMPACTED, () -> this.latestCommit == null ? 0L : this.latestCommit.getChangelogFilesCompacted());
        this.metricGroup.gauge(LAST_DELTA_RECORDS_APPENDED, () -> this.latestCommit == null ? 0L : this.latestCommit.getDeltaRecordsAppended());
        this.metricGroup.gauge(LAST_CHANGELOG_RECORDS_APPENDED, () -> this.latestCommit == null ? 0L : this.latestCommit.getChangelogRecordsAppended());
        this.metricGroup.gauge(LAST_DELTA_RECORDS_COMMIT_COMPACTED, () -> this.latestCommit == null ? 0L : this.latestCommit.getDeltaRecordsCompacted());
        this.metricGroup.gauge(LAST_CHANGELOG_RECORDS_COMMIT_COMPACTED, () -> this.latestCommit == null ? 0L : this.latestCommit.getChangelogRecordsCompacted());
        this.metricGroup.gauge(LAST_COMPACTION_INPUT_FILE_SIZE, () -> this.latestCommit == null ? 0L : this.latestCommit.getCompactionInputFileSize());
        this.metricGroup.gauge(LAST_COMPACTION_OUTPUT_FILE_SIZE, () -> this.latestCommit == null ? 0L : this.latestCommit.getCompactionOutputFileSize());
    }

    public void reportCommit(CommitStats commitStats) {
        this.latestCommit = commitStats;
        this.durationHistogram.update(commitStats.getDuration());
    }
}

