/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.common.authentication;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.gravitino.Config;
import org.apache.gravitino.config.ConfigBuilder;
import org.apache.gravitino.config.ConfigEntry;
import org.apache.gravitino.connector.PropertyEntry;

public class AuthenticationConfig
extends Config {
    public static final String AUTH_TYPE_KEY = "authentication.type";
    public static final String IMPERSONATION_ENABLE_KEY = "authentication.impersonation-enable";
    public static final boolean DEFAULT_IMPERSONATION_ENABLE = false;
    public static final ConfigEntry<String> AUTH_TYPE_ENTRY = new ConfigBuilder("authentication.type").doc("The type of authentication for Iceberg catalog, currently we support simple and Kerberos").version("0.5.1").stringConf().createWithDefault((Object)"simple");
    public static final ConfigEntry<Boolean> ENABLE_IMPERSONATION_ENTRY = new ConfigBuilder("authentication.impersonation-enable").doc("Whether to enable impersonation for Iceberg catalog").version("0.5.1").booleanConf().createWithDefault((Object)false);
    public static final Map<String, PropertyEntry<?>> AUTHENTICATION_PROPERTY_ENTRIES = new ImmutableMap.Builder().put((Object)"authentication.impersonation-enable", (Object)PropertyEntry.booleanPropertyEntry((String)"authentication.impersonation-enable", (String)"Whether to enable impersonation for the Iceberg catalog", (boolean)false, (boolean)false, (Boolean)false, (boolean)false, (boolean)false)).put((Object)"authentication.type", (Object)PropertyEntry.stringOptionalPropertyEntry((String)"authentication.type", (String)"The type of authentication for Hadoop catalog, currently we only support simple and Kerberos", (boolean)false, (String)"simple", (boolean)false)).build();

    public AuthenticationConfig(Map<String, String> properties) {
        super(false);
        this.loadFromMap(properties, k -> true);
    }

    public String getAuthType() {
        return (String)this.get(AUTH_TYPE_ENTRY);
    }

    public boolean isSimpleAuth() {
        return AuthenticationType.SIMPLE.name().equalsIgnoreCase(this.getAuthType());
    }

    public boolean isKerberosAuth() {
        return AuthenticationType.KERBEROS.name().equalsIgnoreCase(this.getAuthType());
    }

    public boolean isImpersonationEnabled() {
        return (Boolean)this.get(ENABLE_IMPERSONATION_ENTRY);
    }

    static enum AuthenticationType {
        SIMPLE,
        KERBEROS;

    }
}

