/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.service;

import com.google.common.base.Preconditions;
import org.apache.gravitino.Entity;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.storage.relational.helper.CatalogIds;
import org.apache.gravitino.storage.relational.helper.SchemaIds;
import org.apache.gravitino.storage.relational.service.CatalogMetaService;
import org.apache.gravitino.storage.relational.service.MetalakeMetaService;
import org.apache.gravitino.storage.relational.service.SchemaMetaService;

public class CommonMetaService {
    private static final CommonMetaService INSTANCE = new CommonMetaService();

    public static CommonMetaService getInstance() {
        return INSTANCE;
    }

    private CommonMetaService() {
    }

    public Long getParentEntityIdByNamespace(Namespace namespace) {
        Preconditions.checkArgument((!namespace.isEmpty() && namespace.levels().length <= 3 ? 1 : 0) != 0, (Object)"Namespace should not be empty and length should be less than or equal to 3.");
        int length = namespace.levels().length;
        switch (length) {
            case 1: {
                Long parentEntityId = MetalakeMetaService.getInstance().getMetalakeIdByName(namespace.level(0));
                if (parentEntityId == null) {
                    throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.METALAKE.name().toLowerCase(), namespace});
                }
                return parentEntityId;
            }
            case 2: {
                Long parentEntityId;
                CatalogIds catalogIds = CatalogMetaService.getInstance().getCatalogIdByMetalakeAndCatalogName(namespace.level(0), namespace.level(1));
                Long l = parentEntityId = catalogIds == null ? null : catalogIds.getCatalogId();
                if (parentEntityId == null) {
                    throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.CATALOG.name().toLowerCase(), namespace});
                }
                return parentEntityId;
            }
            case 3: {
                Long parentEntityId;
                SchemaIds schemaIds = SchemaMetaService.getInstance().getSchemaIdByMetalakeNameAndCatalogNameAndSchemaName(namespace.level(0), namespace.level(1), namespace.level(2));
                Long l = parentEntityId = schemaIds == null ? null : schemaIds.getSchemaId();
                if (parentEntityId == null) {
                    throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.SCHEMA.name().toLowerCase(), namespace});
                }
                return parentEntityId;
            }
        }
        throw new IllegalArgumentException("Namespace length should be less than or equal to 3.");
    }

    public Long[] getParentEntityIdsByNamespace(Namespace namespace) {
        Preconditions.checkArgument((!namespace.isEmpty() && namespace.levels().length <= 3 ? 1 : 0) != 0, (Object)"Namespace should not be empty and length should be less than or equal to 3.");
        Long[] parentEntityIds = new Long[namespace.levels().length];
        int length = namespace.levels().length;
        switch (length) {
            case 1: {
                parentEntityIds[0] = MetalakeMetaService.getInstance().getMetalakeIdByName(namespace.level(0));
                if (parentEntityIds[0] == null) {
                    throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.METALAKE.name().toLowerCase(), namespace});
                }
                return parentEntityIds;
            }
            case 2: {
                CatalogIds catalogIds = CatalogMetaService.getInstance().getCatalogIdByMetalakeAndCatalogName(namespace.level(0), namespace.level(1));
                parentEntityIds[0] = catalogIds == null ? null : catalogIds.getMetalakeId();
                Long l = parentEntityIds[1] = catalogIds == null ? null : catalogIds.getCatalogId();
                if (parentEntityIds[1] == null) {
                    throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.CATALOG.name().toLowerCase(), namespace});
                }
                return parentEntityIds;
            }
            case 3: {
                SchemaIds schemaIds = SchemaMetaService.getInstance().getSchemaIdByMetalakeNameAndCatalogNameAndSchemaName(namespace.level(0), namespace.level(1), namespace.level(2));
                parentEntityIds[0] = schemaIds == null ? null : schemaIds.getMetalakeId();
                parentEntityIds[1] = schemaIds == null ? null : schemaIds.getCatalogId();
                Long l = parentEntityIds[2] = schemaIds == null ? null : schemaIds.getSchemaId();
                if (parentEntityIds[2] == null) {
                    throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.SCHEMA.name().toLowerCase(), namespace});
                }
                return parentEntityIds;
            }
        }
        throw new IllegalArgumentException("Namespace length should be less than or equal to 3.");
    }
}

