/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.gravitino.storage.relational.JDBCBackend;
import org.apache.gravitino.storage.relational.mapper.provider.base.PolicyMetaBaseSQLProvider;
import org.apache.gravitino.storage.relational.mapper.provider.postgresql.PolicyMetaPostgreSQLProvider;
import org.apache.gravitino.storage.relational.po.PolicyPO;
import org.apache.gravitino.storage.relational.session.SqlSessionFactoryHelper;
import org.apache.ibatis.annotations.Param;

public class PolicyMetaSQLProviderFactory {
    private static final Map<JDBCBackend.JDBCBackendType, PolicyMetaBaseSQLProvider> POLICY_META_SQL_PROVIDER_MAP = ImmutableMap.of((Object)((Object)JDBCBackend.JDBCBackendType.MYSQL), (Object)new PolicyMetaMySQLProvider(), (Object)((Object)JDBCBackend.JDBCBackendType.H2), (Object)new PolicyMetaH2Provider(), (Object)((Object)JDBCBackend.JDBCBackendType.POSTGRESQL), (Object)new PolicyMetaPostgreSQLProvider());

    public static PolicyMetaBaseSQLProvider getProvider() {
        String databaseId = SqlSessionFactoryHelper.getInstance().getSqlSessionFactory().getConfiguration().getDatabaseId();
        JDBCBackend.JDBCBackendType jdbcBackendType = JDBCBackend.JDBCBackendType.fromString(databaseId);
        return POLICY_META_SQL_PROVIDER_MAP.get((Object)jdbcBackendType);
    }

    public static String listPolicyPOsByMetalake(@Param(value="metalakeName") String metalakeName) {
        return PolicyMetaSQLProviderFactory.getProvider().listPolicyPOsByMetalake(metalakeName);
    }

    public static String listPolicyPOsByMetalakeAndPolicyNames(@Param(value="metalakeName") String metalakeName, @Param(value="policyNames") List<String> policyNames) {
        return PolicyMetaSQLProviderFactory.getProvider().listPolicyPOsByMetalakeAndPolicyNames(metalakeName, policyNames);
    }

    public static String insertPolicyMetaOnDuplicateKeyUpdate(@Param(value="policyMeta") PolicyPO policyPO) {
        return PolicyMetaSQLProviderFactory.getProvider().insertPolicyMetaOnDuplicateKeyUpdate(policyPO);
    }

    public static String insertPolicyMeta(@Param(value="policyMeta") PolicyPO policyPO) {
        return PolicyMetaSQLProviderFactory.getProvider().insertPolicyMeta(policyPO);
    }

    public static String selectPolicyMetaByMetalakeAndName(@Param(value="metalakeName") String metalakeName, @Param(value="policyName") String policyName) {
        return PolicyMetaSQLProviderFactory.getProvider().selectPolicyMetaByMetalakeAndName(metalakeName, policyName);
    }

    public static String updatePolicyMeta(@Param(value="newPolicyMeta") PolicyPO newPolicyMeta, @Param(value="oldPolicyMeta") PolicyPO oldPolicyMeta) {
        return PolicyMetaSQLProviderFactory.getProvider().updatePolicyMeta(newPolicyMeta, oldPolicyMeta);
    }

    public static String softDeletePolicyByMetalakeAndPolicyName(@Param(value="metalakeName") String metalakeName, @Param(value="policyName") String policyName) {
        return PolicyMetaSQLProviderFactory.getProvider().softDeletePolicyByMetalakeAndPolicyName(metalakeName, policyName);
    }

    public static String deletePolicyMetasByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return PolicyMetaSQLProviderFactory.getProvider().deletePolicyMetasByLegacyTimeline(legacyTimeline, limit);
    }

    public static String softDeletePolicyMetasByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return PolicyMetaSQLProviderFactory.getProvider().softDeletePolicyMetasByMetalakeId(metalakeId);
    }

    public static String selectPolicyMetaByMetalakeIdAndName(@Param(value="metalakeId") Long metalakeId, @Param(value="policyName") String policyName) {
        return PolicyMetaSQLProviderFactory.getProvider().selectPolicyMetaByMetalakeIdAndName(metalakeId, policyName);
    }

    public static String selectPolicyByPolicyId(@Param(value="policyId") Long policyId) {
        return PolicyMetaSQLProviderFactory.getProvider().selectPolicyByPolicyId(policyId);
    }

    static class PolicyMetaMySQLProvider
    extends PolicyMetaBaseSQLProvider {
        PolicyMetaMySQLProvider() {
        }
    }

    static class PolicyMetaH2Provider
    extends PolicyMetaBaseSQLProvider {
        PolicyMetaH2Provider() {
        }
    }
}

