/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.gravitino.storage.relational.JDBCBackend;
import org.apache.gravitino.storage.relational.mapper.provider.base.TagMetaBaseSQLProvider;
import org.apache.gravitino.storage.relational.mapper.provider.postgresql.TagMetaPostgreSQLProvider;
import org.apache.gravitino.storage.relational.po.TagPO;
import org.apache.gravitino.storage.relational.session.SqlSessionFactoryHelper;
import org.apache.ibatis.annotations.Param;

public class TagMetaSQLProviderFactory {
    private static final Map<JDBCBackend.JDBCBackendType, TagMetaBaseSQLProvider> TAG_META_SQL_PROVIDER_MAP = ImmutableMap.of((Object)((Object)JDBCBackend.JDBCBackendType.MYSQL), (Object)new TagMetaMySQLProvider(), (Object)((Object)JDBCBackend.JDBCBackendType.H2), (Object)new TagMetaH2Provider(), (Object)((Object)JDBCBackend.JDBCBackendType.POSTGRESQL), (Object)new TagMetaPostgreSQLProvider());

    public static TagMetaBaseSQLProvider getProvider() {
        String databaseId = SqlSessionFactoryHelper.getInstance().getSqlSessionFactory().getConfiguration().getDatabaseId();
        JDBCBackend.JDBCBackendType jdbcBackendType = JDBCBackend.JDBCBackendType.fromString(databaseId);
        return TAG_META_SQL_PROVIDER_MAP.get((Object)jdbcBackendType);
    }

    public static String listTagPOsByMetalake(@Param(value="metalakeName") String metalakeName) {
        return TagMetaSQLProviderFactory.getProvider().listTagPOsByMetalake(metalakeName);
    }

    public static String listTagPOsByMetalakeAndTagNames(@Param(value="metalakeName") String metalakeName, @Param(value="tagNames") List<String> tagNames) {
        return TagMetaSQLProviderFactory.getProvider().listTagPOsByMetalakeAndTagNames(metalakeName, tagNames);
    }

    public static String selectTagIdByMetalakeAndName(@Param(value="metalakeName") String metalakeName, @Param(value="tagName") String tagName) {
        return TagMetaSQLProviderFactory.getProvider().selectTagIdByMetalakeAndName(metalakeName, tagName);
    }

    public static String selectTagMetaByMetalakeAndName(@Param(value="metalakeName") String metalakeName, @Param(value="tagName") String tagName) {
        return TagMetaSQLProviderFactory.getProvider().selectTagMetaByMetalakeAndName(metalakeName, tagName);
    }

    public static String insertTagMeta(@Param(value="tagMeta") TagPO tagPO) {
        return TagMetaSQLProviderFactory.getProvider().insertTagMeta(tagPO);
    }

    public static String insertTagMetaOnDuplicateKeyUpdate(@Param(value="tagMeta") TagPO tagPO) {
        return TagMetaSQLProviderFactory.getProvider().insertTagMetaOnDuplicateKeyUpdate(tagPO);
    }

    public static String updateTagMeta(@Param(value="newTagMeta") TagPO newTagPO, @Param(value="oldTagMeta") TagPO oldTagPO) {
        return TagMetaSQLProviderFactory.getProvider().updateTagMeta(newTagPO, oldTagPO);
    }

    public static String softDeleteTagMetaByMetalakeAndTagName(@Param(value="metalakeName") String metalakeName, @Param(value="tagName") String tagName) {
        return TagMetaSQLProviderFactory.getProvider().softDeleteTagMetaByMetalakeAndTagName(metalakeName, tagName);
    }

    public static String softDeleteTagMetasByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return TagMetaSQLProviderFactory.getProvider().softDeleteTagMetasByMetalakeId(metalakeId);
    }

    public static String deleteTagMetasByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return TagMetaSQLProviderFactory.getProvider().deleteTagMetasByLegacyTimeline(legacyTimeline, limit);
    }

    public static String selectTagMetaByMetalakeIdAndName(@Param(value="metalakeId") Long metalakeId, @Param(value="name") String name) {
        return TagMetaSQLProviderFactory.getProvider().selectTagMetaByMetalakeIdAndName(metalakeId, name);
    }

    public static String selectTagByTagId(@Param(value="tagId") Long tagId) {
        return TagMetaSQLProviderFactory.getProvider().selectTagByTagId(tagId);
    }

    static class TagMetaMySQLProvider
    extends TagMetaBaseSQLProvider {
        TagMetaMySQLProvider() {
        }
    }

    static class TagMetaH2Provider
    extends TagMetaBaseSQLProvider {
        TagMetaH2Provider() {
        }
    }
}

