/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.service;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.gravitino.Entity;
import org.apache.gravitino.EntityAlreadyExistsException;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.meta.GenericEntity;
import org.apache.gravitino.meta.PolicyEntity;
import org.apache.gravitino.metrics.MethodMonitorAspect;
import org.apache.gravitino.metrics.Monitored;
import org.apache.gravitino.metrics.source.MetricsSource;
import org.apache.gravitino.storage.relational.mapper.PolicyMetaMapper;
import org.apache.gravitino.storage.relational.mapper.PolicyMetadataObjectRelMapper;
import org.apache.gravitino.storage.relational.mapper.PolicyVersionMapper;
import org.apache.gravitino.storage.relational.po.PolicyMaxVersionPO;
import org.apache.gravitino.storage.relational.po.PolicyPO;
import org.apache.gravitino.storage.relational.service.EntityIdService;
import org.apache.gravitino.storage.relational.utils.ExceptionUtils;
import org.apache.gravitino.storage.relational.utils.POConverters;
import org.apache.gravitino.storage.relational.utils.SessionUtils;
import org.apache.gravitino.utils.MetadataObjectUtil;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.NamespaceUtil;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyMetaService {
    private static final PolicyMetaService INSTANCE;
    private static final Logger LOG;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ Annotation ajc$anno$2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ Annotation ajc$anno$3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ Annotation ajc$anno$4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ Annotation ajc$anno$5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ Annotation ajc$anno$6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ Annotation ajc$anno$7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ Annotation ajc$anno$8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ Annotation ajc$anno$9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ Annotation ajc$anno$10;

    public static PolicyMetaService getInstance() {
        return INSTANCE;
    }

    private PolicyMetaService() {
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="listPoliciesByNamespace")
    public List<PolicyEntity> listPoliciesByNamespace(Namespace namespace) {
        Namespace namespace2 = namespace;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)namespace2);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = PolicyMetaService.class.getDeclaredMethod("listPoliciesByNamespace", Namespace.class).getAnnotation(Monitored.class);
        }
        return (List)PolicyMetaService.listPoliciesByNamespace_aroundBody1$advice(this, namespace2, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="getPolicyByIdentifier")
    public PolicyEntity getPolicyByIdentifier(NameIdentifier ident) {
        NameIdentifier nameIdentifier = ident;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)nameIdentifier);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = PolicyMetaService.class.getDeclaredMethod("getPolicyByIdentifier", NameIdentifier.class).getAnnotation(Monitored.class);
        }
        return (PolicyEntity)PolicyMetaService.getPolicyByIdentifier_aroundBody3$advice(this, nameIdentifier, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="insertPolicy")
    public void insertPolicy(PolicyEntity policyEntity, boolean overwritten) throws IOException {
        PolicyEntity policyEntity2 = policyEntity;
        boolean bl = overwritten;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)policyEntity2, (Object)Conversions.booleanObject((boolean)bl));
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = PolicyMetaService.class.getDeclaredMethod("insertPolicy", PolicyEntity.class, Boolean.TYPE).getAnnotation(Monitored.class);
        }
        PolicyMetaService.insertPolicy_aroundBody5$advice(this, policyEntity2, bl, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="updatePolicy")
    public <E extends Entity & HasIdentifier> PolicyEntity updatePolicy(NameIdentifier ident, Function<E, E> updater) throws IOException {
        NameIdentifier nameIdentifier = ident;
        Function<E, E> function = updater;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)nameIdentifier, function);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$3;
        if (annotation == null) {
            annotation = ajc$anno$3 = PolicyMetaService.class.getDeclaredMethod("updatePolicy", NameIdentifier.class, Function.class).getAnnotation(Monitored.class);
        }
        return (PolicyEntity)PolicyMetaService.updatePolicy_aroundBody7$advice(this, nameIdentifier, function, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="deletePolicy")
    public boolean deletePolicy(NameIdentifier ident) {
        NameIdentifier nameIdentifier = ident;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)nameIdentifier);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$4;
        if (annotation == null) {
            annotation = ajc$anno$4 = PolicyMetaService.class.getDeclaredMethod("deletePolicy", NameIdentifier.class).getAnnotation(Monitored.class);
        }
        return Conversions.booleanValue((Object)PolicyMetaService.deletePolicy_aroundBody9$advice(this, nameIdentifier, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation));
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="listPoliciesForMetadataObject")
    public List<PolicyEntity> listPoliciesForMetadataObject(NameIdentifier objectIdent, Entity.EntityType objectType) throws NoSuchEntityException, IOException {
        NameIdentifier nameIdentifier = objectIdent;
        Entity.EntityType entityType = objectType;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)nameIdentifier, (Object)((Object)entityType));
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$5;
        if (annotation == null) {
            annotation = ajc$anno$5 = PolicyMetaService.class.getDeclaredMethod("listPoliciesForMetadataObject", NameIdentifier.class, Entity.EntityType.class).getAnnotation(Monitored.class);
        }
        return (List)PolicyMetaService.listPoliciesForMetadataObject_aroundBody11$advice(this, nameIdentifier, entityType, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="getPolicyForMetadataObject")
    public PolicyEntity getPolicyForMetadataObject(NameIdentifier objectIdent, Entity.EntityType objectType, NameIdentifier policyIdent) throws NoSuchEntityException, IOException {
        NameIdentifier nameIdentifier = objectIdent;
        Entity.EntityType entityType = objectType;
        NameIdentifier nameIdentifier2 = policyIdent;
        Object[] objectArray = new Object[]{nameIdentifier, entityType, nameIdentifier2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object[])objectArray);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$6;
        if (annotation == null) {
            annotation = ajc$anno$6 = PolicyMetaService.class.getDeclaredMethod("getPolicyForMetadataObject", NameIdentifier.class, Entity.EntityType.class, NameIdentifier.class).getAnnotation(Monitored.class);
        }
        return (PolicyEntity)PolicyMetaService.getPolicyForMetadataObject_aroundBody13$advice(this, nameIdentifier, entityType, nameIdentifier2, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="listAssociatedEntitiesForPolicy")
    public List<GenericEntity> listAssociatedEntitiesForPolicy(NameIdentifier policyIdent) throws IOException {
        NameIdentifier nameIdentifier = policyIdent;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)nameIdentifier);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$7;
        if (annotation == null) {
            annotation = ajc$anno$7 = PolicyMetaService.class.getDeclaredMethod("listAssociatedEntitiesForPolicy", NameIdentifier.class).getAnnotation(Monitored.class);
        }
        return (List)PolicyMetaService.listAssociatedEntitiesForPolicy_aroundBody15$advice(this, nameIdentifier, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="associatePoliciesWithMetadataObject")
    public List<PolicyEntity> associatePoliciesWithMetadataObject(NameIdentifier objectIdent, Entity.EntityType objectType, NameIdentifier[] policiesToAdd, NameIdentifier[] policiesToRemove) throws NoSuchEntityException, EntityAlreadyExistsException, IOException {
        NameIdentifier nameIdentifier = objectIdent;
        Entity.EntityType entityType = objectType;
        NameIdentifier[] nameIdentifierArray = policiesToAdd;
        NameIdentifier[] nameIdentifierArray2 = policiesToRemove;
        Object[] objectArray = new Object[]{nameIdentifier, entityType, nameIdentifierArray, nameIdentifierArray2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object[])objectArray);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$8;
        if (annotation == null) {
            annotation = ajc$anno$8 = PolicyMetaService.class.getDeclaredMethod("associatePoliciesWithMetadataObject", NameIdentifier.class, Entity.EntityType.class, NameIdentifier[].class, NameIdentifier[].class).getAnnotation(Monitored.class);
        }
        return (List)PolicyMetaService.associatePoliciesWithMetadataObject_aroundBody17$advice(this, nameIdentifier, entityType, nameIdentifierArray, nameIdentifierArray2, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="deletePolicyAndVersionMetasByLegacyTimeline")
    public int deletePolicyAndVersionMetasByLegacyTimeline(Long legacyTimeline, int limit) {
        Long l = legacyTimeline;
        int n = limit;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)l, (Object)Conversions.intObject((int)n));
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$9;
        if (annotation == null) {
            annotation = ajc$anno$9 = PolicyMetaService.class.getDeclaredMethod("deletePolicyAndVersionMetasByLegacyTimeline", Long.class, Integer.TYPE).getAnnotation(Monitored.class);
        }
        return Conversions.intValue((Object)PolicyMetaService.deletePolicyAndVersionMetasByLegacyTimeline_aroundBody19$advice(this, l, n, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation));
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="deletePolicyVersionsByRetentionCount")
    public int deletePolicyVersionsByRetentionCount(Long versionRetentionCount, int limit) {
        Long l = versionRetentionCount;
        int n = limit;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)l, (Object)Conversions.intObject((int)n));
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$10;
        if (annotation == null) {
            annotation = ajc$anno$10 = PolicyMetaService.class.getDeclaredMethod("deletePolicyVersionsByRetentionCount", Long.class, Integer.TYPE).getAnnotation(Monitored.class);
        }
        return Conversions.intValue((Object)PolicyMetaService.deletePolicyVersionsByRetentionCount_aroundBody21$advice(this, l, n, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation));
    }

    private PolicyPO getPolicyPOByMetalakeAndName(String metalakeName, String policyName) {
        PolicyPO policyPO = SessionUtils.getWithoutCommit(PolicyMetaMapper.class, mapper -> mapper.selectPolicyMetaByMetalakeAndName(metalakeName, policyName));
        if (policyPO == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.POLICY.name().toLowerCase(), policyName});
        }
        return policyPO;
    }

    private List<PolicyPO> getPolicyPOsByMetalakeAndNames(String metalakeName, List<String> policyNames) {
        return SessionUtils.getWithoutCommit(PolicyMetaMapper.class, mapper -> mapper.listPolicyPOsByMetalakeAndPolicyNames(metalakeName, policyNames));
    }

    public long getPolicyIdByPolicyName(long metalakeId, String policyName) {
        PolicyPO policyPO = SessionUtils.getWithoutCommit(PolicyMetaMapper.class, mapper -> mapper.selectPolicyMetaByMetalakeIdAndName(metalakeId, policyName));
        if (policyPO == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.POLICY.name().toLowerCase(), policyName});
        }
        return policyPO.getPolicyId();
    }

    static {
        PolicyMetaService.ajc$preClinit();
        INSTANCE = new PolicyMetaService();
        LOG = LoggerFactory.getLogger(PolicyMetaService.class);
    }

    private static final /* synthetic */ List listPoliciesByNamespace_aroundBody0(PolicyMetaService ajc$this, Namespace namespace, JoinPoint joinPoint) {
        String metalakeName = namespace.level(0);
        List policyPOs = SessionUtils.getWithoutCommit(PolicyMetaMapper.class, mapper -> mapper.listPolicyPOsByMetalake(metalakeName));
        return policyPOs.stream().map(policyPO -> POConverters.fromPolicyPO(policyPO, namespace)).collect(Collectors.toList());
    }

    private static final /* synthetic */ Object listPoliciesByNamespace_aroundBody1$advice(PolicyMetaService ajc$this, Namespace namespace, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        List list;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return PolicyMetaService.listPoliciesByNamespace_aroundBody0(ajc$this, namespace, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return PolicyMetaService.listPoliciesByNamespace_aroundBody0(ajc$this, namespace, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                List result = PolicyMetaService.listPoliciesByNamespace_aroundBody0(ajc$this, namespace, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                list = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return list;
    }

    private static final /* synthetic */ PolicyEntity getPolicyByIdentifier_aroundBody2(PolicyMetaService ajc$this, NameIdentifier ident, JoinPoint joinPoint) {
        String metalakeName = ident.namespace().level(0);
        PolicyPO policyPO = ajc$this.getPolicyPOByMetalakeAndName(metalakeName, ident.name());
        return POConverters.fromPolicyPO(policyPO, ident.namespace());
    }

    private static final /* synthetic */ Object getPolicyByIdentifier_aroundBody3$advice(PolicyMetaService ajc$this, NameIdentifier ident, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        PolicyEntity policyEntity;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return PolicyMetaService.getPolicyByIdentifier_aroundBody2(ajc$this, ident, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return PolicyMetaService.getPolicyByIdentifier_aroundBody2(ajc$this, ident, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                PolicyEntity result = PolicyMetaService.getPolicyByIdentifier_aroundBody2(ajc$this, ident, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                policyEntity = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return policyEntity;
    }

    private static final /* synthetic */ void insertPolicy_aroundBody4(PolicyMetaService ajc$this, PolicyEntity policyEntity, boolean overwritten, JoinPoint joinPoint) {
        Namespace ns = policyEntity.namespace();
        String metalakeName = ns.level(0);
        try {
            Long metalakeId = EntityIdService.getEntityId(NameIdentifier.of((String[])new String[]{metalakeName}), Entity.EntityType.METALAKE);
            PolicyPO.Builder builder = PolicyPO.builder().withMetalakeId(metalakeId);
            PolicyPO policyPO = POConverters.initializePolicyPOWithVersion(policyEntity, builder);
            SessionUtils.doMultipleWithCommit(() -> SessionUtils.doWithoutCommit(PolicyMetaMapper.class, mapper -> {
                if (overwritten) {
                    mapper.insertPolicyMetaOnDuplicateKeyUpdate(policyPO);
                } else {
                    mapper.insertPolicyMeta(policyPO);
                }
            }), () -> SessionUtils.doWithoutCommit(PolicyVersionMapper.class, mapper -> {
                if (overwritten) {
                    mapper.insertPolicyVersionOnDuplicateKeyUpdate(policyPO.getPolicyVersionPO());
                } else {
                    mapper.insertPolicyVersion(policyPO.getPolicyVersionPO());
                }
            }));
        }
        catch (RuntimeException e) {
            ExceptionUtils.checkSQLException(e, Entity.EntityType.POLICY, policyEntity.toString());
            throw e;
        }
    }

    private static final /* synthetic */ Object insertPolicy_aroundBody5$advice(PolicyMetaService ajc$this, PolicyEntity policyEntity, boolean overwritten, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object var14_19;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                PolicyMetaService.insertPolicy_aroundBody4(ajc$this, policyEntity, overwritten, (JoinPoint)proceedingJoinPoint);
                return null;
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                PolicyMetaService.insertPolicy_aroundBody4(ajc$this, policyEntity, overwritten, (JoinPoint)proceedingJoinPoint);
                return null;
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                PolicyMetaService.insertPolicy_aroundBody4(ajc$this, policyEntity, overwritten, (JoinPoint)proceedingJoinPoint);
                Object result = null;
                successMeter.mark();
                var14_19 = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return var14_19;
    }

    private static final /* synthetic */ PolicyEntity updatePolicy_aroundBody6(PolicyMetaService ajc$this, NameIdentifier ident, Function updater, JoinPoint joinPoint) {
        Integer updateResult;
        String metalakeName = ident.namespace().level(0);
        PolicyPO oldPolicyPO = ajc$this.getPolicyPOByMetalakeAndName(metalakeName, ident.name());
        PolicyEntity oldPolicyEntity = POConverters.fromPolicyPO(oldPolicyPO, ident.namespace());
        PolicyEntity updatedPolicyEntity = (PolicyEntity)updater.apply(oldPolicyEntity);
        Preconditions.checkArgument((boolean)Objects.equals(oldPolicyEntity.id(), updatedPolicyEntity.id()), (String)"The updated policy entity id: %s must have the same id as the old entity id %s", (Object)updatedPolicyEntity.id(), (Object)oldPolicyEntity.id());
        try {
            boolean checkNeedUpdateVersion = POConverters.checkPolicyVersionNeedUpdate(oldPolicyPO.getPolicyVersionPO(), updatedPolicyEntity);
            PolicyPO newPolicyPO = POConverters.updatePolicyPOWithVersion(oldPolicyPO, updatedPolicyEntity, checkNeedUpdateVersion);
            if (checkNeedUpdateVersion) {
                SessionUtils.doMultipleWithCommit(() -> SessionUtils.doWithoutCommit(PolicyVersionMapper.class, mapper -> mapper.insertPolicyVersion(newPolicyPO.getPolicyVersionPO())), () -> SessionUtils.doWithoutCommit(PolicyMetaMapper.class, mapper -> mapper.updatePolicyMeta(newPolicyPO, oldPolicyPO)));
                updateResult = 1;
            } else {
                updateResult = SessionUtils.doWithCommitAndFetchResult(PolicyMetaMapper.class, mapper -> mapper.updatePolicyMeta(newPolicyPO, oldPolicyPO));
            }
        }
        catch (RuntimeException re) {
            ExceptionUtils.checkSQLException(re, Entity.EntityType.POLICY, updatedPolicyEntity.nameIdentifier().toString());
            throw re;
        }
        if (updateResult > 0) {
            return updatedPolicyEntity;
        }
        throw new IOException("Failed to update the entity: " + String.valueOf(updatedPolicyEntity));
    }

    private static final /* synthetic */ Object updatePolicy_aroundBody7$advice(PolicyMetaService ajc$this, NameIdentifier ident, Function updater, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        PolicyEntity policyEntity;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return PolicyMetaService.updatePolicy_aroundBody6(ajc$this, ident, updater, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return PolicyMetaService.updatePolicy_aroundBody6(ajc$this, ident, updater, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                PolicyEntity result = PolicyMetaService.updatePolicy_aroundBody6(ajc$this, ident, updater, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                policyEntity = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return policyEntity;
    }

    private static final /* synthetic */ boolean deletePolicy_aroundBody8(PolicyMetaService ajc$this, NameIdentifier ident, JoinPoint joinPoint) {
        String metalakeName = ident.namespace().level(0);
        int[] policyMetaDeletedCount = new int[]{0};
        int[] policyVersionDeletedCount = new int[]{0};
        SessionUtils.doMultipleWithCommit(() -> {
            policyMetaDeletedCount[0] = SessionUtils.getWithoutCommit(PolicyMetaMapper.class, mapper -> mapper.softDeletePolicyByMetalakeAndPolicyName(metalakeName, ident.name()));
        }, () -> {
            policyVersionDeletedCount[0] = SessionUtils.getWithoutCommit(PolicyVersionMapper.class, mapper -> mapper.softDeletePolicyVersionByMetalakeAndPolicyName(metalakeName, ident.name()));
        });
        return policyMetaDeletedCount[0] + policyVersionDeletedCount[0] > 0;
    }

    private static final /* synthetic */ Object deletePolicy_aroundBody9$advice(PolicyMetaService ajc$this, NameIdentifier ident, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object object;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.booleanObject((boolean)PolicyMetaService.deletePolicy_aroundBody8(ajc$this, ident, (JoinPoint)proceedingJoinPoint));
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.booleanObject((boolean)PolicyMetaService.deletePolicy_aroundBody8(ajc$this, ident, (JoinPoint)proceedingJoinPoint));
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Object result = Conversions.booleanObject((boolean)PolicyMetaService.deletePolicy_aroundBody8(ajc$this, ident, (JoinPoint)proceedingJoinPoint));
                successMeter.mark();
                object = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return object;
    }

    private static final /* synthetic */ List listPoliciesForMetadataObject_aroundBody10(PolicyMetaService ajc$this, NameIdentifier objectIdent, Entity.EntityType objectType, JoinPoint joinPoint) {
        List PolicyPOs;
        MetadataObject metadataObject = NameIdentifierUtil.toMetadataObject(objectIdent, objectType);
        String metalake = objectIdent.namespace().level(0);
        try {
            Long metadataObjectId = EntityIdService.getEntityId(objectIdent, objectType);
            PolicyPOs = SessionUtils.getWithoutCommit(PolicyMetadataObjectRelMapper.class, mapper -> mapper.listPolicyPOsByMetadataObjectIdAndType(metadataObjectId, metadataObject.type().toString()));
        }
        catch (RuntimeException e) {
            ExceptionUtils.checkSQLException(e, Entity.EntityType.POLICY, objectIdent.toString());
            throw e;
        }
        return PolicyPOs.stream().map(PolicyPO2 -> POConverters.fromPolicyPO(PolicyPO2, NamespaceUtil.ofPolicy(metalake))).collect(Collectors.toList());
    }

    private static final /* synthetic */ Object listPoliciesForMetadataObject_aroundBody11$advice(PolicyMetaService ajc$this, NameIdentifier objectIdent, Entity.EntityType objectType, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        List list;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return PolicyMetaService.listPoliciesForMetadataObject_aroundBody10(ajc$this, objectIdent, objectType, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return PolicyMetaService.listPoliciesForMetadataObject_aroundBody10(ajc$this, objectIdent, objectType, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                List result = PolicyMetaService.listPoliciesForMetadataObject_aroundBody10(ajc$this, objectIdent, objectType, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                list = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return list;
    }

    private static final /* synthetic */ PolicyEntity getPolicyForMetadataObject_aroundBody12(PolicyMetaService ajc$this, NameIdentifier objectIdent, Entity.EntityType objectType, NameIdentifier policyIdent, JoinPoint joinPoint) {
        PolicyPO policyPO;
        MetadataObject metadataObject = NameIdentifierUtil.toMetadataObject(objectIdent, objectType);
        String metalake = objectIdent.namespace().level(0);
        try {
            Long metadataObjectId = EntityIdService.getEntityId(objectIdent, objectType);
            policyPO = SessionUtils.getWithoutCommit(PolicyMetadataObjectRelMapper.class, mapper -> mapper.getPolicyPOsByMetadataObjectAndPolicyName(metadataObjectId, metadataObject.type().toString(), policyIdent.name()));
        }
        catch (RuntimeException e) {
            ExceptionUtils.checkSQLException(e, Entity.EntityType.POLICY, policyIdent.toString());
            throw e;
        }
        if (policyPO == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.POLICY.name().toLowerCase(), policyIdent.name()});
        }
        return POConverters.fromPolicyPO(policyPO, NamespaceUtil.ofPolicy(metalake));
    }

    private static final /* synthetic */ Object getPolicyForMetadataObject_aroundBody13$advice(PolicyMetaService ajc$this, NameIdentifier objectIdent, Entity.EntityType objectType, NameIdentifier policyIdent, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        PolicyEntity policyEntity;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return PolicyMetaService.getPolicyForMetadataObject_aroundBody12(ajc$this, objectIdent, objectType, policyIdent, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return PolicyMetaService.getPolicyForMetadataObject_aroundBody12(ajc$this, objectIdent, objectType, policyIdent, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                PolicyEntity result = PolicyMetaService.getPolicyForMetadataObject_aroundBody12(ajc$this, objectIdent, objectType, policyIdent, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                policyEntity = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return policyEntity;
    }

    private static final /* synthetic */ List listAssociatedEntitiesForPolicy_aroundBody14(PolicyMetaService ajc$this, NameIdentifier policyIdent, JoinPoint joinPoint) {
        String metalakeName = policyIdent.namespace().level(0);
        String policyName = policyIdent.name();
        try {
            List policyMetadataObjectRelPOs = SessionUtils.doWithCommitAndFetchResult(PolicyMetadataObjectRelMapper.class, mapper -> mapper.listPolicyMetadataObjectRelsByMetalakeAndPolicyName(metalakeName, policyName));
            return policyMetadataObjectRelPOs.stream().map(r -> GenericEntity.builder().withId(r.getMetadataObjectId()).withEntityType(MetadataObjectUtil.toEntityType(MetadataObject.Type.valueOf((String)r.getMetadataObjectType()))).build()).collect(Collectors.toList());
        }
        catch (RuntimeException e) {
            ExceptionUtils.checkSQLException(e, Entity.EntityType.POLICY, policyIdent.toString());
            throw e;
        }
    }

    private static final /* synthetic */ Object listAssociatedEntitiesForPolicy_aroundBody15$advice(PolicyMetaService ajc$this, NameIdentifier policyIdent, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        List list;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return PolicyMetaService.listAssociatedEntitiesForPolicy_aroundBody14(ajc$this, policyIdent, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return PolicyMetaService.listAssociatedEntitiesForPolicy_aroundBody14(ajc$this, policyIdent, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                List result = PolicyMetaService.listAssociatedEntitiesForPolicy_aroundBody14(ajc$this, policyIdent, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                list = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return list;
    }

    private static final /* synthetic */ List associatePoliciesWithMetadataObject_aroundBody16(PolicyMetaService ajc$this, NameIdentifier objectIdent, Entity.EntityType objectType, NameIdentifier[] policiesToAdd, NameIdentifier[] policiesToRemove, JoinPoint joinPoint) {
        MetadataObject metadataObject = NameIdentifierUtil.toMetadataObject(objectIdent, objectType);
        String metalake = objectIdent.namespace().level(0);
        try {
            Long metadataObjectId = EntityIdService.getEntityId(objectIdent, objectType);
            List<String> policyNamesToAdd = Arrays.stream(policiesToAdd).map(NameIdentifier::name).collect(Collectors.toList());
            List policyPOsToAdd = policyNamesToAdd.isEmpty() ? Collections.emptyList() : ajc$this.getPolicyPOsByMetalakeAndNames(metalake, policyNamesToAdd);
            List<String> policyNamesToRemove = Arrays.stream(policiesToRemove).map(NameIdentifier::name).collect(Collectors.toList());
            List policyPOsToRemove = policyNamesToRemove.isEmpty() ? Collections.emptyList() : ajc$this.getPolicyPOsByMetalakeAndNames(metalake, policyNamesToRemove);
            SessionUtils.doMultipleWithCommit(() -> {
                if (policyPOsToAdd.isEmpty()) {
                    return;
                }
                List policyRelsToAdd = policyPOsToAdd.stream().map(policyPO -> POConverters.initializePolicyMetadataObjectRelPOWithVersion(policyPO.getPolicyId(), metadataObjectId, metadataObject.type().toString())).collect(Collectors.toList());
                SessionUtils.doWithoutCommit(PolicyMetadataObjectRelMapper.class, mapper -> mapper.batchInsertPolicyMetadataObjectRels(policyRelsToAdd));
            }, () -> {
                if (policyPOsToRemove.isEmpty()) {
                    return;
                }
                List policyIdsToRemove = policyPOsToRemove.stream().map(PolicyPO::getPolicyId).collect(Collectors.toList());
                SessionUtils.doWithoutCommit(PolicyMetadataObjectRelMapper.class, mapper -> mapper.batchDeletePolicyMetadataObjectRelsByPolicyIdsAndMetadataObject(metadataObjectId, metadataObject.type().toString(), policyIdsToRemove));
            });
            List policyPOs = SessionUtils.getWithoutCommit(PolicyMetadataObjectRelMapper.class, mapper -> mapper.listPolicyPOsByMetadataObjectIdAndType(metadataObjectId, metadataObject.type().toString()));
            return policyPOs.stream().map(policyPO -> POConverters.fromPolicyPO(policyPO, NamespaceUtil.ofPolicy(metalake))).collect(Collectors.toList());
        }
        catch (RuntimeException e) {
            ExceptionUtils.checkSQLException(e, Entity.EntityType.POLICY, objectIdent.toString());
            throw e;
        }
    }

    private static final /* synthetic */ Object associatePoliciesWithMetadataObject_aroundBody17$advice(PolicyMetaService ajc$this, NameIdentifier objectIdent, Entity.EntityType objectType, NameIdentifier[] policiesToAdd, NameIdentifier[] policiesToRemove, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        List list;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return PolicyMetaService.associatePoliciesWithMetadataObject_aroundBody16(ajc$this, objectIdent, objectType, policiesToAdd, policiesToRemove, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return PolicyMetaService.associatePoliciesWithMetadataObject_aroundBody16(ajc$this, objectIdent, objectType, policiesToAdd, policiesToRemove, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                List result = PolicyMetaService.associatePoliciesWithMetadataObject_aroundBody16(ajc$this, objectIdent, objectType, policiesToAdd, policiesToRemove, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                list = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return list;
    }

    private static final /* synthetic */ int deletePolicyAndVersionMetasByLegacyTimeline_aroundBody18(PolicyMetaService ajc$this, Long legacyTimeline, int limit, JoinPoint joinPoint) {
        int policyDeletedCount = SessionUtils.doWithCommitAndFetchResult(PolicyMetaMapper.class, mapper -> mapper.deletePolicyMetasByLegacyTimeline(legacyTimeline, limit));
        int policyVersionDeletedCount = SessionUtils.doWithCommitAndFetchResult(PolicyVersionMapper.class, mapper -> mapper.deletePolicyVersionsByLegacyTimeline(legacyTimeline, limit));
        return policyDeletedCount + policyVersionDeletedCount;
    }

    private static final /* synthetic */ Object deletePolicyAndVersionMetasByLegacyTimeline_aroundBody19$advice(PolicyMetaService ajc$this, Long legacyTimeline, int limit, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object object;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.intObject((int)PolicyMetaService.deletePolicyAndVersionMetasByLegacyTimeline_aroundBody18(ajc$this, legacyTimeline, limit, (JoinPoint)proceedingJoinPoint));
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.intObject((int)PolicyMetaService.deletePolicyAndVersionMetasByLegacyTimeline_aroundBody18(ajc$this, legacyTimeline, limit, (JoinPoint)proceedingJoinPoint));
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Object result = Conversions.intObject((int)PolicyMetaService.deletePolicyAndVersionMetasByLegacyTimeline_aroundBody18(ajc$this, legacyTimeline, limit, (JoinPoint)proceedingJoinPoint));
                successMeter.mark();
                object = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return object;
    }

    private static final /* synthetic */ int deletePolicyVersionsByRetentionCount_aroundBody20(PolicyMetaService ajc$this, Long versionRetentionCount, int limit, JoinPoint joinPoint) {
        List policyMaxVersions = SessionUtils.getWithoutCommit(PolicyVersionMapper.class, mapper -> mapper.selectPolicyVersionsByRetentionCount(versionRetentionCount));
        int totalDeletedCount = 0;
        for (PolicyMaxVersionPO policyMaxVersion : policyMaxVersions) {
            long versionRetentionLine = policyMaxVersion.getVersion() - versionRetentionCount;
            int deletedCount = SessionUtils.doWithCommitAndFetchResult(PolicyVersionMapper.class, mapper -> mapper.softDeletePolicyVersionsByRetentionLine(policyMaxVersion.getPolicyId(), versionRetentionLine, limit));
            totalDeletedCount += deletedCount;
            LOG.info("Soft delete policyVersions count: {} which versions are smaller than or equal to versionRetentionLine: {}, the current policyId and maxVersion is: <{}, {}>.", new Object[]{deletedCount, versionRetentionLine, policyMaxVersion.getPolicyId(), policyMaxVersion.getVersion()});
        }
        return totalDeletedCount;
    }

    private static final /* synthetic */ Object deletePolicyVersionsByRetentionCount_aroundBody21$advice(PolicyMetaService ajc$this, Long versionRetentionCount, int limit, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object object;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.intObject((int)PolicyMetaService.deletePolicyVersionsByRetentionCount_aroundBody20(ajc$this, versionRetentionCount, limit, (JoinPoint)proceedingJoinPoint));
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.intObject((int)PolicyMetaService.deletePolicyVersionsByRetentionCount_aroundBody20(ajc$this, versionRetentionCount, limit, (JoinPoint)proceedingJoinPoint));
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Object result = Conversions.intObject((int)PolicyMetaService.deletePolicyVersionsByRetentionCount_aroundBody20(ajc$this, versionRetentionCount, limit, (JoinPoint)proceedingJoinPoint));
                successMeter.mark();
                object = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return object;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("PolicyMetaService.java", PolicyMetaService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listPoliciesByNamespace", "org.apache.gravitino.storage.relational.service.PolicyMetaService", "org.apache.gravitino.Namespace", "namespace", "", "java.util.List"), 70);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPolicyByIdentifier", "org.apache.gravitino.storage.relational.service.PolicyMetaService", "org.apache.gravitino.NameIdentifier", "ident", "", "org.apache.gravitino.meta.PolicyEntity"), 83);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deletePolicyVersionsByRetentionCount", "org.apache.gravitino.storage.relational.service.PolicyMetaService", "java.lang.Long:int", "versionRetentionCount:limit", "", "int"), 413);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "insertPolicy", "org.apache.gravitino.storage.relational.service.PolicyMetaService", "org.apache.gravitino.meta.PolicyEntity:boolean", "policyEntity:overwritten", "java.io.IOException", "void"), 92);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updatePolicy", "org.apache.gravitino.storage.relational.service.PolicyMetaService", "org.apache.gravitino.NameIdentifier:java.util.function.Function", "ident:updater", "java.io.IOException", "org.apache.gravitino.meta.PolicyEntity"), 135);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deletePolicy", "org.apache.gravitino.storage.relational.service.PolicyMetaService", "org.apache.gravitino.NameIdentifier", "ident", "", "boolean"), 189);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listPoliciesForMetadataObject", "org.apache.gravitino.storage.relational.service.PolicyMetaService", "org.apache.gravitino.NameIdentifier:org.apache.gravitino.Entity$EntityType", "objectIdent:objectType", "org.apache.gravitino.exceptions.NoSuchEntityException:java.io.IOException", "java.util.List"), 217);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPolicyForMetadataObject", "org.apache.gravitino.storage.relational.service.PolicyMetaService", "org.apache.gravitino.NameIdentifier:org.apache.gravitino.Entity$EntityType:org.apache.gravitino.NameIdentifier", "objectIdent:objectType:policyIdent", "org.apache.gravitino.exceptions.NoSuchEntityException:java.io.IOException", "org.apache.gravitino.meta.PolicyEntity"), 246);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listAssociatedEntitiesForPolicy", "org.apache.gravitino.storage.relational.service.PolicyMetaService", "org.apache.gravitino.NameIdentifier", "policyIdent", "java.io.IOException", "java.util.List"), 279);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "associatePoliciesWithMetadataObject", "org.apache.gravitino.storage.relational.service.PolicyMetaService", "org.apache.gravitino.NameIdentifier:org.apache.gravitino.Entity$EntityType:[Lorg.apache.gravitino.NameIdentifier;:[Lorg.apache.gravitino.NameIdentifier;", "objectIdent:objectType:policiesToAdd:policiesToRemove", "org.apache.gravitino.exceptions.NoSuchEntityException:org.apache.gravitino.EntityAlreadyExistsException:java.io.IOException", "java.util.List"), 316);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deletePolicyAndVersionMetasByLegacyTimeline", "org.apache.gravitino.storage.relational.service.PolicyMetaService", "java.lang.Long:int", "legacyTimeline:limit", "", "int"), 395);
    }
}

