/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.shell.Display;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.test.GenericTestUtils;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class TestTextCommand {
    private static final File TEST_ROOT_DIR = GenericTestUtils.getTestDir("testText");
    private static final String AVRO_FILENAME = new File(TEST_ROOT_DIR, "weather.avro").toURI().getPath();
    private static final String TEXT_FILENAME = new File(TEST_ROOT_DIR, "testtextfile.txt").toURI().getPath();
    private static final String SEQUENCE_FILENAME = new File(TEST_ROOT_DIR, "NonWritableSequenceFile").toURI().getPath();
    private static final String SEPARATOR = System.getProperty("line.separator");
    private static final String AVRO_EXPECTED_OUTPUT = "{\"station\":\"011990-99999\",\"time\":-619524000000,\"temp\":0}" + SEPARATOR + "{\"station\":\"011990-99999\",\"time\":-619506000000,\"temp\":22}" + SEPARATOR + "{\"station\":\"011990-99999\",\"time\":-619484400000,\"temp\":-11}" + SEPARATOR + "{\"station\":\"012650-99999\",\"time\":-655531200000,\"temp\":111}" + SEPARATOR + "{\"station\":\"012650-99999\",\"time\":-655509600000,\"temp\":78}" + SEPARATOR;
    private static final String SEQUENCE_FILE_EXPECTED_OUTPUT = "Key1\tValue1" + SEPARATOR + "Key2\tValue2" + SEPARATOR;
    @Rule
    public final Timeout testTimeout = new Timeout(30000);

    @Test
    public void testDisplayForAvroFiles() throws Exception {
        String output = TestTextCommand.readUsingTextCommand(AVRO_FILENAME, TestTextCommand.generateWeatherAvroBinaryData());
        ((AbstractStringAssert)Assertions.assertThat((String)output).describedAs("output", new Object[0])).isEqualTo((Object)AVRO_EXPECTED_OUTPUT);
    }

    @Test
    public void testDisplayForAvroFilesSmallMultiByteReads() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("io.file.buffer.size", 2);
        TestTextCommand.createFile(AVRO_FILENAME, TestTextCommand.generateWeatherAvroBinaryData());
        URI uri = new URI(AVRO_FILENAME);
        String output = TestTextCommand.readUsingTextCommand(uri, conf);
        ((AbstractStringAssert)Assertions.assertThat((String)output).describedAs("output", new Object[0])).isEqualTo((Object)AVRO_EXPECTED_OUTPUT);
    }

    @Test
    public void testEmptyAvroFile() throws Exception {
        String output = TestTextCommand.readUsingTextCommand(AVRO_FILENAME, TestTextCommand.generateEmptyAvroBinaryData());
        ((AbstractStringAssert)Assertions.assertThat((String)output).describedAs("output", new Object[0])).isEmpty();
    }

    @Test(expected=NullPointerException.class)
    public void testAvroFileInputStreamNullBuffer() throws Exception {
        TestTextCommand.createFile(AVRO_FILENAME, TestTextCommand.generateWeatherAvroBinaryData());
        URI uri = new URI(AVRO_FILENAME);
        Configuration conf = new Configuration();
        try (InputStream is = TestTextCommand.getInputStream(uri, conf);){
            is.read(null, 0, 10);
        }
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testAvroFileInputStreamNegativePosition() throws Exception {
        TestTextCommand.createFile(AVRO_FILENAME, TestTextCommand.generateWeatherAvroBinaryData());
        URI uri = new URI(AVRO_FILENAME);
        Configuration conf = new Configuration();
        try (InputStream is = TestTextCommand.getInputStream(uri, conf);){
            is.read(new byte[10], -1, 10);
        }
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testAvroFileInputStreamTooLong() throws Exception {
        TestTextCommand.createFile(AVRO_FILENAME, TestTextCommand.generateWeatherAvroBinaryData());
        URI uri = new URI(AVRO_FILENAME);
        Configuration conf = new Configuration();
        try (InputStream is = TestTextCommand.getInputStream(uri, conf);){
            is.read(new byte[10], 0, 11);
        }
    }

    @Test
    public void testAvroFileInputStreamZeroLengthRead() throws Exception {
        TestTextCommand.createFile(AVRO_FILENAME, TestTextCommand.generateWeatherAvroBinaryData());
        URI uri = new URI(AVRO_FILENAME);
        Configuration conf = new Configuration();
        try (InputStream is = TestTextCommand.getInputStream(uri, conf);){
            ((AbstractIntegerAssert)Assertions.assertThat((int)is.read(new byte[10], 0, 0)).describedAs("bytes read", new Object[0])).isEqualTo(0);
        }
    }

    @Test
    public void testAvroFileInputStreamConsistentEOF() throws Exception {
        TestTextCommand.createFile(AVRO_FILENAME, TestTextCommand.generateWeatherAvroBinaryData());
        URI uri = new URI(AVRO_FILENAME);
        Configuration conf = new Configuration();
        try (InputStream is = TestTextCommand.getInputStream(uri, conf);){
            TestTextCommand.inputStreamToString(is);
            ((AbstractIntegerAssert)Assertions.assertThat((int)is.read()).describedAs("single byte EOF", new Object[0])).isEqualTo(-1);
            ((AbstractIntegerAssert)Assertions.assertThat((int)is.read(new byte[10], 0, 10)).describedAs("multi byte EOF", new Object[0])).isEqualTo(-1);
        }
    }

    @Test
    public void testAvroFileInputStreamSingleAndMultiByteReads() throws Exception {
        TestTextCommand.createFile(AVRO_FILENAME, TestTextCommand.generateWeatherAvroBinaryData());
        URI uri = new URI(AVRO_FILENAME);
        Configuration conf = new Configuration();
        try (InputStream is1 = TestTextCommand.getInputStream(uri, conf);
             InputStream is2 = TestTextCommand.getInputStream(uri, conf);){
            String multiByteReads = TestTextCommand.inputStreamToString(is1);
            String singleByteReads = TestTextCommand.inputStreamSingleByteReadsToString(is2);
            ((AbstractStringAssert)Assertions.assertThat((String)multiByteReads).describedAs("same bytes read from multi and single byte reads", new Object[0])).isEqualTo((Object)singleByteReads);
        }
    }

    @Test
    public void testEmptyTextFile() throws Exception {
        byte[] emptyContents = new byte[]{};
        String output = TestTextCommand.readUsingTextCommand(TEXT_FILENAME, emptyContents);
        ((AbstractStringAssert)Assertions.assertThat((String)output).describedAs("output", new Object[0])).isEmpty();
    }

    @Test
    public void testOneByteTextFile() throws Exception {
        byte[] oneByteContents = new byte[]{120};
        String output = TestTextCommand.readUsingTextCommand(TEXT_FILENAME, oneByteContents);
        String expected = new String(oneByteContents, StandardCharsets.UTF_8);
        ((AbstractStringAssert)Assertions.assertThat((String)output).describedAs("output", new Object[0])).isEqualTo((Object)expected);
    }

    @Test
    public void testTwoByteTextFile() throws Exception {
        byte[] twoByteContents = new byte[]{120, 121};
        String output = TestTextCommand.readUsingTextCommand(TEXT_FILENAME, twoByteContents);
        String expected = new String(twoByteContents, StandardCharsets.UTF_8);
        ((AbstractStringAssert)Assertions.assertThat((String)output).describedAs("output", new Object[0])).isEqualTo((Object)expected);
    }

    @Test
    public void testDisplayForNonWritableSequenceFile() throws Exception {
        Configuration conf = new Configuration();
        TestTextCommand.createNonWritableSequenceFile(SEQUENCE_FILENAME, conf);
        URI uri = new URI(SEQUENCE_FILENAME);
        String output = TestTextCommand.readUsingTextCommand(uri, conf);
        ((AbstractStringAssert)Assertions.assertThat((String)output).describedAs("output", new Object[0])).isEqualTo((Object)SEQUENCE_FILE_EXPECTED_OUTPUT);
    }

    @Test
    public void testDisplayForSequenceFileSmallMultiByteReads() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("io.file.buffer.size", 2);
        TestTextCommand.createNonWritableSequenceFile(SEQUENCE_FILENAME, conf);
        URI uri = new URI(SEQUENCE_FILENAME);
        String output = TestTextCommand.readUsingTextCommand(uri, conf);
        ((AbstractStringAssert)Assertions.assertThat((String)output).describedAs("output", new Object[0])).isEqualTo((Object)SEQUENCE_FILE_EXPECTED_OUTPUT);
    }

    @Test
    public void testEmptySequenceFile() throws Exception {
        Configuration conf = new Configuration();
        TestTextCommand.createEmptySequenceFile(SEQUENCE_FILENAME, conf);
        URI uri = new URI(SEQUENCE_FILENAME);
        String output = TestTextCommand.readUsingTextCommand(uri, conf);
        ((AbstractStringAssert)Assertions.assertThat((String)output).describedAs("output", new Object[0])).isEmpty();
    }

    @Test(expected=NullPointerException.class)
    public void testSequenceFileInputStreamNullBuffer() throws Exception {
        Configuration conf = new Configuration();
        TestTextCommand.createNonWritableSequenceFile(SEQUENCE_FILENAME, conf);
        URI uri = new URI(SEQUENCE_FILENAME);
        try (InputStream is = TestTextCommand.getInputStream(uri, conf);){
            is.read(null, 0, 10);
        }
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testSequenceFileInputStreamNegativePosition() throws Exception {
        Configuration conf = new Configuration();
        TestTextCommand.createNonWritableSequenceFile(SEQUENCE_FILENAME, conf);
        URI uri = new URI(SEQUENCE_FILENAME);
        try (InputStream is = TestTextCommand.getInputStream(uri, conf);){
            is.read(new byte[10], -1, 10);
        }
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testSequenceFileInputStreamTooLong() throws Exception {
        Configuration conf = new Configuration();
        TestTextCommand.createNonWritableSequenceFile(SEQUENCE_FILENAME, conf);
        URI uri = new URI(SEQUENCE_FILENAME);
        try (InputStream is = TestTextCommand.getInputStream(uri, conf);){
            is.read(new byte[10], 0, 11);
        }
    }

    @Test
    public void testSequenceFileInputStreamZeroLengthRead() throws Exception {
        Configuration conf = new Configuration();
        TestTextCommand.createNonWritableSequenceFile(SEQUENCE_FILENAME, conf);
        URI uri = new URI(SEQUENCE_FILENAME);
        try (InputStream is = TestTextCommand.getInputStream(uri, conf);){
            ((AbstractIntegerAssert)Assertions.assertThat((int)is.read(new byte[10], 0, 0)).describedAs("bytes read", new Object[0])).isEqualTo(0);
        }
    }

    @Test
    public void testSequenceFileInputStreamConsistentEOF() throws Exception {
        Configuration conf = new Configuration();
        TestTextCommand.createNonWritableSequenceFile(SEQUENCE_FILENAME, conf);
        URI uri = new URI(SEQUENCE_FILENAME);
        try (InputStream is = TestTextCommand.getInputStream(uri, conf);){
            TestTextCommand.inputStreamToString(is);
            ((AbstractIntegerAssert)Assertions.assertThat((int)is.read()).describedAs("single byte EOF", new Object[0])).isEqualTo(-1);
            ((AbstractIntegerAssert)Assertions.assertThat((int)is.read(new byte[10], 0, 10)).describedAs("multi byte EOF", new Object[0])).isEqualTo(-1);
        }
    }

    @Test
    public void testSequenceFileInputStreamSingleAndMultiByteReads() throws Exception {
        Configuration conf = new Configuration();
        TestTextCommand.createNonWritableSequenceFile(SEQUENCE_FILENAME, conf);
        URI uri = new URI(SEQUENCE_FILENAME);
        try (InputStream is1 = TestTextCommand.getInputStream(uri, conf);
             InputStream is2 = TestTextCommand.getInputStream(uri, conf);){
            String multiByteReads = TestTextCommand.inputStreamToString(is1);
            String singleByteReads = TestTextCommand.inputStreamSingleByteReadsToString(is2);
            ((AbstractStringAssert)Assertions.assertThat((String)multiByteReads).describedAs("same bytes read from multi and single byte reads", new Object[0])).isEqualTo((Object)singleByteReads);
        }
    }

    private static String readUsingTextCommand(String fileName, byte[] fileContents) throws Exception {
        TestTextCommand.createFile(fileName, fileContents);
        Configuration conf = new Configuration();
        URI localPath = new URI(fileName);
        return TestTextCommand.readUsingTextCommand(localPath, conf);
    }

    private static String readUsingTextCommand(URI uri, Configuration conf) throws Exception {
        InputStream stream = TestTextCommand.getInputStream(uri, conf);
        return TestTextCommand.inputStreamToString(stream);
    }

    private static String inputStreamToString(InputStream stream) throws IOException {
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)stream, (Writer)writer, (Charset)StandardCharsets.UTF_8);
        return writer.toString();
    }

    private static String inputStreamSingleByteReadsToString(InputStream stream) throws IOException {
        StringWriter writer = new StringWriter();
        int b = stream.read();
        while (b != -1) {
            writer.write(b);
            b = stream.read();
        }
        return writer.toString();
    }

    private static void createFile(String fileName, byte[] contents) throws IOException {
        Files.createDirectories(TEST_ROOT_DIR.toPath(), new FileAttribute[0]);
        File file = new File(fileName);
        file.createNewFile();
        FileOutputStream stream = new FileOutputStream(file);
        stream.write(contents);
        stream.close();
    }

    private static byte[] generateWeatherAvroBinaryData() {
        byte[] contents = new byte[]{79, 98, 106, 1, 4, 20, 97, 118, 114, 111, 46, 99, 111, 100, 101, 99, 8, 110, 117, 108, 108, 22, 97, 118, 114, 111, 46, 115, 99, 104, 101, 109, 97, -14, 2, 123, 34, 116, 121, 112, 101, 34, 58, 34, 114, 101, 99, 111, 114, 100, 34, 44, 34, 110, 97, 109, 101, 34, 58, 34, 87, 101, 97, 116, 104, 101, 114, 34, 44, 34, 110, 97, 109, 101, 115, 112, 97, 99, 101, 34, 58, 34, 116, 101, 115, 116, 34, 44, 34, 102, 105, 101, 108, 100, 115, 34, 58, 91, 123, 34, 110, 97, 109, 101, 34, 58, 34, 115, 116, 97, 116, 105, 111, 110, 34, 44, 34, 116, 121, 112, 101, 34, 58, 34, 115, 116, 114, 105, 110, 103, 34, 125, 44, 123, 34, 110, 97, 109, 101, 34, 58, 34, 116, 105, 109, 101, 34, 44, 34, 116, 121, 112, 101, 34, 58, 34, 108, 111, 110, 103, 34, 125, 44, 123, 34, 110, 97, 109, 101, 34, 58, 34, 116, 101, 109, 112, 34, 44, 34, 116, 121, 112, 101, 34, 58, 34, 105, 110, 116, 34, 125, 93, 44, 34, 100, 111, 99, 34, 58, 34, 65, 32, 119, 101, 97, 116, 104, 101, 114, 32, 114, 101, 97, 100, 105, 110, 103, 46, 34, 125, 0, -80, -127, -77, -60, 10, 12, -10, 98, -6, -55, 56, -3, 126, 82, 0, -89, 10, -52, 1, 24, 48, 49, 49, 57, 57, 48, 45, 57, 57, 57, 57, 57, -1, -93, -112, -24, -121, 36, 0, 24, 48, 49, 49, 57, 57, 48, 45, 57, 57, 57, 57, 57, -1, -127, -5, -42, -121, 36, 44, 24, 48, 49, 49, 57, 57, 48, 45, 57, 57, 57, 57, 57, -1, -91, -82, -62, -121, 36, 21, 24, 48, 49, 50, 54, 53, 48, 45, 57, 57, 57, 57, 57, -1, -73, -94, -117, -108, 38, -34, 1, 24, 48, 49, 50, 54, 53, 48, 45, 57, 57, 57, 57, 57, -1, -37, -43, -10, -109, 38, -100, 1, -80, -127, -77, -60, 10, 12, -10, 98, -6, -55, 56, -3, 126, 82, 0, -89};
        return contents;
    }

    private static byte[] generateEmptyAvroBinaryData() {
        byte[] contents = new byte[]{79, 98, 106, 1, 4, 22, 97, 118, 114, 111, 46, 115, 99, 104, 101, 109, 97, -110, 3, 123, 34, 116, 121, 112, 101, 34, 58, 34, 114, 101, 99, 111, 114, 100, 34, 44, 34, 110, 97, 109, 101, 34, 58, 34, 85, 115, 101, 114, 34, 44, 34, 110, 97, 109, 101, 115, 112, 97, 99, 101, 34, 58, 34, 101, 120, 97, 109, 112, 108, 101, 46, 97, 118, 114, 111, 34, 44, 34, 102, 105, 101, 108, 100, 115, 34, 58, 91, 123, 34, 110, 97, 109, 101, 34, 58, 34, 110, 97, 109, 101, 34, 44, 34, 116, 121, 112, 101, 34, 58, 34, 115, 116, 114, 105, 110, 103, 34, 125, 44, 123, 34, 110, 97, 109, 101, 34, 58, 34, 102, 97, 118, 111, 114, 105, 116, 101, 95, 110, 117, 109, 98, 101, 114, 34, 44, 34, 116, 121, 112, 101, 34, 58, 91, 34, 105, 110, 116, 34, 44, 34, 110, 117, 108, 108, 34, 93, 125, 44, 123, 34, 110, 97, 109, 101, 34, 58, 34, 102, 97, 118, 111, 114, 105, 116, 101, 95, 99, 111, 108, 111, 114, 34, 44, 34, 116, 121, 112, 101, 34, 58, 91, 34, 115, 116, 114, 105, 110, 103, 34, 44, 34, 110, 117, 108, 108, 34, 93, 125, 93, 125, 20, 97, 118, 114, 111, 46, 99, 111, 100, 101, 99, 14, 100, 101, 102, 108, 97, 116, 101, 0, -19, -32, -6, -121, 60, -122, -11, 95, 125, -115, 47, -37, -57, -29, 17, 57};
        return contents;
    }

    private static void createEmptySequenceFile(String fileName, Configuration conf) throws IOException {
        conf.set("io.serializations", "org.apache.hadoop.io.serializer.JavaSerialization");
        Path path = new Path(fileName);
        SequenceFile.Writer writer = SequenceFile.createWriter((Configuration)conf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)path), SequenceFile.Writer.keyClass(String.class), SequenceFile.Writer.valueClass(String.class)});
        writer.close();
    }

    private static void createNonWritableSequenceFile(String fileName, Configuration conf) throws IOException {
        conf.set("io.serializations", "org.apache.hadoop.io.serializer.JavaSerialization");
        Path path = new Path(fileName);
        try (SequenceFile.Writer writer = SequenceFile.createWriter((Configuration)conf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)path), SequenceFile.Writer.keyClass(String.class), SequenceFile.Writer.valueClass(String.class)});){
            writer.append((Object)"Key1", (Object)"Value1");
            writer.append((Object)"Key2", (Object)"Value2");
        }
    }

    private static InputStream getInputStream(URI uri, Configuration conf) throws IOException {
        PathData pathData = new PathData(uri, conf);
        Display.Text text = new Display.Text(){

            public InputStream getInputStream(PathData item) throws IOException {
                return super.getInputStream(item);
            }
        };
        text.setConf(conf);
        return text.getInputStream(pathData);
    }
}

