/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.rm.preemption;

import org.apache.hadoop.mapreduce.JobCounter;
import org.apache.hadoop.mapreduce.checkpoint.TaskCheckpointID;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobCounterUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.mapreduce.v2.app.rm.preemption.AMPreemptionPolicy;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.PreemptionContainer;
import org.apache.hadoop.yarn.api.records.PreemptionContract;
import org.apache.hadoop.yarn.api.records.PreemptionMessage;
import org.apache.hadoop.yarn.api.records.StrictPreemptionContract;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KillAMPreemptionPolicy
implements AMPreemptionPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(KillAMPreemptionPolicy.class);
    private EventHandler dispatcher = null;

    @Override
    public void init(AppContext context) {
        this.dispatcher = context.getEventHandler();
    }

    @Override
    public void preempt(AMPreemptionPolicy.Context ctxt, PreemptionMessage preemptionRequests) {
        PreemptionContract contract;
        StrictPreemptionContract strictContract = preemptionRequests.getStrictContract();
        if (strictContract != null) {
            for (PreemptionContainer c : strictContract.getContainers()) {
                this.killContainer(ctxt, c);
            }
        }
        if ((contract = preemptionRequests.getContract()) != null) {
            for (PreemptionContainer c : contract.getContainers()) {
                this.killContainer(ctxt, c);
            }
        }
    }

    private void killContainer(AMPreemptionPolicy.Context ctxt, PreemptionContainer c) {
        ContainerId reqCont = c.getId();
        TaskAttemptId reqTask = ctxt.getTaskAttempt(reqCont);
        LOG.info("Evicting " + reqTask);
        this.dispatcher.handle((Event)new TaskAttemptEvent(reqTask, TaskAttemptEventType.TA_KILL));
        JobCounterUpdateEvent jce = new JobCounterUpdateEvent(reqTask.getTaskId().getJobId());
        jce.addCounterUpdate((Enum<?>)JobCounter.TASKS_REQ_PREEMPT, 1L);
        this.dispatcher.handle((Event)jce);
    }

    @Override
    public void handleFailedContainer(TaskAttemptId attemptID) {
    }

    @Override
    public boolean isPreempted(TaskAttemptId yarnAttemptID) {
        return false;
    }

    @Override
    public void reportSuccessfulPreemption(TaskAttemptId taskAttemptID) {
    }

    @Override
    public TaskCheckpointID getCheckpointID(TaskId taskId) {
        return null;
    }

    @Override
    public void setCheckpointID(TaskId taskId, TaskCheckpointID cid) {
    }

    @Override
    public void handleCompletedContainer(TaskAttemptId attemptID) {
    }
}

