/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.policy;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.policy.QueueOrderingPolicy;
import org.apache.hadoop.yarn.util.resource.Resources;

public class PriorityUtilizationQueueOrderingPolicy
implements QueueOrderingPolicy {
    private List<CSQueue> queues;
    private final boolean respectPriority;

    public static int compare(double relativeAssigned1, double relativeAssigned2, int priority1, int priority2) {
        if (priority1 == priority2) {
            return Double.compare(relativeAssigned1, relativeAssigned2);
        }
        if (relativeAssigned1 < 1.0 && relativeAssigned2 < 1.0 || relativeAssigned1 >= 1.0 && relativeAssigned2 >= 1.0) {
            return Integer.compare(priority2, priority1);
        }
        return Double.compare(relativeAssigned1, relativeAssigned2);
    }

    public PriorityUtilizationQueueOrderingPolicy(boolean respectPriority) {
        this.respectPriority = respectPriority;
    }

    @Override
    public void setQueues(List<CSQueue> queues) {
        this.queues = queues;
    }

    @Override
    public Iterator<CSQueue> getAssignmentIterator(String partition) {
        return new ArrayList<CSQueue>(this.queues).stream().map(queue -> PriorityQueueResourcesForSorting.create(queue, partition)).sorted(new PriorityQueueComparator(partition)).map(PriorityQueueResourcesForSorting::getQueue).collect(Collectors.toList()).iterator();
    }

    @Override
    public String getConfigName() {
        if (this.respectPriority) {
            return "priority-utilization";
        }
        return "utilization";
    }

    @VisibleForTesting
    public List<CSQueue> getQueues() {
        return this.queues;
    }

    public static class PriorityQueueResourcesForSorting {
        private final float absoluteUsedCapacity;
        private final float usedCapacity;
        private final Resource configuredMinResource;
        private final float absoluteCapacity;
        private final Priority priority;
        private final boolean nodeLabelAccessible;
        private final CSQueue queue;

        PriorityQueueResourcesForSorting(CSQueue queue, String partition) {
            this.queue = queue;
            this.absoluteUsedCapacity = queue.getQueueCapacities().getAbsoluteUsedCapacity(partition);
            this.usedCapacity = queue.getQueueCapacities().getUsedCapacity(partition);
            this.absoluteCapacity = queue.getQueueCapacities().getAbsoluteCapacity(partition);
            this.configuredMinResource = queue.getQueueResourceQuotas().getConfiguredMinResource(partition);
            this.priority = queue.getPriority();
            this.nodeLabelAccessible = queue.getAccessibleNodeLabels() != null && queue.getAccessibleNodeLabels().contains(partition) || queue.getAccessibleNodeLabels().contains("*");
        }

        static PriorityQueueResourcesForSorting create(CSQueue queue, String partition) {
            return new PriorityQueueResourcesForSorting(queue, partition);
        }

        public CSQueue getQueue() {
            return this.queue;
        }
    }

    public final class PriorityQueueComparator
    implements Comparator<PriorityQueueResourcesForSorting> {
        private final String partition;

        public PriorityQueueComparator(String partition) {
            this.partition = partition;
        }

        @Override
        public int compare(PriorityQueueResourcesForSorting q1Sort, PriorityQueueResourcesForSorting q2Sort) {
            int rc = this.compareQueueAccessToPartition(q1Sort.nodeLabelAccessible, q2Sort.nodeLabelAccessible);
            if (0 != rc) {
                return rc;
            }
            float q1AbsCapacity = q1Sort.absoluteCapacity;
            float q2AbsCapacity = q2Sort.absoluteCapacity;
            if (Float.compare(q1AbsCapacity, 0.0f) > 0 && Float.compare(q2AbsCapacity, 0.0f) == 0) {
                return -1;
            }
            if (Float.compare(q2AbsCapacity, 0.0f) > 0 && Float.compare(q1AbsCapacity, 0.0f) == 0) {
                return 1;
            }
            if (Float.compare(q1AbsCapacity, 0.0f) == 0 && Float.compare(q2AbsCapacity, 0.0f) == 0) {
                float used1 = q1Sort.absoluteUsedCapacity;
                float used2 = q2Sort.absoluteUsedCapacity;
                return this.compare(q1Sort, q2Sort, used1, used2, q1Sort.priority.getPriority(), q2Sort.priority.getPriority());
            }
            float used1 = q1Sort.usedCapacity;
            float used2 = q2Sort.usedCapacity;
            return this.compare(q1Sort, q2Sort, used1, used2, q1Sort.priority.getPriority(), q2Sort.priority.getPriority());
        }

        private int compare(PriorityQueueResourcesForSorting q1Sort, PriorityQueueResourcesForSorting q2Sort, float q1Used, float q2Used, int q1Prior, int q2Prior) {
            int rc;
            int p1 = 0;
            int p2 = 0;
            if (PriorityUtilizationQueueOrderingPolicy.this.respectPriority) {
                p1 = q1Prior;
                p2 = q2Prior;
            }
            if (0 == (rc = PriorityUtilizationQueueOrderingPolicy.compare(q1Used, q2Used, p1, p2))) {
                Resource minEffRes1 = q1Sort.configuredMinResource;
                Resource minEffRes2 = q2Sort.configuredMinResource;
                if (!minEffRes1.equals((Object)Resources.none()) || !minEffRes2.equals((Object)Resources.none())) {
                    return minEffRes2.compareTo(minEffRes1);
                }
                float abs1 = q1Sort.absoluteCapacity;
                float abs2 = q2Sort.absoluteCapacity;
                return Float.compare(abs2, abs1);
            }
            return rc;
        }

        private int compareQueueAccessToPartition(boolean q1Accessible, boolean q2Accessible) {
            if (StringUtils.equals((CharSequence)this.partition, (CharSequence)"")) {
                return 0;
            }
            if (q1Accessible && !q2Accessible) {
                return -1;
            }
            if (!q1Accessible && q2Accessible) {
                return 1;
            }
            return 0;
        }
    }
}

