/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.router.PeriodicService;
import org.apache.hadoop.hdfs.server.federation.router.RBFConfigKeys;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.store.CachedRecordStore;
import org.apache.hadoop.hdfs.server.federation.store.MembershipStore;
import org.apache.hadoop.hdfs.server.federation.store.MountTableStore;
import org.apache.hadoop.hdfs.server.federation.store.RecordStore;
import org.apache.hadoop.hdfs.server.federation.store.RouterStore;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreService;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RouterHeartbeatRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RouterHeartbeatResponse;
import org.apache.hadoop.hdfs.server.federation.store.records.BaseRecord;
import org.apache.hadoop.hdfs.server.federation.store.records.RouterState;
import org.apache.hadoop.hdfs.server.federation.store.records.StateStoreVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouterHeartbeatService
extends PeriodicService {
    private static final Logger LOG = LoggerFactory.getLogger(RouterHeartbeatService.class);
    private final Router router;

    public RouterHeartbeatService(Router router) {
        super(RouterHeartbeatService.class.getSimpleName());
        this.router = router;
    }

    protected void updateStateAsync() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                RouterHeartbeatService.this.updateStateStore();
            }
        }, "Router Heartbeat Async");
        thread.setDaemon(true);
        thread.start();
    }

    @VisibleForTesting
    synchronized void updateStateStore() {
        block6: {
            String routerId = this.router.getRouterId();
            if (routerId == null) {
                LOG.error("Cannot heartbeat for router: unknown router id");
                return;
            }
            if (this.isStoreAvailable()) {
                RouterStore routerStore = this.router.getRouterStateManager();
                try {
                    RouterState record = RouterState.newInstance(routerId, this.router.getStartTime(), this.router.getRouterState());
                    StateStoreVersion stateStoreVersion = StateStoreVersion.newInstance(this.getStateStoreVersion(MembershipStore.class), this.getStateStoreVersion(MountTableStore.class));
                    record.setStateStoreVersion(stateStoreVersion);
                    RouterHeartbeatRequest request = RouterHeartbeatRequest.newInstance(record);
                    RouterHeartbeatResponse response = routerStore.routerHeartbeat(request);
                    if (!response.getStatus()) {
                        LOG.warn("Cannot heartbeat router {}", (Object)routerId);
                        break block6;
                    }
                    LOG.debug("Router heartbeat for router {}", (Object)routerId);
                }
                catch (IOException e) {
                    LOG.error("Cannot heartbeat router {}", (Object)routerId, (Object)e);
                }
            } else {
                LOG.warn("Cannot heartbeat router {}: State Store unavailable", (Object)routerId);
            }
        }
    }

    private <R extends BaseRecord, S extends RecordStore<R>> long getStateStoreVersion(Class<S> clazz) {
        long version = -1L;
        try {
            StateStoreService stateStore = this.router.getStateStore();
            S recordStore = stateStore.getRegisteredRecordStore(clazz);
            if (recordStore != null && recordStore instanceof CachedRecordStore) {
                CachedRecordStore cachedRecordStore = (CachedRecordStore)recordStore;
                List records = cachedRecordStore.getCachedRecords();
                for (BaseRecord record : records) {
                    if (record.getDateModified() <= version) continue;
                    version = record.getDateModified();
                }
            }
        }
        catch (Exception e) {
            LOG.error("Cannot get version for {}", clazz, (Object)e);
        }
        return version;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        long interval = conf.getTimeDuration("dfs.federation.router.heartbeat-state.interval", RBFConfigKeys.DFS_ROUTER_HEARTBEAT_STATE_INTERVAL_MS_DEFAULT, TimeUnit.MILLISECONDS);
        this.setIntervalMs(interval);
        super.serviceInit(conf);
    }

    @Override
    public void periodicInvoke() {
        this.updateStateStore();
    }

    private boolean isStoreAvailable() {
        if (this.router.getRouterStateManager() == null) {
            return false;
        }
        if (this.router.getStateStore() == null) {
            return false;
        }
        return this.router.getStateStore().isDriverReady();
    }
}

