/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import com.google.common.base.Supplier;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.StateStoreDFSCluster;
import org.apache.hadoop.hdfs.server.federation.resolver.ActiveNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableManager;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.resolver.order.DestinationOrder;
import org.apache.hadoop.hdfs.server.federation.router.Quota;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterClient;
import org.apache.hadoop.hdfs.server.federation.router.RouterQuotaUsage;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.federation.router.RouterServiceState;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreService;
import org.apache.hadoop.hdfs.server.federation.store.impl.DisabledNameserviceStoreImpl;
import org.apache.hadoop.hdfs.server.federation.store.impl.MountTableStoreImpl;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesResponse;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.hadoop.hdfs.tools.federation.RouterAdmin;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.Whitebox;

public class TestRouterAdminCLI {
    private static StateStoreDFSCluster cluster;
    private static MiniRouterDFSCluster.RouterContext routerContext;
    private static StateStoreService stateStore;
    private static RouterAdmin admin;
    private static RouterClient client;
    private static final String TEST_USER = "test-user";
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();
    private final ByteArrayOutputStream err = new ByteArrayOutputStream();
    private static final PrintStream OLD_OUT;
    private static final PrintStream OLD_ERR;

    @BeforeClass
    public static void globalSetUp() throws Exception {
        cluster = new StateStoreDFSCluster(false, 1);
        Configuration conf = new RouterConfigBuilder().stateStore().admin().rpc().safemode().build();
        cluster.addRouterOverrides(conf);
        cluster.startRouters();
        routerContext = cluster.getRandomRouter();
        Router router = routerContext.getRouter();
        stateStore = router.getStateStore();
        Configuration routerConf = new Configuration();
        InetSocketAddress routerSocket = router.getAdminServerAddress();
        routerConf.setSocketAddr("dfs.federation.router.admin-address", routerSocket);
        admin = new RouterAdmin(routerConf);
        client = routerContext.getAdminClient();
        ActiveNamenodeResolver membership = router.getNamenodeResolver();
        membership.registerNamenode(FederationTestUtils.createNamenodeReport("ns0", "nn1", HAServiceProtocol.HAServiceState.ACTIVE));
        membership.registerNamenode(FederationTestUtils.createNamenodeReport("ns1", "nn1", HAServiceProtocol.HAServiceState.ACTIVE));
        stateStore.refreshCaches(true);
        Quota quota = (Quota)Mockito.spy((Object)routerContext.getRouter().createRpcServer().getQuotaModule());
        ((Quota)Mockito.doNothing().when((Object)quota)).setQuota(Mockito.anyString(), Mockito.anyLong(), Mockito.anyLong(), (StorageType)Mockito.any());
        Whitebox.setInternalState((Object)routerContext.getRouter().getRpcServer(), (String)"quotaCall", (Object)quota);
        RouterRpcServer spyRpcServer = (RouterRpcServer)Mockito.spy((Object)routerContext.getRouter().createRpcServer());
        Whitebox.setInternalState((Object)routerContext.getRouter(), (String)"rpcServer", (Object)spyRpcServer);
        ((RouterRpcServer)Mockito.doReturn(null).when((Object)spyRpcServer)).getFileInfo(Mockito.anyString());
    }

    @AfterClass
    public static void tearDownCluster() {
        cluster.stopRouter(routerContext);
        cluster.shutdown();
        cluster = null;
    }

    @After
    public void tearDown() {
        System.setOut(OLD_OUT);
        System.setErr(OLD_ERR);
    }

    @Test
    public void testAddMountTable() throws Exception {
        String nsId = "ns0";
        String src = "/test-addmounttable";
        String dest = "/addmounttable";
        String[] argv = new String[]{"-add", src, nsId, dest};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        GetMountTableEntriesRequest getRequest = GetMountTableEntriesRequest.newInstance((String)src);
        GetMountTableEntriesResponse getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        MountTable mountTable = (MountTable)getResponse.getEntries().get(0);
        List destinations = mountTable.getDestinations();
        Assert.assertEquals((long)1L, (long)destinations.size());
        Assert.assertEquals((Object)src, (Object)mountTable.getSourcePath());
        Assert.assertEquals((Object)nsId, (Object)((RemoteLocation)destinations.get(0)).getNameserviceId());
        Assert.assertEquals((Object)dest, (Object)((RemoteLocation)destinations.get(0)).getDest());
        Assert.assertFalse((boolean)mountTable.isReadOnly());
        dest = dest + "-new";
        argv = new String[]{"-add", src, nsId, dest, "-readonly"};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        mountTable = (MountTable)getResponse.getEntries().get(0);
        Assert.assertEquals((long)2L, (long)mountTable.getDestinations().size());
        Assert.assertEquals((Object)nsId, (Object)((RemoteLocation)mountTable.getDestinations().get(1)).getNameserviceId());
        Assert.assertEquals((Object)dest, (Object)((RemoteLocation)mountTable.getDestinations().get(1)).getDest());
        Assert.assertTrue((boolean)mountTable.isReadOnly());
    }

    @Test
    public void testAddMountTableNotNormalized() throws Exception {
        String nsId = "ns0";
        String src = "/test-addmounttable-notnormalized";
        String srcWithSlash = src + "/";
        String dest = "/addmounttable-notnormalized";
        String[] argv = new String[]{"-add", srcWithSlash, nsId, dest};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        GetMountTableEntriesRequest getRequest = GetMountTableEntriesRequest.newInstance((String)src);
        GetMountTableEntriesResponse getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        MountTable mountTable = (MountTable)getResponse.getEntries().get(0);
        List destinations = mountTable.getDestinations();
        Assert.assertEquals((long)1L, (long)destinations.size());
        Assert.assertEquals((Object)src, (Object)mountTable.getSourcePath());
        Assert.assertEquals((Object)nsId, (Object)((RemoteLocation)destinations.get(0)).getNameserviceId());
        Assert.assertEquals((Object)dest, (Object)((RemoteLocation)destinations.get(0)).getDest());
        Assert.assertFalse((boolean)mountTable.isReadOnly());
        dest = dest + "-new";
        argv = new String[]{"-add", srcWithSlash, nsId, dest, "-readonly"};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        mountTable = (MountTable)getResponse.getEntries().get(0);
        Assert.assertEquals((long)2L, (long)mountTable.getDestinations().size());
        Assert.assertEquals((Object)nsId, (Object)((RemoteLocation)mountTable.getDestinations().get(1)).getNameserviceId());
        Assert.assertEquals((Object)dest, (Object)((RemoteLocation)mountTable.getDestinations().get(1)).getDest());
        Assert.assertTrue((boolean)mountTable.isReadOnly());
    }

    @Test
    public void testAddOrderMountTable() throws Exception {
        this.testAddOrderMountTable(DestinationOrder.HASH);
        this.testAddOrderMountTable(DestinationOrder.LOCAL);
        this.testAddOrderMountTable(DestinationOrder.RANDOM);
        this.testAddOrderMountTable(DestinationOrder.HASH_ALL);
    }

    private void testAddOrderMountTable(DestinationOrder order) throws Exception {
        String mnt = "/" + order;
        String nsId = "ns0,ns1";
        String dest = "/";
        String[] argv = new String[]{"-add", mnt, "ns0,ns1", "/", "-order", order.toString()};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        MountTableManager mountTable = client.getMountTableManager();
        GetMountTableEntriesRequest request = GetMountTableEntriesRequest.newInstance((String)mnt);
        GetMountTableEntriesResponse response = mountTable.getMountTableEntries(request);
        List entries = response.getEntries();
        Assert.assertEquals((long)1L, (long)entries.size());
        Assert.assertEquals((long)2L, (long)((MountTable)entries.get(0)).getDestinations().size());
        Assert.assertEquals((Object)order, (Object)((MountTable)response.getEntries().get(0)).getDestOrder());
    }

    @Test
    public void testListMountTable() throws Exception {
        String nsId = "ns0";
        String src = "/test-lsmounttable";
        String srcWithSlash = src + "/";
        String dest = "/lsmounttable";
        String[] argv = new String[]{"-add", src, nsId, dest};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        System.setOut(new PrintStream(this.out));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        argv = new String[]{"-ls", src};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        Assert.assertTrue((boolean)this.out.toString().contains(src));
        argv = new String[]{"-ls", srcWithSlash};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        Assert.assertTrue((boolean)this.out.toString().contains(src));
        this.out.reset();
        GetMountTableEntriesRequest getRequest = GetMountTableEntriesRequest.newInstance((String)"/");
        GetMountTableEntriesResponse getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        argv = new String[]{"-ls"};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        Assert.assertTrue((boolean)this.out.toString().contains(src));
        String outStr = this.out.toString();
        for (MountTable entry : getResponse.getEntries()) {
            Assert.assertTrue((boolean)outStr.contains(entry.getSourcePath()));
        }
    }

    @Test
    public void testRemoveMountTable() throws Exception {
        String nsId = "ns0";
        String src = "/test-rmmounttable";
        String dest = "/rmmounttable";
        String[] argv = new String[]{"-add", src, nsId, dest};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        GetMountTableEntriesRequest getRequest = GetMountTableEntriesRequest.newInstance((String)src);
        GetMountTableEntriesResponse getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        MountTable mountTable = (MountTable)getResponse.getEntries().get(0);
        Assert.assertEquals((Object)src, (Object)mountTable.getSourcePath());
        argv = new String[]{"-rm", src};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        Assert.assertEquals((long)0L, (long)getResponse.getEntries().size());
        String invalidPath = "/invalid";
        System.setOut(new PrintStream(this.out));
        argv = new String[]{"-rm", invalidPath};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        Assert.assertTrue((boolean)this.out.toString().contains("Cannot remove mount point " + invalidPath));
    }

    @Test
    public void testRemoveMountTableNotNormalized() throws Exception {
        String nsId = "ns0";
        String src = "/test-rmmounttable-notnormalized";
        String srcWithSlash = src + "/";
        String dest = "/rmmounttable-notnormalized";
        String[] argv = new String[]{"-add", src, nsId, dest};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        GetMountTableEntriesRequest getRequest = GetMountTableEntriesRequest.newInstance((String)src);
        GetMountTableEntriesResponse getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        MountTable mountTable = (MountTable)getResponse.getEntries().get(0);
        Assert.assertEquals((Object)src, (Object)mountTable.getSourcePath());
        argv = new String[]{"-rm", srcWithSlash};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        Assert.assertEquals((long)0L, (long)getResponse.getEntries().size());
    }

    @Test
    public void testMountTableDefaultACL() throws Exception {
        String[] argv = new String[]{"-add", "/testpath0", "ns0", "/testdir0"};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        GetMountTableEntriesRequest getRequest = GetMountTableEntriesRequest.newInstance((String)"/testpath0");
        GetMountTableEntriesResponse getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        MountTable mountTable = (MountTable)getResponse.getEntries().get(0);
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        String group = ugi.getGroups().isEmpty() ? ugi.getShortUserName() : ugi.getPrimaryGroupName();
        Assert.assertEquals((Object)ugi.getShortUserName(), (Object)mountTable.getOwnerName());
        Assert.assertEquals((Object)group, (Object)mountTable.getGroupName());
        Assert.assertEquals((long)493L, (long)mountTable.getMode().toShort());
    }

    @Test
    public void testMountTablePermissions() throws Exception {
        System.setOut(new PrintStream(this.out));
        String[] argv = new String[]{"-add", "/testpath2-1", "ns0", "/testdir2-1", "-owner", TEST_USER, "-group", TEST_USER, "-mode", "0455"};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        String superUser = UserGroupInformation.getCurrentUser().getShortUserName();
        UserGroupInformation remoteUser = UserGroupInformation.createRemoteUser((String)TEST_USER);
        UserGroupInformation.setLoginUser((UserGroupInformation)remoteUser);
        this.verifyExecutionResult("/testpath2-1", true, -1, -1);
        argv = new String[]{"-add", "/testpath2-2", "ns0", "/testdir2-2", "-owner", TEST_USER, "-group", TEST_USER, "-mode", "0255"};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        this.verifyExecutionResult("/testpath2-2", false, 0, 0);
        argv = new String[]{"-add", "/testpath2-3", "ns0", "/testdir2-3", "-owner", TEST_USER, "-group", TEST_USER, "-mode", "0755"};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        this.verifyExecutionResult("/testpath2-3", true, 0, 0);
        remoteUser = UserGroupInformation.createRemoteUser((String)superUser);
        UserGroupInformation.setLoginUser((UserGroupInformation)remoteUser);
    }

    private void verifyExecutionResult(String mount, boolean canRead, int addCommandCode, int rmCommandCode) throws Exception {
        String[] argv = null;
        stateStore.loadCache(MountTableStoreImpl.class, true);
        this.out.reset();
        argv = new String[]{"-ls", mount};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        Assert.assertEquals((Object)canRead, (Object)this.out.toString().contains(mount));
        argv = new String[]{"-add", mount, "ns0", mount + "newdir"};
        Assert.assertEquals((long)addCommandCode, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        argv = new String[]{"-rm", mount};
        Assert.assertEquals((long)rmCommandCode, (long)ToolRunner.run((Tool)admin, (String[])argv));
    }

    @Test
    public void testSetAndClearQuota() throws Exception {
        String nsId = "ns0";
        String src = "/test-QuotaMounttable";
        String dest = "/QuotaMounttable";
        String[] argv = new String[]{"-add", src, nsId, dest};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        GetMountTableEntriesRequest getRequest = GetMountTableEntriesRequest.newInstance((String)src);
        GetMountTableEntriesResponse getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        MountTable mountTable = (MountTable)getResponse.getEntries().get(0);
        RouterQuotaUsage quotaUsage = mountTable.getQuota();
        Assert.assertEquals((long)0L, (long)quotaUsage.getFileAndDirectoryCount());
        Assert.assertEquals((long)-1L, (long)quotaUsage.getQuota());
        Assert.assertEquals((long)0L, (long)quotaUsage.getSpaceConsumed());
        Assert.assertEquals((long)-1L, (long)quotaUsage.getSpaceQuota());
        long nsQuota = 50L;
        long ssQuota = 100L;
        argv = new String[]{"-setQuota", src, "-nsQuota", String.valueOf(nsQuota), "-ssQuota", String.valueOf(ssQuota)};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        mountTable = (MountTable)getResponse.getEntries().get(0);
        quotaUsage = mountTable.getQuota();
        Assert.assertEquals((long)nsQuota, (long)quotaUsage.getQuota());
        Assert.assertEquals((long)ssQuota, (long)quotaUsage.getSpaceQuota());
        String newSsQuota = "2m";
        argv = new String[]{"-setQuota", src, "-ssQuota", newSsQuota};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        mountTable = (MountTable)getResponse.getEntries().get(0);
        quotaUsage = mountTable.getQuota();
        Assert.assertEquals((long)nsQuota, (long)quotaUsage.getQuota());
        Assert.assertEquals((long)0x200000L, (long)quotaUsage.getSpaceQuota());
        argv = new String[]{"-clrQuota", src};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        mountTable = (MountTable)getResponse.getEntries().get(0);
        quotaUsage = mountTable.getQuota();
        Assert.assertEquals((long)-1L, (long)quotaUsage.getQuota());
        Assert.assertEquals((long)-1L, (long)quotaUsage.getSpaceQuota());
    }

    @Test
    public void testManageSafeMode() throws Exception {
        this.waitState(RouterServiceState.RUNNING);
        Assert.assertFalse((boolean)routerContext.getRouter().getSafemodeService().isInSafeMode());
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])new String[]{"-safemode", "enter"}));
        Assert.assertEquals((Object)RouterServiceState.SAFEMODE, (Object)routerContext.getRouter().getRouterState());
        Assert.assertTrue((boolean)routerContext.getRouter().getSafemodeService().isInSafeMode());
        System.setOut(new PrintStream(this.out));
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])new String[]{"-safemode", "get"}));
        Assert.assertTrue((boolean)this.out.toString().contains("true"));
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])new String[]{"-safemode", "leave"}));
        Assert.assertEquals((Object)RouterServiceState.RUNNING, (Object)routerContext.getRouter().getRouterState());
        Assert.assertFalse((boolean)routerContext.getRouter().getSafemodeService().isInSafeMode());
        this.out.reset();
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])new String[]{"-safemode", "get"}));
        Assert.assertTrue((boolean)this.out.toString().contains("false"));
    }

    @Test
    public void testCreateInvalidEntry() throws Exception {
        String[] argv = new String[]{"-add", "test-createInvalidEntry", "ns0", "/createInvalidEntry"};
        Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        argv = new String[]{"-add", "/test-createInvalidEntry", "ns0", "createInvalidEntry"};
        Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        argv = new String[]{"-add", null, "ns0", "/createInvalidEntry"};
        Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        argv = new String[]{"-add", "/test-createInvalidEntry", "ns0", null};
        Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        argv = new String[]{"-add", "", "ns0", "/createInvalidEntry"};
        Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        argv = new String[]{"-add", "/test-createInvalidEntry", null, "/createInvalidEntry"};
        Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        argv = new String[]{"-add", "/test-createInvalidEntry", "", "/createInvalidEntry"};
        Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)admin, (String[])argv));
    }

    @Test
    public void testNameserviceManager() throws Exception {
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])new String[]{"-nameservice", "disable", "ns0"}));
        stateStore.loadCache(DisabledNameserviceStoreImpl.class, true);
        System.setOut(new PrintStream(this.out));
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])new String[]{"-getDisabledNameservices"}));
        Assert.assertTrue((String)("ns0 should be reported: " + this.out), (boolean)this.out.toString().contains("ns0"));
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])new String[]{"-nameservice", "enable", "ns0"}));
        this.out.reset();
        stateStore.loadCache(DisabledNameserviceStoreImpl.class, true);
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])new String[]{"-getDisabledNameservices"}));
        Assert.assertFalse((String)("ns0 should not be reported: " + this.out), (boolean)this.out.toString().contains("ns0"));
        System.setErr(new PrintStream(this.err));
        Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)admin, (String[])new String[]{"-nameservice", "enable"}));
        String msg = "Not enough parameters specificed for cmd -nameservice";
        Assert.assertTrue((String)("Got error: " + this.err.toString()), (boolean)this.err.toString().startsWith(msg));
        this.err.reset();
        Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)admin, (String[])new String[]{"-nameservice", "wrong", "ns0"}));
        Assert.assertTrue((String)("Got error: " + this.err.toString()), (boolean)this.err.toString().startsWith("nameservice: Unknown command: wrong"));
    }

    private void waitState(final RouterServiceState expectedState) throws Exception {
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                return expectedState == routerContext.getRouter().getRouterState();
            }
        }, (int)1000, (int)30000);
    }

    @Test
    public void testUpdateNonExistingMountTable() throws Exception {
        System.setOut(new PrintStream(this.out));
        String nsId = "ns0";
        String src = "/test-updateNonExistingMounttable";
        String dest = "/updateNonExistingMounttable";
        String[] argv = new String[]{"-update", src, nsId, dest};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        GetMountTableEntriesRequest getRequest = GetMountTableEntriesRequest.newInstance((String)src);
        GetMountTableEntriesResponse getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        MountTable mountTable = (MountTable)getResponse.getEntries().get(0);
        Assert.assertEquals((Object)src, (Object)mountTable.getSourcePath());
        Assert.assertEquals((Object)nsId, (Object)((RemoteLocation)mountTable.getDestinations().get(0)).getNameserviceId());
        Assert.assertEquals((Object)dest, (Object)((RemoteLocation)mountTable.getDestinations().get(0)).getDest());
    }

    @Test
    public void testUpdateDestinationForExistingMountTable() throws Exception {
        String nsId = "ns0";
        String src = "/test-updateDestinationForExistingMountTable";
        String dest = "/UpdateDestinationForExistingMountTable";
        String[] argv = new String[]{"-add", src, nsId, dest};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        GetMountTableEntriesRequest getRequest = GetMountTableEntriesRequest.newInstance((String)src);
        GetMountTableEntriesResponse getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        MountTable mountTable = (MountTable)getResponse.getEntries().get(0);
        Assert.assertEquals((Object)src, (Object)mountTable.getSourcePath());
        Assert.assertEquals((Object)nsId, (Object)((RemoteLocation)mountTable.getDestinations().get(0)).getNameserviceId());
        Assert.assertEquals((Object)dest, (Object)((RemoteLocation)mountTable.getDestinations().get(0)).getDest());
        String newNsId = "ns1";
        String newDest = "/newDestination";
        argv = new String[]{"-update", src, newNsId, newDest};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        mountTable = (MountTable)getResponse.getEntries().get(0);
        Assert.assertEquals((Object)src, (Object)mountTable.getSourcePath());
        Assert.assertEquals((Object)newNsId, (Object)((RemoteLocation)mountTable.getDestinations().get(0)).getNameserviceId());
        Assert.assertEquals((Object)newDest, (Object)((RemoteLocation)mountTable.getDestinations().get(0)).getDest());
    }

    @Test
    public void testUpdateDestinationForExistingMountTableNotNormalized() throws Exception {
        String nsId = "ns0";
        String src = "/test-updateDestinationForExistingMountTableNotNormalized";
        String srcWithSlash = src + "/";
        String dest = "/UpdateDestinationForExistingMountTableNotNormalized";
        String[] argv = new String[]{"-add", src, nsId, dest};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        GetMountTableEntriesRequest getRequest = GetMountTableEntriesRequest.newInstance((String)src);
        GetMountTableEntriesResponse getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        MountTable mountTable = (MountTable)getResponse.getEntries().get(0);
        Assert.assertEquals((Object)src, (Object)mountTable.getSourcePath());
        Assert.assertEquals((Object)nsId, (Object)((RemoteLocation)mountTable.getDestinations().get(0)).getNameserviceId());
        Assert.assertEquals((Object)dest, (Object)((RemoteLocation)mountTable.getDestinations().get(0)).getDest());
        String newNsId = "ns1";
        String newDest = "/newDestination";
        argv = new String[]{"-update", srcWithSlash, newNsId, newDest};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        mountTable = (MountTable)getResponse.getEntries().get(0);
        Assert.assertEquals((Object)src, (Object)mountTable.getSourcePath());
        Assert.assertEquals((Object)newNsId, (Object)((RemoteLocation)mountTable.getDestinations().get(0)).getNameserviceId());
        Assert.assertEquals((Object)newDest, (Object)((RemoteLocation)mountTable.getDestinations().get(0)).getDest());
    }

    @Test
    public void testUpdateReadonlyUserGroupPermissionMountable() throws Exception {
        String nsId = "ns0";
        String src = "/test-updateReadonlyUserGroupPermissionMountTable";
        String dest = "/UpdateReadonlyUserGroupPermissionMountTable";
        String[] argv = new String[]{"-add", src, nsId, dest};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        GetMountTableEntriesRequest getRequest = GetMountTableEntriesRequest.newInstance((String)src);
        GetMountTableEntriesResponse getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        MountTable mountTable = (MountTable)getResponse.getEntries().get(0);
        Assert.assertEquals((Object)src, (Object)mountTable.getSourcePath());
        Assert.assertEquals((Object)nsId, (Object)((RemoteLocation)mountTable.getDestinations().get(0)).getNameserviceId());
        Assert.assertEquals((Object)dest, (Object)((RemoteLocation)mountTable.getDestinations().get(0)).getDest());
        Assert.assertFalse((boolean)mountTable.isReadOnly());
        String testOwner = "test_owner";
        String testGroup = "test_group";
        argv = new String[]{"-update", src, nsId, dest, "-readonly", "-owner", testOwner, "-group", testGroup, "-mode", "0455"};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        mountTable = (MountTable)getResponse.getEntries().get(0);
        Assert.assertEquals((Object)src, (Object)mountTable.getSourcePath());
        Assert.assertEquals((Object)nsId, (Object)((RemoteLocation)mountTable.getDestinations().get(0)).getNameserviceId());
        Assert.assertEquals((Object)dest, (Object)((RemoteLocation)mountTable.getDestinations().get(0)).getDest());
        Assert.assertTrue((boolean)mountTable.isReadOnly());
        Assert.assertEquals((Object)testOwner, (Object)mountTable.getOwnerName());
        Assert.assertEquals((Object)testGroup, (Object)mountTable.getGroupName());
        Assert.assertEquals((long)301L, (long)mountTable.getMode().toShort());
    }

    @Test
    public void testUpdateOrderMountTable() throws Exception {
        this.testUpdateOrderMountTable(DestinationOrder.HASH);
        this.testUpdateOrderMountTable(DestinationOrder.LOCAL);
        this.testUpdateOrderMountTable(DestinationOrder.RANDOM);
        this.testUpdateOrderMountTable(DestinationOrder.HASH_ALL);
    }

    private void testUpdateOrderMountTable(DestinationOrder order) throws Exception {
        String nsId = "ns0";
        String src = "/test-updateOrderMountTable-" + order.toString();
        String dest = "/UpdateOrderMountTable";
        String[] argv = new String[]{"-add", src, nsId, dest};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        GetMountTableEntriesRequest getRequest = GetMountTableEntriesRequest.newInstance((String)src);
        GetMountTableEntriesResponse getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        MountTable mountTable = (MountTable)getResponse.getEntries().get(0);
        Assert.assertEquals((Object)src, (Object)mountTable.getSourcePath());
        Assert.assertEquals((Object)nsId, (Object)((RemoteLocation)mountTable.getDestinations().get(0)).getNameserviceId());
        Assert.assertEquals((Object)dest, (Object)((RemoteLocation)mountTable.getDestinations().get(0)).getDest());
        Assert.assertEquals((Object)DestinationOrder.HASH, (Object)mountTable.getDestOrder());
        argv = new String[]{"-update", src, nsId, dest, "-order", order.toString()};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        mountTable = (MountTable)getResponse.getEntries().get(0);
        Assert.assertEquals((Object)src, (Object)mountTable.getSourcePath());
        Assert.assertEquals((Object)nsId, (Object)((RemoteLocation)mountTable.getDestinations().get(0)).getNameserviceId());
        Assert.assertEquals((Object)dest, (Object)((RemoteLocation)mountTable.getDestinations().get(0)).getDest());
        Assert.assertEquals((Object)order, (Object)mountTable.getDestOrder());
    }

    static {
        OLD_OUT = System.out;
        OLD_ERR = System.err;
    }
}

