/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeInfoWithStorage;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.BlocksMap;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.LowRedundancyBlocks;
import org.apache.hadoop.hdfs.server.blockmanagement.PendingReconstructionBlocks;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.ReceivedDeletedBlockInfo;
import org.apache.hadoop.hdfs.server.protocol.StorageReceivedDeletedBlocks;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.MetricsAsserts;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestPendingReconstruction {
    static final int TIMEOUT = 3;
    private static final int DFS_REPLICATION_INTERVAL = 1;
    private static final int DATANODE_COUNT = 5;

    private BlockInfo genBlockInfo(long id, long length, long gs) {
        return new BlockInfoContiguous(new Block(id, length, gs), 5);
    }

    @Test
    public void testPendingReconstruction() {
        BlockInfo block;
        int i;
        NameNode.initMetrics((Configuration)new Configuration(), (HdfsServerConstants.NamenodeRole)HdfsServerConstants.NamenodeRole.NAMENODE);
        PendingReconstructionBlocks pendingReconstructions = new PendingReconstructionBlocks(3000L);
        pendingReconstructions.start();
        DatanodeStorageInfo[] storages = DFSTestUtil.createDatanodeStorageInfos(10);
        for (int i2 = 0; i2 < storages.length; ++i2) {
            BlockInfo block2 = this.genBlockInfo(i2, i2, 0L);
            DatanodeStorageInfo[] targets = new DatanodeStorageInfo[i2];
            System.arraycopy(storages, 0, targets, 0, i2);
            pendingReconstructions.increment(block2, targets);
        }
        Assert.assertEquals((String)"Size of pendingReconstruction ", (long)10L, (long)pendingReconstructions.size());
        BlockInfo blk = this.genBlockInfo(8L, 8L, 0L);
        pendingReconstructions.decrement(blk, storages[7]);
        Assert.assertEquals((String)"pendingReconstructions.getNumReplicas ", (long)7L, (long)pendingReconstructions.getNumReplicas(blk));
        pendingReconstructions.increment(blk, new DatanodeStorageInfo[]{storages[0]});
        Assert.assertEquals((String)"pendingReconstructions.getNumReplicas ", (long)7L, (long)pendingReconstructions.getNumReplicas(blk));
        for (i = 0; i < 7; ++i) {
            pendingReconstructions.decrement(blk, storages[i]);
        }
        Assert.assertTrue((pendingReconstructions.size() == 9 ? 1 : 0) != 0);
        pendingReconstructions.increment(blk, DFSTestUtil.createDatanodeStorageInfos(8));
        Assert.assertTrue((pendingReconstructions.size() == 10 ? 1 : 0) != 0);
        for (i = 0; i < 10; ++i) {
            block = this.genBlockInfo(i, i, 0L);
            int numReplicas = pendingReconstructions.getNumReplicas(block);
            Assert.assertTrue((numReplicas == i ? 1 : 0) != 0);
        }
        Assert.assertNull((Object)pendingReconstructions.getTimedOutBlocks());
        Assert.assertEquals((long)0L, (long)pendingReconstructions.getNumTimedOuts());
        try {
            Thread.sleep(1000L);
        }
        catch (Exception i3) {
            // empty catch block
        }
        for (int i4 = 10; i4 < 15; ++i4) {
            block = this.genBlockInfo(i4, i4, 0L);
            pendingReconstructions.increment(block, DFSTestUtil.createDatanodeStorageInfos(i4));
        }
        Assert.assertEquals((long)15L, (long)pendingReconstructions.size());
        Assert.assertEquals((long)0L, (long)pendingReconstructions.getNumTimedOuts());
        int loop = 0;
        while (pendingReconstructions.size() > 0) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception block3) {
                // empty catch block
            }
            ++loop;
        }
        System.out.println("Had to wait for " + loop + " seconds for the lot to timeout");
        Assert.assertEquals((String)"Size of pendingReconstructions ", (long)0L, (long)pendingReconstructions.size());
        Assert.assertEquals((long)15L, (long)pendingReconstructions.getNumTimedOuts());
        BlockInfo[] timedOut = pendingReconstructions.getTimedOutBlocks();
        Assert.assertNotNull((Object)timedOut);
        Assert.assertEquals((long)15L, (long)timedOut.length);
        Assert.assertEquals((long)15L, (long)pendingReconstructions.getNumTimedOuts());
        for (BlockInfo block4 : timedOut) {
            Assert.assertTrue((block4.getBlockId() < 15L ? 1 : 0) != 0);
        }
        pendingReconstructions.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProcessPendingReconstructions() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.namenode.reconstruction.pending.timeout-sec", 3L);
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(5).build();
            cluster.waitActive();
            FSNamesystem fsn = cluster.getNamesystem();
            BlockManager blkManager = fsn.getBlockManager();
            PendingReconstructionBlocks pendingReconstruction = blkManager.pendingReconstruction;
            LowRedundancyBlocks neededReconstruction = blkManager.neededReconstruction;
            BlocksMap blocksMap = blkManager.blocksMap;
            Block block = new Block(1L, 1L, 0L);
            BlockInfoContiguous blockInfo = new BlockInfoContiguous(block, 3);
            pendingReconstruction.increment((BlockInfo)blockInfo, DFSTestUtil.createDatanodeStorageInfos(1));
            BlockCollection bc = (BlockCollection)Mockito.mock(BlockCollection.class);
            blockInfo.setGenerationStamp(1L);
            blocksMap.addBlockCollection((BlockInfo)blockInfo, bc);
            BlockInfoContiguous storedBlock = blockInfo;
            Assert.assertEquals((String)"Size of pendingReconstructions ", (long)1L, (long)pendingReconstruction.size());
            block = new Block(2L, 2L, 0L);
            blockInfo = new BlockInfoContiguous(block, 3);
            pendingReconstruction.increment((BlockInfo)blockInfo, DFSTestUtil.createDatanodeStorageInfos(1));
            Assert.assertEquals((String)"Size of pendingReconstructions ", (long)2L, (long)pendingReconstruction.size());
            while (pendingReconstruction.size() > 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
            while (neededReconstruction.size() == 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
            for (Block b : neededReconstruction) {
                Assert.assertEquals((String)"Generation stamp is 1 ", (long)1L, (long)b.getGenerationStamp());
            }
            Assert.assertEquals((String)"size of neededReconstruction is 1 ", (long)1L, (long)neededReconstruction.size());
            BlockManagerTestUtil.stopRedundancyThread(blkManager);
            pendingReconstruction.clear();
            DatanodeDescriptor[] desc = new DatanodeDescriptor[]{(DatanodeDescriptor)blkManager.getDatanodeManager().getDatanodes().iterator().next()};
            pendingReconstruction.increment((BlockInfo)blockInfo, DFSTestUtil.createDatanodeStorageInfos(1));
            Assert.assertEquals((String)"Size of pendingReconstructions ", (long)1L, (long)pendingReconstruction.size());
            fsn.writeLock();
            try {
                blkManager.addBlock(desc[0].getStorageInfos()[0], new Block(1L, 1L, 0L), null);
            }
            finally {
                fsn.writeUnlock();
            }
            Assert.assertEquals((String)"Size of pendingReconstructions ", (long)1L, (long)pendingReconstruction.size());
            fsn.writeLock();
            try {
                blkManager.addBlock(desc[0].getStorageInfos()[0], new Block(1L, 1L, 1L), null);
            }
            finally {
                fsn.writeUnlock();
            }
            GenericTestUtils.waitFor(() -> pendingReconstruction.size() == 0, (long)500L, (long)10000L);
            Assert.assertEquals((String)"Size of pendingReconstructions ", (long)0L, (long)pendingReconstruction.size());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlockReceived() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blocksize", 1024L);
        MiniDFSCluster cluster = null;
        try {
            StorageReceivedDeletedBlocks[] report;
            DatanodeRegistration dnR;
            int i;
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(5).build();
            cluster.waitActive();
            DistributedFileSystem hdfs = cluster.getFileSystem();
            FSNamesystem fsn = cluster.getNamesystem();
            BlockManager blkManager = fsn.getBlockManager();
            String file = "/tmp.txt";
            Path filePath = new Path("/tmp.txt");
            short replFactor = 1;
            DFSTestUtil.createFile((FileSystem)hdfs, filePath, 1024L, replFactor, 0L);
            ArrayList<DataNode> datanodes = cluster.getDataNodes();
            for (int i2 = 0; i2 < 5; ++i2) {
                DataNodeTestUtils.setHeartbeatsDisabledForTests(datanodes.get(i2), true);
            }
            hdfs.setReplication(filePath, (short)5);
            BlockManagerTestUtil.computeAllPendingWork(blkManager);
            Assert.assertEquals((long)1L, (long)blkManager.pendingReconstruction.size());
            INodeFile fileNode = fsn.getFSDirectory().getINode4Write("/tmp.txt").asFile();
            BlockInfo[] blocks = fileNode.getBlocks();
            Assert.assertEquals((long)4L, (long)blkManager.pendingReconstruction.getNumReplicas(blocks[0]));
            LocatedBlock locatedBlock = hdfs.getClient().getLocatedBlocks("/tmp.txt", 0L).get(0);
            DatanodeInfoWithStorage existingDn = locatedBlock.getLocations()[0];
            int reportDnNum = 0;
            String poolId = cluster.getNamesystem().getBlockPoolId();
            for (i = 0; i < 5 && reportDnNum < 2; ++i) {
                if (datanodes.get(i).getDatanodeId().equals((Object)existingDn)) continue;
                dnR = datanodes.get(i).getDNRegistrationForBP(poolId);
                report = new StorageReceivedDeletedBlocks[]{new StorageReceivedDeletedBlocks(new DatanodeStorage("Fake-storage-ID-Ignored"), new ReceivedDeletedBlockInfo[]{new ReceivedDeletedBlockInfo((Block)blocks[0], ReceivedDeletedBlockInfo.BlockStatus.RECEIVED_BLOCK, "")})};
                cluster.getNameNodeRpc().blockReceivedAndDeleted(dnR, poolId, report);
                ++reportDnNum;
            }
            cluster.getNamesystem().getBlockManager().flushBlockOps();
            Assert.assertEquals((long)2L, (long)blkManager.pendingReconstruction.getNumReplicas(blocks[0]));
            for (i = 0; i < 5 && reportDnNum < 2; ++i) {
                if (datanodes.get(i).getDatanodeId().equals((Object)existingDn)) continue;
                dnR = datanodes.get(i).getDNRegistrationForBP(poolId);
                report = new StorageReceivedDeletedBlocks[]{new StorageReceivedDeletedBlocks(new DatanodeStorage("Fake-storage-ID-Ignored"), new ReceivedDeletedBlockInfo[]{new ReceivedDeletedBlockInfo((Block)blocks[0], ReceivedDeletedBlockInfo.BlockStatus.RECEIVED_BLOCK, "")})};
                cluster.getNameNodeRpc().blockReceivedAndDeleted(dnR, poolId, report);
                ++reportDnNum;
            }
            cluster.getNamesystem().getBlockManager().flushBlockOps();
            Assert.assertEquals((long)2L, (long)blkManager.pendingReconstruction.getNumReplicas(blocks[0]));
            for (i = 0; i < 5; ++i) {
                DataNodeTestUtils.setHeartbeatsDisabledForTests(datanodes.get(i), false);
                DataNodeTestUtils.triggerHeartbeat(datanodes.get(i));
            }
            Thread.sleep(5000L);
            Assert.assertEquals((long)0L, (long)blkManager.pendingReconstruction.size());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPendingAndInvalidate() throws Exception {
        HdfsConfiguration CONF = new HdfsConfiguration();
        CONF.setLong("dfs.blocksize", 1024L);
        CONF.setLong("dfs.heartbeat.interval", 1L);
        CONF.setInt("dfs.namenode.redundancy.interval.seconds", 1);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)CONF).numDataNodes(5).build();
        cluster.waitActive();
        FSNamesystem namesystem = cluster.getNamesystem();
        BlockManager bm = namesystem.getBlockManager();
        DistributedFileSystem fs = cluster.getFileSystem();
        try {
            Path filePath = new Path("/tmp.txt");
            DFSTestUtil.createFile((FileSystem)fs, filePath, 1024L, (short)3, 0L);
            DFSTestUtil.waitForReplication(cluster.getFileSystem(), filePath, (short)3, 10000);
            for (DataNode dn : cluster.getDataNodes()) {
                DataNodeTestUtils.setHeartbeatsDisabledForTests(dn, true);
            }
            LocatedBlock block = NameNodeAdapter.getBlockLocations(cluster.getNameNode(), filePath.toString(), 0L, 1L).get(0);
            cluster.getNamesystem().writeLock();
            try {
                bm.findAndMarkBlockAsCorrupt(block.getBlock(), (DatanodeInfo)block.getLocations()[0], "STORAGE_ID", "TEST");
                bm.findAndMarkBlockAsCorrupt(block.getBlock(), (DatanodeInfo)block.getLocations()[1], "STORAGE_ID", "TEST");
                BlockManagerTestUtil.computeAllPendingWork(bm);
                BlockManagerTestUtil.updateState(bm);
                Assert.assertEquals((long)bm.getPendingReconstructionBlocksCount(), (long)1L);
                BlockInfo storedBlock = bm.getStoredBlock(block.getBlock().getLocalBlock());
                Assert.assertEquals((long)bm.pendingReconstruction.getNumReplicas(storedBlock), (long)2L);
            }
            finally {
                cluster.getNamesystem().writeUnlock();
            }
            fs.delete(filePath, true);
            int retries = 10;
            long pendingNum = bm.getPendingReconstructionBlocksCount();
            while (pendingNum != 0L && retries-- > 0) {
                Thread.sleep(1000L);
                BlockManagerTestUtil.updateState(bm);
                pendingNum = bm.getPendingReconstructionBlocksCount();
            }
            Assert.assertEquals((long)pendingNum, (long)0L);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testReplicationCounter() throws IOException, InterruptedException, TimeoutException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.redundancy.interval.seconds", 1);
        conf.setInt("dfs.namenode.reconstruction.pending.timeout-sec", 1);
        MiniDFSCluster tmpCluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(5).build();
        tmpCluster.waitActive();
        FSNamesystem fsn = tmpCluster.getNamesystem(0);
        fsn.writeLock();
        try {
            BlockManager bm = fsn.getBlockManager();
            BlocksMap blocksMap = bm.blocksMap;
            BlockCollection bc0 = (BlockCollection)Mockito.mock(BlockCollection.class);
            BlockInfoContiguous blockInfo0 = new BlockInfoContiguous(3);
            blockInfo0.setBlockId(0L);
            BlockCollection bc1 = (BlockCollection)Mockito.mock(BlockCollection.class);
            BlockInfoContiguous blockInfo1 = new BlockInfoContiguous(3);
            blockInfo1.setBlockId(1L);
            BlockCollection bc2 = (BlockCollection)Mockito.mock(BlockCollection.class);
            BlockInfoContiguous blockInfo2 = new BlockInfoContiguous(3);
            blockInfo2.setBlockId(2L);
            blocksMap.addBlockCollection((BlockInfo)blockInfo0, bc0);
            blocksMap.addBlockCollection((BlockInfo)blockInfo1, bc1);
            blocksMap.addBlockCollection((BlockInfo)blockInfo2, bc2);
            PendingReconstructionBlocks pending = bm.pendingReconstruction;
            MetricsRecordBuilder rb = MetricsAsserts.getMetrics((String)"NameNodeActivity");
            MetricsAsserts.assertCounter((String)"SuccessfulReReplications", (long)0L, (MetricsRecordBuilder)rb);
            MetricsAsserts.assertCounter((String)"NumTimesReReplicationNotScheduled", (long)0L, (MetricsRecordBuilder)rb);
            MetricsAsserts.assertCounter((String)"TimeoutReReplications", (long)0L, (MetricsRecordBuilder)rb);
            pending.increment((BlockInfo)blockInfo0, new DatanodeStorageInfo[0]);
            pending.increment((BlockInfo)blockInfo1, new DatanodeStorageInfo[0]);
            DatanodeStorageInfo[] storageInfos = DFSTestUtil.createDatanodeStorageInfos(1);
            bm.addBlock(storageInfos[0], (Block)blockInfo0, null);
            bm.scheduleReconstruction((BlockInfo)blockInfo2, 0);
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    MetricsRecordBuilder rb = MetricsAsserts.getMetrics((String)"NameNodeActivity");
                    return MetricsAsserts.getLongCounter((String)"SuccessfulReReplications", (MetricsRecordBuilder)rb) == 1L && MetricsAsserts.getLongCounter((String)"NumTimesReReplicationNotScheduled", (MetricsRecordBuilder)rb) == 1L && MetricsAsserts.getLongCounter((String)"TimeoutReReplications", (MetricsRecordBuilder)rb) == 1L;
                }
            }, (long)100L, (long)60000L);
        }
        finally {
            tmpCluster.shutdown();
            fsn.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPendingReConstructionBlocksForSameDN() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.replication", 1);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        cluster.waitActive();
        DFSTestUtil.setNameNodeLogLevel(Level.DEBUG);
        GenericTestUtils.LogCapturer logs = GenericTestUtils.LogCapturer.captureLogs((Logger)LoggerFactory.getLogger((String)"BlockStateChange"));
        BlockManager bm = cluster.getNamesystem().getBlockManager();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path filePath = new Path("/tmp.txt");
            DFSTestUtil.createFile((FileSystem)dfs, filePath, 1024L, (short)1, 0L);
            for (DataNode dn : cluster.getDataNodes()) {
                DataNodeTestUtils.pauseIBR(dn);
            }
            DatanodeManager datanodeManager = cluster.getNamesystem().getBlockManager().getDatanodeManager();
            ArrayList dnList = new ArrayList();
            datanodeManager.fetchDatanodes(dnList, dnList, false);
            LocatedBlock block = NameNodeAdapter.getBlockLocations(cluster.getNameNode(), filePath.toString(), 0L, 1L).get(0);
            dfs.setReplication(filePath, (short)3);
            BlockManagerTestUtil.computeAllPendingWork(bm);
            BlockManagerTestUtil.computeAllPendingWork(bm);
            BlockManagerTestUtil.updateState(bm);
            String blockName = "to replicate " + block.getBlock().getLocalBlock().toString();
            Assert.assertEquals((long)1L, (long)StringUtils.countMatches((String)logs.getOutput(), (String)blockName));
        }
        finally {
            cluster.shutdown();
        }
    }
}

