/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.io.IOUtils;
import org.junit.After;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestXAttrConfigFlag {
    private static final Path PATH = new Path("/path");
    private MiniDFSCluster cluster;
    private DistributedFileSystem fs;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @After
    public void shutdown() throws Exception {
        IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{this.fs});
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    public void testSetXAttr() throws Exception {
        this.initCluster(true, false);
        this.fs.mkdirs(PATH);
        this.expectException();
        this.fs.setXAttr(PATH, "user.foo", null);
    }

    @Test
    public void testGetXAttrs() throws Exception {
        this.initCluster(true, false);
        this.fs.mkdirs(PATH);
        this.expectException();
        this.fs.getXAttrs(PATH);
    }

    @Test
    public void testRemoveXAttr() throws Exception {
        this.initCluster(true, false);
        this.fs.mkdirs(PATH);
        this.expectException();
        this.fs.removeXAttr(PATH, "user.foo");
    }

    @Test
    public void testEditLog() throws Exception {
        this.initCluster(true, true);
        this.fs.mkdirs(PATH);
        this.fs.setXAttr(PATH, "user.foo", null);
        this.restart(false, false);
    }

    @Test
    public void testFsImage() throws Exception {
        this.initCluster(true, true);
        this.fs.mkdirs(PATH);
        this.fs.setXAttr(PATH, "user.foo", null);
        this.restart(true, true);
        this.restart(false, false);
    }

    private void expectException() {
        this.exception.expect(IOException.class);
        this.exception.expectMessage("dfs.namenode.xattrs.enabled");
    }

    private void initCluster(boolean format, boolean xattrsEnabled) throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.namenode.xattrs.enabled", xattrsEnabled);
        this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).format(format).build();
        this.cluster.waitActive();
        this.fs = this.cluster.getFileSystem();
    }

    private void restart(boolean checkpoint, boolean xattrsEnabled) throws Exception {
        NameNode nameNode = this.cluster.getNameNode();
        if (checkpoint) {
            NameNodeAdapter.enterSafeMode(nameNode, false);
            NameNodeAdapter.saveNamespace(nameNode);
        }
        this.shutdown();
        this.initCluster(false, xattrsEnabled);
    }
}

