/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.pipeline;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.util.concurrent.EventExecutorGroup;
import io.reactivex.netty.channel.ChannelMetricEventProvider;
import io.reactivex.netty.metrics.BytesInspector;
import io.reactivex.netty.metrics.MetricEventsSubject;
import io.reactivex.netty.pipeline.ObservableAdapter;
import io.reactivex.netty.pipeline.PipelineConfigurator;
import io.reactivex.netty.pipeline.PrimitiveConversionHandler;

public abstract class RxRequiredConfigurator<I, O>
implements PipelineConfigurator<I, O> {
    public static final String CONN_LIFECYCLE_HANDLER_NAME = "conn_lifecycle_handler";
    public static final String BYTES_INSPECTOR_HANDLER_NAME = "bytes_inspector";
    public static final String NETTY_OBSERVABLE_ADAPTER_NAME = "netty_observable_adapter";
    private final BytesInspector bytesInspector;
    private final EventExecutorGroup handlersExecutorGroup;

    protected RxRequiredConfigurator(MetricEventsSubject eventsSubject, ChannelMetricEventProvider metricEventProvider) {
        this(eventsSubject, metricEventProvider, null);
    }

    protected RxRequiredConfigurator(MetricEventsSubject eventsSubject, ChannelMetricEventProvider metricEventProvider, EventExecutorGroup handlersExecutorGroup) {
        this.bytesInspector = new BytesInspector(eventsSubject, metricEventProvider);
        this.handlersExecutorGroup = handlersExecutorGroup;
    }

    @Override
    public void configureNewPipeline(ChannelPipeline pipeline) {
        ChannelHandler lifecycleHandler = this.newConnectionLifecycleHandler(pipeline);
        ObservableAdapter observableAdapter = new ObservableAdapter();
        pipeline.addFirst(BYTES_INSPECTOR_HANDLER_NAME, (ChannelHandler)this.bytesInspector);
        pipeline.addLast("primitive-converter", (ChannelHandler)PrimitiveConversionHandler.INSTANCE);
        pipeline.addLast(this.getConnectionLifecycleHandlerExecutor(), CONN_LIFECYCLE_HANDLER_NAME, lifecycleHandler);
        pipeline.addLast(this.getObservableAdapterExecutor(), NETTY_OBSERVABLE_ADAPTER_NAME, (ChannelHandler)observableAdapter);
    }

    protected EventExecutorGroup getConnectionLifecycleHandlerExecutor() {
        return this.handlersExecutorGroup;
    }

    protected EventExecutorGroup getObservableAdapterExecutor() {
        return this.handlersExecutorGroup;
    }

    protected abstract ChannelHandler newConnectionLifecycleHandler(ChannelPipeline var1);
}

