/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.kafka;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public abstract class Rule {
    TableName tableName;
    private byte[] columnFamily;
    private byte[] qualifier;
    boolean qualifierStartsWith = false;
    boolean qualifierEndsWith = false;
    byte[] ast = Bytes.toBytes((String)"*");

    public boolean match(TableName tryTable, byte[] tryColumFamily, byte[] tryQualifier) {
        boolean tableMatch = this.tableMatch(tryTable);
        boolean columnFamilyMatch = this.columnFamilyMatch(tryColumFamily);
        boolean qualfierMatch = this.qualifierMatch(tryQualifier);
        return tableMatch && columnFamilyMatch && qualfierMatch;
    }

    public boolean qualifierMatch(byte[] tryQualifier) {
        if (this.qualifier != null) {
            if (this.qualifierStartsWith && this.qualifierEndsWith) {
                return Rule.startsWith(tryQualifier, this.qualifier) || Rule.endsWith(tryQualifier, this.qualifier);
            }
            if (this.qualifierStartsWith) {
                return Rule.startsWith(tryQualifier, this.qualifier);
            }
            if (this.qualifierEndsWith) {
                return Rule.endsWith(tryQualifier, this.qualifier);
            }
            return Bytes.equals((byte[])this.qualifier, (byte[])tryQualifier);
        }
        return true;
    }

    public boolean columnFamilyMatch(byte[] tryColumFamily) {
        if (this.columnFamily != null) {
            return Bytes.equals((byte[])this.columnFamily, (byte[])tryColumFamily);
        }
        return true;
    }

    public boolean tableMatch(TableName tryTable) {
        if (this.tableName == null) {
            return true;
        }
        return tryTable.equals((Object)this.tableName);
    }

    public void setColumnFamily(byte[] columnFamily) {
        this.columnFamily = columnFamily;
    }

    public void setQualifier(byte[] qualifier) {
        this.qualifier = qualifier;
        if (Rule.startsWith(qualifier, this.ast)) {
            this.qualifierEndsWith = true;
            this.qualifier = ArrayUtils.subarray((byte[])this.qualifier, (int)this.ast.length, (int)this.qualifier.length);
        }
        if (Rule.endsWith(qualifier, this.ast)) {
            this.qualifierStartsWith = true;
            this.qualifier = ArrayUtils.subarray((byte[])this.qualifier, (int)0, (int)(this.qualifier.length - this.ast.length));
        }
        if ((this.qualifierStartsWith || this.qualifierEndsWith) && this.qualifier.length == 0) {
            this.qualifier = null;
        }
    }

    public static boolean startsWith(byte[] data, byte[] startsWith) {
        if (startsWith.length > data.length) {
            return false;
        }
        if (startsWith.length == data.length) {
            return Bytes.equals((byte[])data, (byte[])startsWith);
        }
        for (int i = 0; i < startsWith.length; ++i) {
            if (startsWith[i] == data[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean endsWith(byte[] data, byte[] endsWith) {
        if (endsWith.length > data.length) {
            return false;
        }
        if (endsWith.length == data.length) {
            return Bytes.equals((byte[])data, (byte[])endsWith);
        }
        int endStart = data.length - endsWith.length;
        for (int i = 0; i < endsWith.length; ++i) {
            if (endsWith[i] == data[endStart + i]) continue;
            return false;
        }
        return true;
    }

    public TableName getTableName() {
        return this.tableName;
    }

    public void setTableName(TableName tableName) {
        this.tableName = tableName;
    }

    public byte[] getColumnFamily() {
        return this.columnFamily;
    }

    public byte[] getQualifier() {
        return this.qualifier;
    }

    public boolean isQualifierEndsWith() {
        return this.qualifierEndsWith;
    }

    public boolean isQualifierStartsWith() {
        return this.qualifierStartsWith;
    }
}

