/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.spark;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.spark.HBaseConnectionCacheStat;
import org.apache.hadoop.hbase.spark.HBaseConnectionKey;
import org.apache.hadoop.hbase.spark.Logging;
import org.apache.hadoop.hbase.spark.SmartConnection;
import org.apache.hadoop.hbase.spark.SmartConnection$;
import org.apache.hadoop.hbase.spark.datasources.HBaseSparkConf$;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.collection.mutable.HashMap;
import scala.runtime.BoxedUnit;

@InterfaceAudience.Private
public final class HBaseConnectionCache$
implements Logging {
    public static HBaseConnectionCache$ MODULE$;
    private final HashMap<HBaseConnectionKey, SmartConnection> connectionMap;
    private final HBaseConnectionCacheStat cacheStat;
    private final long DEFAULT_TIME_OUT;
    private long org$apache$hadoop$hbase$spark$HBaseConnectionCache$$timeout;
    private boolean org$apache$hadoop$hbase$spark$HBaseConnectionCache$$closed;
    private Thread housekeepingThread;
    private transient Logger org$apache$hadoop$hbase$spark$Logging$$log_;

    static {
        new HBaseConnectionCache$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public Logger org$apache$hadoop$hbase$spark$Logging$$log_() {
        return this.org$apache$hadoop$hbase$spark$Logging$$log_;
    }

    @Override
    public void org$apache$hadoop$hbase$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$hadoop$hbase$spark$Logging$$log_ = x$1;
    }

    public HashMap<HBaseConnectionKey, SmartConnection> connectionMap() {
        return this.connectionMap;
    }

    public HBaseConnectionCacheStat cacheStat() {
        return this.cacheStat;
    }

    private final long DEFAULT_TIME_OUT() {
        return this.DEFAULT_TIME_OUT;
    }

    public long org$apache$hadoop$hbase$spark$HBaseConnectionCache$$timeout() {
        return this.org$apache$hadoop$hbase$spark$HBaseConnectionCache$$timeout;
    }

    private void org$apache$hadoop$hbase$spark$HBaseConnectionCache$$timeout_$eq(long x$1) {
        this.org$apache$hadoop$hbase$spark$HBaseConnectionCache$$timeout = x$1;
    }

    public boolean org$apache$hadoop$hbase$spark$HBaseConnectionCache$$closed() {
        return this.org$apache$hadoop$hbase$spark$HBaseConnectionCache$$closed;
    }

    private void org$apache$hadoop$hbase$spark$HBaseConnectionCache$$closed_$eq(boolean x$1) {
        this.org$apache$hadoop$hbase$spark$HBaseConnectionCache$$closed = x$1;
    }

    public Thread housekeepingThread() {
        return this.housekeepingThread;
    }

    public void housekeepingThread_$eq(Thread x$1) {
        this.housekeepingThread = x$1;
    }

    public HBaseConnectionCacheStat getStat() {
        HBaseConnectionCacheStat hBaseConnectionCacheStat;
        HashMap<HBaseConnectionKey, SmartConnection> hashMap = this.connectionMap();
        synchronized (hashMap) {
            this.cacheStat().numActiveConnections_$eq(this.connectionMap().size());
            hBaseConnectionCacheStat = this.cacheStat().copy(this.cacheStat().copy$default$1(), this.cacheStat().copy$default$2(), this.cacheStat().copy$default$3());
        }
        return hBaseConnectionCacheStat;
    }

    public void close() {
        block6: {
            try {
                HashMap<HBaseConnectionKey, SmartConnection> hashMap = this.connectionMap();
                synchronized (hashMap) {
                    block5: {
                        if (this.org$apache$hadoop$hbase$spark$HBaseConnectionCache$$closed()) break block5;
                        this.org$apache$hadoop$hbase$spark$HBaseConnectionCache$$closed_$eq(true);
                        this.housekeepingThread().interrupt();
                        this.housekeepingThread_$eq(null);
                        this.performHousekeeping(true);
                        break block6;
                    }
                    return;
                }
            }
            catch (Exception e) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error in finalHouseKeeping", e);
            }
        }
    }

    public void performHousekeeping(boolean forceClean) {
        long tsNow = System.currentTimeMillis();
        HashMap<HBaseConnectionKey, SmartConnection> hashMap = this.connectionMap();
        synchronized (hashMap) {
            this.connectionMap().foreach((Function1 & Serializable & scala.Serializable)x -> {
                BoxedUnit boxedUnit;
                if (((SmartConnection)x._2()).refCount() < 0) {
                    MODULE$.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Bug to be fixed: negative refCount of connection ").append(x._2()).toString());
                }
                if (forceClean || ((SmartConnection)x._2()).refCount() <= 0 && tsNow - ((SmartConnection)x._2()).timestamp() > MODULE$.org$apache$hadoop$hbase$spark$HBaseConnectionCache$$timeout()) {
                    try {
                        ((SmartConnection)x._2()).connection().close();
                    }
                    catch (IOException e) {
                        MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Fail to close connection ").append(x._2()).toString(), e);
                    }
                    boxedUnit = MODULE$.connectionMap().remove(x._1());
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            });
        }
    }

    public SmartConnection getConnection(HBaseConnectionKey key, Function0<Connection> conn) {
        SmartConnection smartConnection;
        block5: {
            HashMap<HBaseConnectionKey, SmartConnection> hashMap = this.connectionMap();
            synchronized (hashMap) {
                SmartConnection smartConnection2;
                block4: {
                    if (this.org$apache$hadoop$hbase$spark$HBaseConnectionCache$$closed()) {
                        smartConnection2 = null;
                        break block4;
                    }
                    this.cacheStat().numTotalRequests_$eq(this.cacheStat().numTotalRequests() + 1L);
                    SmartConnection sc = (SmartConnection)this.connectionMap().getOrElseUpdate((Object)key, (Function0 & Serializable & scala.Serializable)() -> {
                        MODULE$.cacheStat().numActualConnectionsCreated_$eq(MODULE$.cacheStat().numActualConnectionsCreated() + 1L);
                        return new SmartConnection((Connection)conn.apply(), SmartConnection$.MODULE$.$lessinit$greater$default$2(), SmartConnection$.MODULE$.$lessinit$greater$default$3());
                    });
                    sc.refCount_$eq(sc.refCount() + 1);
                    smartConnection = sc;
                    break block5;
                }
                return smartConnection2;
            }
        }
        return smartConnection;
    }

    public SmartConnection getConnection(Configuration conf) {
        return this.getConnection(new HBaseConnectionKey(conf), (Function0<Connection>)(Function0 & Serializable & scala.Serializable)() -> ConnectionFactory.createConnection((Configuration)conf));
    }

    public void setTimeout(long to) {
        block4: {
            HashMap<HBaseConnectionKey, SmartConnection> hashMap = this.connectionMap();
            synchronized (hashMap) {
                block3: {
                    if (this.org$apache$hadoop$hbase$spark$HBaseConnectionCache$$closed()) break block3;
                    this.org$apache$hadoop$hbase$spark$HBaseConnectionCache$$timeout_$eq(to);
                    this.housekeepingThread().interrupt();
                    break block4;
                }
                return;
            }
        }
    }

    private HBaseConnectionCache$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.connectionMap = new HashMap();
        this.cacheStat = new HBaseConnectionCacheStat(0L, 0L, 0L);
        this.DEFAULT_TIME_OUT = HBaseSparkConf$.MODULE$.DEFAULT_CONNECTION_CLOSE_DELAY();
        this.org$apache$hadoop$hbase$spark$HBaseConnectionCache$$timeout = this.DEFAULT_TIME_OUT();
        this.org$apache$hadoop$hbase$spark$HBaseConnectionCache$$closed = false;
        this.housekeepingThread = new Thread(new Runnable(){

            public void run() {
                while (true) {
                    try {
                        Thread.sleep(HBaseConnectionCache$.MODULE$.org$apache$hadoop$hbase$spark$HBaseConnectionCache$$timeout());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (HBaseConnectionCache$.MODULE$.org$apache$hadoop$hbase$spark$HBaseConnectionCache$$closed()) {
                        return;
                    }
                    HBaseConnectionCache$.MODULE$.performHousekeeping(false);
                }
            }
        });
        this.housekeepingThread().setDaemon(true);
        this.housekeepingThread().start();
    }
}

