/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.conf.ConfigurationManager;
import org.apache.hadoop.hbase.conf.PropagatingConfigurationObserver;
import org.apache.hadoop.hbase.io.hfile.PrefetchExecutor;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class PrefetchExecutorNotifier
implements PropagatingConfigurationObserver {
    private static final Logger LOG = LoggerFactory.getLogger(PrefetchExecutorNotifier.class);
    public static final String PREFETCH_DELAY = "hbase.hfile.prefetch.delay";
    private final Configuration conf;

    public PrefetchExecutorNotifier(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public void onConfigurationChange(Configuration newConf) {
        PrefetchExecutor.loadConfiguration(this.conf);
        LOG.info("Config hbase.hfile.prefetch.delay is changed to {}", (Object)this.conf.getInt(PREFETCH_DELAY, 1000));
    }

    @Override
    public void registerChildren(ConfigurationManager manager) {
    }

    @Override
    public void deregisterChildren(ConfigurationManager manager) {
    }

    public int getPrefetchDelay() {
        return PrefetchExecutor.getPrefetchDelay();
    }
}

