/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.CompactSplit;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.TestBulkloadBase;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.hamcrest.MockitoHamcrest;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@Category(value={SmallTests.class})
public class TestCompactionAfterBulkLoad
extends TestBulkloadBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCompactionAfterBulkLoad.class);
    private final RegionServerServices regionServerServices = (RegionServerServices)Mockito.mock(RegionServerServices.class);
    public static AtomicInteger called = new AtomicInteger(0);

    public TestCompactionAfterBulkLoad(boolean useFileBasedSFT) {
        super(useFileBasedSFT);
    }

    @Override
    protected HRegion testRegionWithFamiliesAndSpecifiedTableName(TableName tableName, byte[] ... families) throws IOException {
        RegionInfo hRegionInfo = RegionInfoBuilder.newBuilder((TableName)tableName).build();
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)tableName);
        for (byte[] family : families) {
            builder.setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])family));
        }
        ChunkCreator.initialize((int)0x200000, (boolean)false, (long)0L, (float)0.0f, (float)0.0f, null, (float)0.1f);
        return HRegion.createHRegion((RegionInfo)hRegionInfo, (Path)new Path(testFolder.newFolder().toURI()), (Configuration)this.conf, (TableDescriptor)builder.build(), (WAL)this.log, (boolean)true, (RegionServerServices)this.regionServerServices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldRequestCompactAllStoresAfterBulkLoad() throws IOException {
        TestCompactSplit compactSplit = new TestCompactSplit(HBaseConfiguration.create());
        called.set(0);
        ArrayList<Pair<byte[], String>> familyPaths = new ArrayList<Pair<byte[], String>>();
        for (int i = 0; i < 5; ++i) {
            familyPaths.addAll(this.withFamilyPathsFor(this.family1, this.family2, this.family3));
        }
        try {
            this.conf.setBoolean("hbase.compaction.after.bulkload.enable", true);
            Mockito.when((Object)this.regionServerServices.getConfiguration()).thenReturn((Object)this.conf);
            Mockito.when((Object)this.regionServerServices.getCompactionRequestor()).thenReturn((Object)compactSplit);
            Mockito.when((Object)this.log.appendMarker((RegionInfo)ArgumentMatchers.any(), (WALKeyImpl)ArgumentMatchers.any(), (WALEdit)MockitoHamcrest.argThat(TestCompactionAfterBulkLoad.bulkLogWalEditType(WALEdit.BULK_LOAD)))).thenAnswer(new Answer(){

                public Object answer(InvocationOnMock invocation) {
                    WALKeyImpl walKey = (WALKeyImpl)invocation.getArgument(1);
                    MultiVersionConcurrencyControl mvcc = walKey.getMvcc();
                    if (mvcc != null) {
                        MultiVersionConcurrencyControl.WriteEntry we = mvcc.begin();
                        walKey.setWriteEntry(we);
                    }
                    return 1L;
                }
            });
            HRegion region = this.testRegionWithFamilies(this.family1, this.family2, this.family3);
            region.bulkLoadHFiles(familyPaths, false, null);
            Assert.assertEquals((long)3L, (long)called.get());
        }
        finally {
            this.conf.setBoolean("hbase.compaction.after.bulkload.enable", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAvoidRepeatedlyRequestCompactAfterBulkLoad() throws IOException {
        TestFamily1UnderCompact compactSplit = new TestFamily1UnderCompact(HBaseConfiguration.create());
        called.set(0);
        ArrayList<Pair<byte[], String>> familyPaths = new ArrayList<Pair<byte[], String>>();
        for (int i = 0; i < 5; ++i) {
            familyPaths.addAll(this.withFamilyPathsFor(this.family1, this.family2, this.family3));
        }
        try {
            this.conf.setBoolean("hbase.compaction.after.bulkload.enable", true);
            Mockito.when((Object)this.regionServerServices.getConfiguration()).thenReturn((Object)this.conf);
            Mockito.when((Object)this.regionServerServices.getCompactionRequestor()).thenReturn((Object)compactSplit);
            Mockito.when((Object)this.log.appendMarker((RegionInfo)ArgumentMatchers.any(), (WALKeyImpl)ArgumentMatchers.any(), (WALEdit)MockitoHamcrest.argThat(TestCompactionAfterBulkLoad.bulkLogWalEditType(WALEdit.BULK_LOAD)))).thenAnswer(new Answer(){

                public Object answer(InvocationOnMock invocation) {
                    WALKeyImpl walKey = (WALKeyImpl)invocation.getArgument(1);
                    MultiVersionConcurrencyControl mvcc = walKey.getMvcc();
                    if (mvcc != null) {
                        MultiVersionConcurrencyControl.WriteEntry we = mvcc.begin();
                        walKey.setWriteEntry(we);
                    }
                    return 1L;
                }
            });
            HRegion region = this.testRegionWithFamilies(this.family1, this.family2, this.family3);
            region.bulkLoadHFiles(familyPaths, false, null);
            Assert.assertEquals((long)2L, (long)called.get());
        }
        finally {
            this.conf.setBoolean("hbase.compaction.after.bulkload.enable", false);
        }
    }

    private class TestFamily1UnderCompact
    extends TestCompactSplit {
        TestFamily1UnderCompact(Configuration conf) {
            super(conf);
        }

        public boolean isUnderCompaction(HStore s) {
            if (s.getColumnFamilyName().equals(Bytes.toString((byte[])TestCompactionAfterBulkLoad.this.family1))) {
                return true;
            }
            return super.isUnderCompaction(s);
        }
    }

    private class TestCompactSplit
    extends CompactSplit {
        TestCompactSplit(Configuration conf) {
            super(conf);
        }

        protected void requestCompactionInternal(HRegion region, HStore store, String why, int priority, boolean selectNow, CompactionLifeCycleTracker tracker, CompactSplit.CompactionCompleteTracker completeTracker, User user) throws IOException {
            called.addAndGet(1);
        }
    }
}

