/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import io.opentelemetry.context.Context;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClientSimpleScanner;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ClientAsyncPrefetchScanner
extends ClientSimpleScanner {
    private long maxCacheSize;
    private AtomicLong cacheSizeInBytes;
    private final Queue<Exception> exceptionsQueue;
    private Consumer<Boolean> prefetchListener;
    private final Lock lock = new ReentrantLock();
    private final Condition notEmpty = this.lock.newCondition();
    private final Condition notFull = this.lock.newCondition();

    public ClientAsyncPrefetchScanner(Configuration configuration, Scan scan, TableName name, ClusterConnection connection, RpcRetryingCallerFactory rpcCallerFactory, RpcControllerFactory rpcControllerFactory, ExecutorService pool, int scanReadRpcTimeout, int scannerTimeout, int replicaCallTimeoutMicroSecondScan) throws IOException {
        super(configuration, scan, name, connection, rpcCallerFactory, rpcControllerFactory, pool, scanReadRpcTimeout, scannerTimeout, replicaCallTimeoutMicroSecondScan);
        this.exceptionsQueue = new ConcurrentLinkedQueue<Exception>();
        Context context = Context.current();
        Runnable runnable = context.wrap((Runnable)new PrefetchRunnable());
        Threads.setDaemonThreadRunning((Thread)new Thread(runnable), (String)(name + ".asyncPrefetcher"));
    }

    void setPrefetchListener(Consumer<Boolean> prefetchListener) {
        this.prefetchListener = prefetchListener;
    }

    @Override
    protected void initCache() {
        this.cache = new LinkedBlockingQueue();
        this.maxCacheSize = this.resultSize2CacheSize(this.maxScannerResultSize);
        this.cacheSizeInBytes = new AtomicLong(0L);
    }

    private long resultSize2CacheSize(long maxResultSize) {
        return maxResultSize > 0x3FFFFFFFFFFFFFFFL ? maxResultSize : maxResultSize * 2L;
    }

    /*
     * Exception decompiling
     */
    @Override
    public Result next() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[UNCONDITIONALDOLOOP]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void close() {
        this.lock.lock();
        try {
            super.close();
            this.closed = true;
            this.notFull.signalAll();
            this.notEmpty.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    protected void addEstimatedSize(long estimatedSize) {
        this.cacheSizeInBytes.addAndGet(estimatedSize);
    }

    private void handleException() throws IOException {
        if (!this.exceptionsQueue.isEmpty()) {
            Exception first = this.exceptionsQueue.peek();
            first.printStackTrace();
            if (first instanceof IOException) {
                throw (IOException)first;
            }
            throw (RuntimeException)first;
        }
    }

    private boolean prefetchCondition() {
        return this.cacheSizeInBytes.get() < this.maxCacheSize / 2L;
    }

    private Result pollCache() {
        Result res = (Result)this.cache.poll();
        long estimatedSize = ConnectionUtils.calcEstimatedSize(res);
        this.addEstimatedSize(-estimatedSize);
        return res;
    }

    private class PrefetchRunnable
    implements Runnable {
        private PrefetchRunnable() {
        }

        @Override
        public void run() {
            while (!ClientAsyncPrefetchScanner.this.closed) {
                boolean succeed = false;
                try {
                    ClientAsyncPrefetchScanner.this.lock.lock();
                    while (!ClientAsyncPrefetchScanner.this.prefetchCondition()) {
                        ClientAsyncPrefetchScanner.this.notFull.await();
                    }
                    ClientAsyncPrefetchScanner.this.loadCache();
                    succeed = true;
                }
                catch (Exception e) {
                    ClientAsyncPrefetchScanner.this.exceptionsQueue.add(e);
                    ClientAsyncPrefetchScanner.this.span.recordException((Throwable)e);
                }
                finally {
                    ClientAsyncPrefetchScanner.this.notEmpty.signalAll();
                    ClientAsyncPrefetchScanner.this.lock.unlock();
                    if (ClientAsyncPrefetchScanner.this.prefetchListener == null) continue;
                    ClientAsyncPrefetchScanner.this.prefetchListener.accept(succeed);
                }
            }
        }
    }
}

