/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data.format;

import com.clickhouse.data.ClickHouseArraySequence;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseDataConfig;
import com.clickhouse.data.ClickHouseDataType;
import com.clickhouse.data.ClickHouseDeserializer;
import com.clickhouse.data.ClickHouseInputStream;
import com.clickhouse.data.ClickHouseOutputStream;
import com.clickhouse.data.ClickHouseSerializer;
import com.clickhouse.data.ClickHouseValue;
import com.clickhouse.data.ClickHouseValues;
import com.clickhouse.data.format.BinaryStreamUtils;
import com.clickhouse.data.value.ClickHouseIntegerValue;
import com.clickhouse.data.value.ClickHouseLongValue;
import com.clickhouse.data.value.ClickHouseShortValue;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;

public interface BinaryDataProcessor {
    public static ClickHouseValue readByteArray(ClickHouseValue ref, ClickHouseInputStream input) throws IOException {
        return ref.update(input.readBuffer(input.readVarInt()).compact().array());
    }

    public static ClickHouseValue readShortArray(ClickHouseValue ref, ClickHouseInputStream input) throws IOException {
        return ref.update(input.readBuffer(input.readVarInt() * 2).asShortArray());
    }

    public static ClickHouseValue readIntegerArray(ClickHouseValue ref, ClickHouseInputStream input) throws IOException {
        return ref.update(input.readBuffer(input.readVarInt() * 4).asIntegerArray());
    }

    public static ClickHouseValue readLongArray(ClickHouseValue ref, ClickHouseInputStream input) throws IOException {
        return ref.update(input.readBuffer(input.readVarInt() * 8).asLongArray());
    }

    public static ClickHouseValue readFloatArray(ClickHouseValue ref, ClickHouseInputStream input) throws IOException {
        return ref.update(input.readBuffer(input.readVarInt() * 4).asFloatArray());
    }

    public static ClickHouseValue readDoubleArray(ClickHouseValue ref, ClickHouseInputStream input) throws IOException {
        return ref.update(input.readBuffer(input.readVarInt() * 8).asDoubleArray());
    }

    public static ClickHouseValue readBool(ClickHouseValue ref, ClickHouseInputStream input) throws IOException {
        return ref.update(input.readBoolean());
    }

    public static void writeBool(ClickHouseValue value, ClickHouseOutputStream output) throws IOException {
        output.writeBoolean(value.asBoolean());
    }

    public static ClickHouseValue readEnum8(ClickHouseValue ref, ClickHouseInputStream input) throws IOException {
        return ref.update(input.readByte());
    }

    public static void writeEnum8(ClickHouseValue value, ClickHouseOutputStream output) throws IOException {
        output.writeByte(value.asByte());
    }

    public static ClickHouseValue readEnum16(ClickHouseValue ref, ClickHouseInputStream input) throws IOException {
        return ref.update(BinaryStreamUtils.readInt16(input));
    }

    public static void writeEnum16(ClickHouseValue value, ClickHouseOutputStream output) throws IOException {
        BinaryStreamUtils.writeInt16((OutputStream)output, value.asShort());
    }

    public static ClickHouseValue readByte(ClickHouseValue ref, ClickHouseInputStream input) throws IOException {
        return ref.update(input.readByte());
    }

    public static void writeByte(ClickHouseValue value, ClickHouseOutputStream output) throws IOException {
        output.writeByte(value.asByte());
    }

    public static ClickHouseValue readUInt8AsShort(ClickHouseValue ref, ClickHouseInputStream input) throws IOException {
        return ClickHouseShortValue.of(ref, input.readUnsignedByte(), false);
    }

    public static ClickHouseValue readShort(ClickHouseValue ref, ClickHouseInputStream input) throws IOException {
        return ref.update(BinaryStreamUtils.readInt16(input));
    }

    public static void writeShort(ClickHouseValue value, ClickHouseOutputStream output) throws IOException {
        BinaryStreamUtils.writeInt16((OutputStream)output, value.asShort());
    }

    public static ClickHouseValue readUInt16AsInt(ClickHouseValue ref, ClickHouseInputStream input) throws IOException {
        return ClickHouseIntegerValue.of(ref, input.readBuffer(2).asUnsignedShort(), false);
    }

    public static ClickHouseValue readInteger(ClickHouseValue ref, ClickHouseInputStream input) throws IOException {
        return ref.update(BinaryStreamUtils.readInt32(input));
    }

    public static void writeInteger(ClickHouseValue value, ClickHouseOutputStream output) throws IOException {
        BinaryStreamUtils.writeInt32(output, value.asInteger());
    }

    public static ClickHouseValue readUInt32AsLong(ClickHouseValue ref, ClickHouseInputStream input) throws IOException {
        return ClickHouseLongValue.of(ref, input.readBuffer(4).asUnsignedInteger(), false);
    }

    public static ClickHouseValue readLong(ClickHouseValue ref, ClickHouseInputStream input) throws IOException {
        return ref.update(input.readBuffer(8).asLong());
    }

    public static void writeLong(ClickHouseValue value, ClickHouseOutputStream output) throws IOException {
        BinaryStreamUtils.writeInt64(output, value.asLong());
    }

    public static ClickHouseValue readFloat(ClickHouseValue ref, ClickHouseInputStream input) throws IOException {
        return ref.update(input.readBuffer(4).asFloat());
    }

    public static void writeFloat(ClickHouseValue value, ClickHouseOutputStream output) throws IOException {
        BinaryStreamUtils.writeFloat32(output, value.asFloat());
    }

    public static ClickHouseValue readDouble(ClickHouseValue ref, ClickHouseInputStream input) throws IOException {
        return ref.update(input.readBuffer(8).asDouble());
    }

    public static void writeDouble(ClickHouseValue value, ClickHouseOutputStream output) throws IOException {
        BinaryStreamUtils.writeFloat64(output, value.asDouble());
    }

    public static ClickHouseValue readInt128(ClickHouseValue ref, ClickHouseInputStream input) throws IOException {
        return ref.update(input.readBuffer(16).asBigInteger());
    }

    public static void writeInt128(ClickHouseValue value, ClickHouseOutputStream output) throws IOException {
        BinaryStreamUtils.writeInt128(output, value.asBigInteger());
    }

    public static ClickHouseValue readUInt128(ClickHouseValue ref, ClickHouseInputStream input) throws IOException {
        return ref.update(input.readBuffer(16).asUnsignedBigInteger());
    }

    public static void writeUInt128(ClickHouseValue value, ClickHouseOutputStream output) throws IOException {
        BinaryStreamUtils.writeUnsignedInt128(output, value.asBigInteger());
    }

    public static ClickHouseValue readInt256(ClickHouseValue ref, ClickHouseInputStream input) throws IOException {
        return ref.update(input.readBuffer(32).asBigInteger());
    }

    public static void writeInt256(ClickHouseValue value, ClickHouseOutputStream output) throws IOException {
        BinaryStreamUtils.writeInt256(output, value.asBigInteger());
    }

    public static ClickHouseValue readUInt256(ClickHouseValue ref, ClickHouseInputStream input) throws IOException {
        return ref.update(input.readBuffer(32).asUnsignedBigInteger());
    }

    public static void writeUInt256(ClickHouseValue value, ClickHouseOutputStream output) throws IOException {
        BinaryStreamUtils.writeUnsignedInt256(output, value.asBigInteger());
    }

    public static ClickHouseValue readIpv4(ClickHouseValue ref, ClickHouseInputStream input) throws IOException {
        return ref.update(BinaryStreamUtils.readInet4Address(input));
    }

    public static void writeIpv4(ClickHouseValue value, ClickHouseOutputStream output) throws IOException {
        BinaryStreamUtils.writeInet4Address(output, value.asInet4Address());
    }

    public static ClickHouseValue readIpv6(ClickHouseValue ref, ClickHouseInputStream input) throws IOException {
        return ref.update(BinaryStreamUtils.readInet6Address(input));
    }

    public static void writeIpv6(ClickHouseValue value, ClickHouseOutputStream output) throws IOException {
        BinaryStreamUtils.writeInet6Address(output, value.asInet6Address());
    }

    public static ClickHouseValue readBinaryString(ClickHouseValue ref, ClickHouseInputStream input) throws IOException {
        return ref.update(input.readBytes(input.readVarInt()));
    }

    public static void writeBinaryString(ClickHouseValue value, ClickHouseOutputStream output) throws IOException {
        byte[] bytes = value.asBinary();
        output.writeVarInt(bytes.length).writeBytes(bytes);
    }

    public static ClickHouseValue readTextString(ClickHouseValue ref, ClickHouseInputStream input) throws IOException {
        return ref.update(input.readUnicodeString());
    }

    public static void writeTextString(ClickHouseValue value, ClickHouseOutputStream output) throws IOException {
        output.writeUnicodeString(value.asString());
    }

    public static ClickHouseValue readUuid(ClickHouseValue ref, ClickHouseInputStream input) throws IOException {
        return ref.update(BinaryStreamUtils.readUuid(input));
    }

    public static void writeUuid(ClickHouseValue value, ClickHouseOutputStream output) throws IOException {
        BinaryStreamUtils.writeUuid(output, value.asUuid());
    }

    public static ClickHouseValue readGeoPoint(ClickHouseValue ref, ClickHouseInputStream input) throws IOException {
        return ref.update(BinaryStreamUtils.readGeoPoint(input));
    }

    public static void writeGeoPoint(ClickHouseValue value, ClickHouseOutputStream output) throws IOException {
        BinaryStreamUtils.writeGeoPoint(output, value.asObject(double[].class));
    }

    public static ClickHouseValue readGeoRing(ClickHouseValue ref, ClickHouseInputStream input) throws IOException {
        return ref.update((Object[])BinaryStreamUtils.readGeoRing(input));
    }

    public static void writeGeoRing(ClickHouseValue value, ClickHouseOutputStream output) throws IOException {
        BinaryStreamUtils.writeGeoRing(output, value.asObject(double[][].class));
    }

    public static ClickHouseValue readGeoPolygon(ClickHouseValue ref, ClickHouseInputStream input) throws IOException {
        return ref.update((Object[])BinaryStreamUtils.readGeoPolygon(input));
    }

    public static void writeGeoPolygon(ClickHouseValue value, ClickHouseOutputStream output) throws IOException {
        BinaryStreamUtils.writeGeoPolygon(output, value.asObject(double[][][].class));
    }

    public static ClickHouseValue readGeoMultiPolygon(ClickHouseValue ref, ClickHouseInputStream input) throws IOException {
        return ref.update((Object[])BinaryStreamUtils.readGeoMultiPolygon(input));
    }

    public static void writeGeoMultiPolygon(ClickHouseValue value, ClickHouseOutputStream output) throws IOException {
        BinaryStreamUtils.writeGeoMultiPolygon(output, value.asObject(double[][][][].class));
    }

    public static class FixedStringSerDe
    extends FixedBytesSerDe {
        public FixedStringSerDe(ClickHouseColumn column) {
            super(column);
        }

        public FixedStringSerDe(int length) {
            super(length);
        }

        @Override
        public ClickHouseValue deserialize(ClickHouseValue ref, ClickHouseInputStream input) throws IOException {
            return ref.update(input.readBuffer(this.length).asUnicodeString());
        }
    }

    public static class FixedBytesSerDe
    implements ClickHouseDeserializer,
    ClickHouseSerializer {
        protected final int length;

        public FixedBytesSerDe(ClickHouseColumn column) {
            this(ClickHouseChecker.nonNull(column, "Column").getPrecision());
        }

        public FixedBytesSerDe(int length) {
            if (length < 1) {
                throw new IllegalArgumentException("Length should be greater than zero");
            }
            this.length = length;
        }

        @Override
        public ClickHouseValue deserialize(ClickHouseValue ref, ClickHouseInputStream input) throws IOException {
            return ref.update(input.readBuffer(this.length).compact().array());
        }

        @Override
        public void serialize(ClickHouseValue value, ClickHouseOutputStream output) throws IOException {
            byte[] bytes = value.asBinary();
            if (bytes.length != this.length) {
                byte[] b = new byte[this.length];
                System.arraycopy(bytes, 0, b, 0, Math.min(bytes.length, this.length));
                output.write(b);
            } else {
                output.write(bytes);
            }
        }
    }

    public static class Decimal256SerDe
    extends DecimalSerDe {
        private static final Map<Integer, DecimalSerDe> cache = new ConcurrentHashMap<Integer, DecimalSerDe>();

        public static final DecimalSerDe of(ClickHouseColumn column) {
            int scale = ClickHouseChecker.nonNull(column, "Column").getScale();
            return cache.computeIfAbsent(scale, Decimal256SerDe::new);
        }

        public Decimal256SerDe(ClickHouseColumn column) {
            this(ClickHouseChecker.nonNull(column, "Column").getScale());
        }

        public Decimal256SerDe(int scale) {
            super(ClickHouseChecker.between(scale, "scale", 0, ClickHouseDataType.Decimal256.getMaxScale()));
        }

        @Override
        public ClickHouseValue deserialize(ClickHouseValue ref, ClickHouseInputStream input) throws IOException {
            return ref.update(BinaryStreamUtils.readDecimal256(input, this.scale));
        }

        @Override
        public void serialize(ClickHouseValue value, ClickHouseOutputStream output) throws IOException {
            BigDecimal v = value.asBigDecimal();
            BinaryStreamUtils.writeInt256(output, ClickHouseChecker.between(this.scale == 0 ? v : v.multiply(BigDecimal.TEN.pow(this.scale)), "BigDecimal", BinaryStreamUtils.DECIMAL256_MIN, BinaryStreamUtils.DECIMAL256_MAX).toBigInteger());
        }
    }

    public static class Decimal128SerDe
    extends DecimalSerDe {
        private static final Map<Integer, DecimalSerDe> cache = new ConcurrentHashMap<Integer, DecimalSerDe>();

        public static final DecimalSerDe of(ClickHouseColumn column) {
            int scale = ClickHouseChecker.nonNull(column, "Column").getScale();
            return cache.computeIfAbsent(scale, Decimal128SerDe::new);
        }

        public Decimal128SerDe(ClickHouseColumn column) {
            this(ClickHouseChecker.nonNull(column, "Column").getScale());
        }

        public Decimal128SerDe(int scale) {
            super(ClickHouseChecker.between(scale, "scale", 0, ClickHouseDataType.Decimal128.getMaxScale()));
        }

        @Override
        public ClickHouseValue deserialize(ClickHouseValue ref, ClickHouseInputStream input) throws IOException {
            return ref.update(BinaryStreamUtils.readDecimal128(input, this.scale));
        }

        @Override
        public void serialize(ClickHouseValue value, ClickHouseOutputStream output) throws IOException {
            BigDecimal v = value.asBigDecimal();
            BinaryStreamUtils.writeInt128(output, ClickHouseChecker.between(this.scale == 0 ? v : v.multiply(BigDecimal.TEN.pow(this.scale)), "BigDecimal", BinaryStreamUtils.DECIMAL128_MIN, BinaryStreamUtils.DECIMAL128_MAX).toBigInteger());
        }
    }

    public static class Decimal64SerDe
    extends DecimalSerDe {
        private static final Map<Integer, DecimalSerDe> cache = new ConcurrentHashMap<Integer, DecimalSerDe>();

        public static final DecimalSerDe of(ClickHouseColumn column) {
            int scale = ClickHouseChecker.nonNull(column, "Column").getScale();
            return cache.computeIfAbsent(scale, Decimal64SerDe::new);
        }

        public Decimal64SerDe(ClickHouseColumn column) {
            this(ClickHouseChecker.nonNull(column, "Column").getScale());
        }

        public Decimal64SerDe(int scale) {
            super(ClickHouseChecker.between(scale, "scale", 0, ClickHouseDataType.Decimal64.getMaxScale()));
        }

        @Override
        public ClickHouseValue deserialize(ClickHouseValue ref, ClickHouseInputStream input) throws IOException {
            return ref.update(BigDecimal.valueOf(input.readBuffer(8).asLong(), this.scale));
        }

        @Override
        public void serialize(ClickHouseValue value, ClickHouseOutputStream output) throws IOException {
            BigDecimal v = value.asBigDecimal();
            BinaryStreamUtils.writeInt64(output, ClickHouseChecker.between(this.scale == 0 ? v : v.multiply(BigDecimal.TEN.pow(this.scale)), "BigDecimal", BinaryStreamUtils.DECIMAL64_MIN, BinaryStreamUtils.DECIMAL64_MAX).longValue());
        }
    }

    public static class Decimal32SerDe
    extends DecimalSerDe {
        private static final Map<Integer, DecimalSerDe> cache = new ConcurrentHashMap<Integer, DecimalSerDe>();

        public static final DecimalSerDe of(ClickHouseColumn column) {
            int scale = ClickHouseChecker.nonNull(column, "Column").getScale();
            return cache.computeIfAbsent(scale, Decimal32SerDe::new);
        }

        public Decimal32SerDe(int scale) {
            super(ClickHouseChecker.between(scale, "scale", 0, ClickHouseDataType.Decimal32.getMaxScale()));
        }

        @Override
        public ClickHouseValue deserialize(ClickHouseValue ref, ClickHouseInputStream input) throws IOException {
            return ref.update(BigDecimal.valueOf(input.readBuffer(4).asInteger(), this.scale));
        }

        @Override
        public void serialize(ClickHouseValue value, ClickHouseOutputStream output) throws IOException {
            BigDecimal v = value.asBigDecimal();
            BinaryStreamUtils.writeInt32(output, ClickHouseChecker.between(this.scale == 0 ? v : v.multiply(BigDecimal.TEN.pow(this.scale)), "BigDecimal", BinaryStreamUtils.DECIMAL32_MIN, BinaryStreamUtils.DECIMAL32_MAX).intValue());
        }
    }

    public static class DecimalSerDe
    implements ClickHouseDeserializer,
    ClickHouseSerializer {
        protected final int scale;

        public static DecimalSerDe of(ClickHouseColumn column) {
            return DecimalSerDe.of(ClickHouseChecker.nonNull(column, "Column").getPrecision(), column.getScale());
        }

        public static DecimalSerDe of(int precision, int scale) {
            if (precision > ClickHouseDataType.Decimal128.getMaxScale()) {
                return new Decimal256SerDe(scale);
            }
            if (precision > ClickHouseDataType.Decimal64.getMaxScale()) {
                return new Decimal128SerDe(scale);
            }
            if (precision > ClickHouseDataType.Decimal32.getMaxScale()) {
                return new Decimal64SerDe(scale);
            }
            return new Decimal32SerDe(scale);
        }

        public DecimalSerDe(int scale) {
            this.scale = scale;
        }

        @Override
        public ClickHouseValue deserialize(ClickHouseValue ref, ClickHouseInputStream input) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void serialize(ClickHouseValue value, ClickHouseOutputStream output) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    public static class DateTime64SerDe
    implements ClickHouseDeserializer,
    ClickHouseSerializer {
        private static final int[] BASES = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
        private static final Map<Integer, DateTime64SerDe> cache = new ConcurrentHashMap<Integer, DateTime64SerDe>();
        private final ZoneId zoneId;
        private final int scale;

        public static final DateTime64SerDe of(ClickHouseDataConfig config, ClickHouseColumn column) {
            TimeZone tz = ClickHouseChecker.nonNull(column, "Column").hasTimeZone() ? column.getTimeZone() : ClickHouseChecker.nonNull(config, "DataConfig").getUseTimeZone();
            int scale = column.getScale();
            return ClickHouseValues.UTC_TIMEZONE.equals(tz) ? cache.computeIfAbsent(scale, s -> new DateTime64SerDe((int)s, ClickHouseValues.UTC_TIMEZONE)) : new DateTime64SerDe(scale, tz);
        }

        public DateTime64SerDe(int scale, TimeZone tz) {
            this.scale = ClickHouseChecker.between(scale, "scale", 0, 9);
            this.zoneId = tz != null ? tz.toZoneId() : ClickHouseValues.UTC_ZONE;
        }

        @Override
        public ClickHouseValue deserialize(ClickHouseValue ref, ClickHouseInputStream input) throws IOException {
            long value = input.readBuffer(8).asLong();
            int nanoSeconds = 0;
            if (this.scale > 0) {
                int factor = BASES[this.scale];
                nanoSeconds = (int)(value % (long)factor);
                value /= (long)factor;
                if (nanoSeconds < 0) {
                    nanoSeconds += factor;
                    --value;
                }
                if ((long)nanoSeconds > 0L) {
                    nanoSeconds *= BASES[9 - this.scale];
                }
            }
            return ref.update(LocalDateTime.ofInstant(Instant.ofEpochSecond(value, nanoSeconds), this.zoneId));
        }

        @Override
        public void serialize(ClickHouseValue value, ClickHouseOutputStream output) throws IOException {
            LocalDateTime dt = value.asDateTime(this.scale);
            long v = ClickHouseChecker.between(ClickHouseValues.UTC_ZONE.equals(this.zoneId) ? dt.toEpochSecond(ZoneOffset.UTC) : dt.atZone(this.zoneId).toEpochSecond(), "DateTime", BinaryStreamUtils.DATETIME64_MIN, BinaryStreamUtils.DATETIME64_MAX);
            if (ClickHouseChecker.between(this.scale, "scale", 0, 9) > 0) {
                v *= (long)BASES[this.scale];
                int nanoSeconds = dt.getNano();
                if ((long)nanoSeconds > 0L) {
                    v += (long)(nanoSeconds / BASES[9 - this.scale]);
                }
            }
            BinaryStreamUtils.writeInt64(output, v);
        }
    }

    public static class DateTime32SerDe
    implements ClickHouseDeserializer,
    ClickHouseSerializer {
        private static final Map<TimeZone, DateTime32SerDe> cache = new ConcurrentHashMap<TimeZone, DateTime32SerDe>();
        protected final ZoneId zoneId;

        public static final DateTime32SerDe of(ClickHouseDataConfig config, ClickHouseColumn column) {
            TimeZone tz = ClickHouseChecker.nonNull(column, "Column").hasTimeZone() ? column.getTimeZone() : ClickHouseChecker.nonNull(config, "DataConfig").getUseTimeZone();
            return cache.computeIfAbsent(tz, DateTime32SerDe::new);
        }

        public DateTime32SerDe(TimeZone tz) {
            this.zoneId = tz != null ? tz.toZoneId() : ClickHouseValues.UTC_ZONE;
        }

        @Override
        public ClickHouseValue deserialize(ClickHouseValue ref, ClickHouseInputStream input) throws IOException {
            return ref.update(LocalDateTime.ofInstant(Instant.ofEpochSecond(input.readBuffer(4).asUnsignedInteger()), this.zoneId));
        }

        @Override
        public void serialize(ClickHouseValue value, ClickHouseOutputStream output) throws IOException {
            long time = ClickHouseValues.UTC_ZONE.equals(this.zoneId) ? value.asDateTime().toEpochSecond(ZoneOffset.UTC) : value.asDateTime().atZone(this.zoneId).toEpochSecond();
            BinaryStreamUtils.writeUnsignedInt32(output, ClickHouseChecker.between(time, "DateTime", 0L, 4294967295000L));
        }
    }

    public static class Date32SerDe
    implements ClickHouseDeserializer,
    ClickHouseSerializer {
        private static final Map<TimeZone, Date32SerDe> cache = new ConcurrentHashMap<TimeZone, Date32SerDe>();
        protected final ZoneId zoneId;

        public static final Date32SerDe of(ClickHouseDataConfig config) {
            TimeZone tz = ClickHouseChecker.nonNull(config, "DataConfig").getTimeZoneForDate();
            return cache.computeIfAbsent(tz == null ? ClickHouseValues.SYS_TIMEZONE : tz, Date32SerDe::new);
        }

        public Date32SerDe(TimeZone tz) {
            this.zoneId = tz != null ? tz.toZoneId() : ClickHouseValues.SYS_ZONE;
        }

        @Override
        public ClickHouseValue deserialize(ClickHouseValue ref, ClickHouseInputStream input) throws IOException {
            LocalDate d = LocalDate.ofEpochDay(input.readBuffer(4).asInteger());
            if (!ClickHouseValues.SYS_ZONE.equals(this.zoneId)) {
                d = d.atStartOfDay(ClickHouseValues.SYS_ZONE).withZoneSameInstant(this.zoneId).toLocalDate();
            }
            return ref.update(d);
        }

        @Override
        public void serialize(ClickHouseValue value, ClickHouseOutputStream output) throws IOException {
            LocalDate d = value.asDate();
            if (!ClickHouseValues.SYS_ZONE.equals(this.zoneId)) {
                d = d.atStartOfDay(this.zoneId).withZoneSameInstant(ClickHouseValues.SYS_ZONE).toLocalDate();
            }
            BinaryStreamUtils.writeInt32(output, ClickHouseChecker.between((int)d.toEpochDay(), "Date", BinaryStreamUtils.DATE32_MIN, BinaryStreamUtils.DATE32_MAX));
        }
    }

    public static class DateSerDe
    implements ClickHouseDeserializer,
    ClickHouseSerializer {
        private static final Map<TimeZone, DateSerDe> cache = new ConcurrentHashMap<TimeZone, DateSerDe>();
        protected final ZoneId zoneId;

        public static final DateSerDe of(ClickHouseDataConfig config) {
            TimeZone tz = ClickHouseChecker.nonNull(config, "DataConfig").getTimeZoneForDate();
            return cache.computeIfAbsent(tz == null ? ClickHouseValues.SYS_TIMEZONE : tz, DateSerDe::new);
        }

        public DateSerDe(TimeZone tz) {
            this.zoneId = tz != null ? tz.toZoneId() : ClickHouseValues.SYS_ZONE;
        }

        @Override
        public ClickHouseValue deserialize(ClickHouseValue ref, ClickHouseInputStream input) throws IOException {
            LocalDate d = LocalDate.ofEpochDay(input.readBuffer(2).asUnsignedShort());
            if (!ClickHouseValues.SYS_ZONE.equals(this.zoneId)) {
                d = d.atStartOfDay(ClickHouseValues.SYS_ZONE).withZoneSameInstant(this.zoneId).toLocalDate();
            }
            return ref.update(d);
        }

        @Override
        public void serialize(ClickHouseValue value, ClickHouseOutputStream output) throws IOException {
            LocalDate d = value.asDate();
            if (!ClickHouseValues.SYS_ZONE.equals(this.zoneId)) {
                d = d.atStartOfDay(this.zoneId).withZoneSameInstant(ClickHouseValues.SYS_ZONE).toLocalDate();
            }
            BinaryStreamUtils.writeUnsignedInt16(output, ClickHouseChecker.between((int)d.toEpochDay(), "Date", 0, 65535));
        }
    }

    public static class NullableSerializer
    implements ClickHouseSerializer {
        private final ClickHouseSerializer serializer;

        public NullableSerializer(ClickHouseSerializer serializer) {
            this.serializer = ClickHouseChecker.nonNull(serializer, "Serializer");
        }

        @Override
        public void serialize(ClickHouseValue value, ClickHouseOutputStream output) throws IOException {
            if (value.isNullOrEmpty()) {
                output.writeBoolean(true);
            } else {
                this.serializer.serialize(value, output.writeBoolean(false));
            }
        }
    }

    public static class NullableDeserializer
    implements ClickHouseDeserializer {
        private final ClickHouseDeserializer deserializer;

        public NullableDeserializer(ClickHouseDeserializer deserializer) {
            this.deserializer = ClickHouseChecker.nonNull(deserializer, "Deserializer");
        }

        @Override
        public ClickHouseValue deserialize(ClickHouseValue ref, ClickHouseInputStream input) throws IOException {
            return input.readBoolean() ? ref.resetToNullOrEmpty() : this.deserializer.deserialize(ref, input);
        }
    }

    public static class ArraySerializer
    extends ClickHouseSerializer.CompositeSerializer {
        private final long length;
        private final ClickHouseValue valValue;

        public ArraySerializer(ClickHouseDataConfig config, ClickHouseColumn column, boolean varLength, ClickHouseSerializer ... serializers) {
            this(config, column, varLength ? -1L : -2L, serializers);
        }

        public ArraySerializer(ClickHouseDataConfig config, ClickHouseColumn column, long length, ClickHouseSerializer ... serializers) {
            super(serializers);
            this.length = length;
            this.valValue = column.getNestedColumns().get(0).newValue(config);
        }

        @Override
        public void serialize(ClickHouseValue value, ClickHouseOutputStream output) throws IOException {
            ClickHouseArraySequence arr = (ClickHouseArraySequence)value;
            int len = (int)this.length;
            if (len == -1) {
                len = arr.length();
                output.writeVarInt(len);
            } else if (len < 0) {
                len = arr.length();
                output.writeVarInt(len);
            }
            ClickHouseSerializer s = this.serializers[0];
            for (int i = 0; i < len; ++i) {
                s.serialize(arr.getValue(i, this.valValue), output);
            }
        }
    }

    public static class ArrayDeserializer
    extends ClickHouseDeserializer.CompositeDeserializer {
        private final long length;
        private final int nestedLevel;
        private final Class<?> valClass;
        private final ClickHouseValue valValue;

        public ArrayDeserializer(ClickHouseDataConfig config, ClickHouseColumn column, boolean varLength, ClickHouseDeserializer ... deserializers) {
            this(config, column, varLength ? -1L : -2L, deserializers);
        }

        public ArrayDeserializer(ClickHouseDataConfig config, ClickHouseColumn column, long length, ClickHouseDeserializer ... deserializers) {
            super(deserializers);
            this.length = length;
            ClickHouseColumn baseColumn = column.getArrayBaseColumn();
            this.nestedLevel = column.getArrayNestedLevel();
            this.valClass = baseColumn.getObjectClassForArray(config);
            this.valValue = column.getNestedColumns().get(0).newValue(config);
        }

        @Override
        public ClickHouseValue deserialize(ClickHouseValue ref, ClickHouseInputStream input) throws IOException {
            int len = (int)this.length;
            if (len == -1) {
                len = input.readVarInt();
            } else if (len < 0) {
                len = (int)input.readBuffer(8).asLong();
            }
            if (len == 0) {
                return ref.resetToNullOrEmpty();
            }
            ClickHouseArraySequence arr = (ClickHouseArraySequence)ref;
            arr.allocate(len, this.valClass, this.nestedLevel);
            ClickHouseDeserializer d = this.deserializers[0];
            for (int i = 0; i < len; ++i) {
                arr.setValue(i, d.deserialize(this.valValue, input));
            }
            return ref;
        }
    }
}

