/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.prometheus;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.SSLException;
import org.apache.hertzbeat.collector.collect.common.http.CommonHttpClient;
import org.apache.hertzbeat.collector.collect.prometheus.PrometheusCollect;
import org.apache.hertzbeat.collector.util.CollectUtil;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.job.protocol.PrometheusProtocol;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.util.Base64Util;
import org.apache.hertzbeat.common.util.CommonUtil;
import org.apache.hertzbeat.common.util.IpDomainUtil;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.DigestScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class PrometheusProxyCollectImpl
implements PrometheusCollect {
    private static final Logger log = LoggerFactory.getLogger(PrometheusProxyCollectImpl.class);
    private final Set<Integer> defaultSuccessStatusCodes = Stream.of(200, 201, 202, 300, 301, 302).collect(Collectors.toSet());
    public static final String RAW_TEXT_CONTENT_FIELD_NAME = "raw_text_content";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CollectRep.MetricsData> collect(CollectRep.MetricsData.Builder builder, Metrics metrics) {
        PrometheusProtocol prometheusProtocol = metrics.getPrometheus();
        try {
            this.validateParams(metrics);
        }
        catch (Exception e) {
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg(e.getMessage());
            return Collections.singletonList(builder.build());
        }
        HttpContext httpContext = this.createHttpContext(prometheusProtocol);
        HttpUriRequest request = this.createHttpRequest(prometheusProtocol);
        try (CloseableHttpResponse response = CommonHttpClient.getHttpClient().execute(request, httpContext);){
            int statusCode = response.getStatusLine().getStatusCode();
            log.debug("Prometheus proxy collect, response status: {}", (Object)statusCode);
            if (!this.defaultSuccessStatusCodes.contains(statusCode)) {
                builder.setCode(CollectRep.Code.FAIL);
                builder.setMsg("StatusCode " + statusCode);
                List<CollectRep.MetricsData> list = Collections.singletonList(builder.build());
                return list;
            }
            String rawTextContent = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            builder.clearFields();
            builder.clearValues();
            CollectRep.Field rawDataField = CollectRep.Field.newBuilder().setName(RAW_TEXT_CONTENT_FIELD_NAME).setType(1).build();
            builder.addField(rawDataField);
            CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
            valueRowBuilder.addColumn(rawTextContent);
            builder.addValueRow(valueRowBuilder.build());
            builder.setCode(CollectRep.Code.SUCCESS);
        }
        catch (ClientProtocolException e1) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)e1);
            log.error("Prometheus proxy collect error: {}. Host: {}, Port: {}", new Object[]{errorMsg, prometheusProtocol.getHost(), prometheusProtocol.getPort(), e1});
            builder.setCode(CollectRep.Code.UN_CONNECTABLE);
            builder.setMsg(errorMsg);
        }
        catch (UnknownHostException e2) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)e2);
            log.info("Prometheus proxy collect unknown host: {}. Host: {}", new Object[]{errorMsg, prometheusProtocol.getHost(), e2});
            builder.setCode(CollectRep.Code.UN_REACHABLE);
            builder.setMsg("unknown host:" + errorMsg);
        }
        catch (InterruptedIOException | ConnectException | SSLException e3) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)e3);
            log.info("Prometheus proxy collect connect error: {}. Host: {}, Port: {}", new Object[]{errorMsg, prometheusProtocol.getHost(), prometheusProtocol.getPort(), e3});
            builder.setCode(CollectRep.Code.UN_CONNECTABLE);
            builder.setMsg(errorMsg);
        }
        catch (IOException e4) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)e4);
            log.info("Prometheus proxy collect IO error: {}. Host: {}, Port: {}", new Object[]{errorMsg, prometheusProtocol.getHost(), prometheusProtocol.getPort(), e4});
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg(errorMsg);
        }
        catch (Exception e) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)e);
            log.error("Prometheus proxy collect unknown error: {}. Host: {}, Port: {}", new Object[]{errorMsg, prometheusProtocol.getHost(), prometheusProtocol.getPort(), e});
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg(errorMsg);
        }
        finally {
            if (request != null) {
                request.abort();
            }
        }
        return Collections.singletonList(builder.build());
    }

    @Override
    public String supportProtocol() {
        return "prometheus";
    }

    private void validateParams(Metrics metrics) throws Exception {
        if (metrics == null || metrics.getPrometheus() == null) {
            throw new Exception("Prometheus collect must has prometheus params");
        }
        PrometheusProtocol protocol = metrics.getPrometheus();
        if (!StringUtils.hasText((String)protocol.getHost()) || !StringUtils.hasText((String)protocol.getPort())) {
            throw new Exception("Prometheus collect must has host and port params");
        }
        if (protocol.getPath() == null || !StringUtils.hasText((String)protocol.getPath()) || !protocol.getPath().startsWith("/")) {
            protocol.setPath((String)(protocol.getPath() == null ? "/" : "/" + protocol.getPath().trim()));
        }
    }

    public HttpContext createHttpContext(PrometheusProtocol protocol) {
        PrometheusProtocol.Authorization auth = protocol.getAuthorization();
        if (auth != null && "Digest Auth".equals(auth.getType())) {
            HttpClientContext clientContext = new HttpClientContext();
            if (StringUtils.hasText((String)auth.getDigestAuthUsername()) && StringUtils.hasText((String)auth.getDigestAuthPassword())) {
                BasicCredentialsProvider provider = new BasicCredentialsProvider();
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(auth.getDigestAuthUsername(), auth.getDigestAuthPassword());
                provider.setCredentials(AuthScope.ANY, (Credentials)credentials);
                BasicAuthCache authCache = new BasicAuthCache();
                HttpHost targetHost = new HttpHost(protocol.getHost(), Integer.parseInt(protocol.getPort()));
                authCache.put(targetHost, (AuthScheme)new DigestScheme());
                clientContext.setCredentialsProvider((CredentialsProvider)provider);
                clientContext.setAuthCache((AuthCache)authCache);
                return clientContext;
            }
        }
        return null;
    }

    public HttpUriRequest createHttpRequest(PrometheusProtocol protocol) {
        RequestBuilder requestBuilder = RequestBuilder.get();
        Map params = protocol.getParams();
        if (params != null && !params.isEmpty()) {
            for (Map.Entry param : params.entrySet()) {
                if (!StringUtils.hasText((String)((String)param.getValue()))) continue;
                requestBuilder.addParameter((String)param.getKey(), (String)param.getValue());
            }
        }
        requestBuilder.addHeader("Connection", "Keep-Alive");
        requestBuilder.addHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2272.76 Safari/537.36");
        Map headers = protocol.getHeaders();
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry entry : headers.entrySet()) {
                if (!StringUtils.hasText((String)((String)entry.getValue()))) continue;
                requestBuilder.addHeader(CollectUtil.replaceUriSpecialChar((String)((String)entry.getKey())), CollectUtil.replaceUriSpecialChar((String)((String)entry.getValue())));
            }
        }
        if (headers == null || headers.keySet().stream().noneMatch("Accept"::equalsIgnoreCase)) {
            requestBuilder.addHeader("Accept", "text/plain;version=0.0.4,*/*;q=0.1");
        }
        if (protocol.getAuthorization() != null) {
            PrometheusProtocol.Authorization authorization = protocol.getAuthorization();
            if ("Bearer Token".equalsIgnoreCase(authorization.getType())) {
                if (StringUtils.hasText((String)authorization.getBearerTokenToken())) {
                    String string = "Bearer " + authorization.getBearerTokenToken();
                    requestBuilder.addHeader("Authorization", string);
                }
            } else if ("Basic Auth".equals(authorization.getType()) && StringUtils.hasText((String)authorization.getBasicAuthUsername()) && StringUtils.hasText((String)authorization.getBasicAuthPassword())) {
                String string = authorization.getBasicAuthUsername() + ":" + authorization.getBasicAuthPassword();
                String encodedAuth = Base64Util.encode((String)string);
                requestBuilder.addHeader("Authorization", "Basic " + encodedAuth);
            }
        }
        if (StringUtils.hasLength((String)protocol.getPayload())) {
            requestBuilder.setEntity((HttpEntity)new StringEntity(protocol.getPayload(), StandardCharsets.UTF_8));
            if (headers == null || headers.keySet().stream().noneMatch("Content-Type"::equalsIgnoreCase)) {
                requestBuilder.setHeader("Content-Type", "text/plain");
            }
        }
        String uriPath = CollectUtil.replaceUriSpecialChar((String)protocol.getPath());
        if (IpDomainUtil.isHasSchema((String)protocol.getHost())) {
            requestBuilder.setUri(protocol.getHost() + ":" + protocol.getPort() + uriPath);
        } else {
            String string = IpDomainUtil.checkIpAddressType((String)protocol.getHost());
            String baseUri = "ipv6".equals(string) ? String.format("[%s]:%s%s", protocol.getHost(), protocol.getPort(), uriPath) : String.format("%s:%s%s", protocol.getHost(), protocol.getPort(), uriPath);
            boolean ssl = Boolean.parseBoolean(protocol.getSsl());
            if (ssl) {
                requestBuilder.setUri("https://" + baseUri);
            } else {
                requestBuilder.setUri("http://" + baseUri);
            }
        }
        int n = CollectUtil.getTimeout((String)protocol.getTimeout());
        if (n > 0) {
            requestConfig = RequestConfig.custom().setConnectTimeout(n).setSocketTimeout(n).setConnectionRequestTimeout(n).setRedirectsEnabled(true).build();
            requestBuilder.setConfig(requestConfig);
        } else {
            requestConfig = RequestConfig.custom().setRedirectsEnabled(true).build();
            requestBuilder.setConfig(requestConfig);
        }
        return requestBuilder.build();
    }

    public static PrometheusProxyCollectImpl getInstance() {
        return SingleInstance.INSTANCE;
    }

    private static class SingleInstance {
        private static final PrometheusProxyCollectImpl INSTANCE = new PrometheusProxyCollectImpl();

        private SingleInstance() {
        }
    }
}

